/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.CriticalHeaderParamsAware;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEDecrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEObjectJSON;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.KeyLengthException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.AESDecrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.DirectDecrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.ECDHDecrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.RSADecrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.X25519Decrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AAD;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.BaseJWEProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.CriticalHeaderParamsDeferral;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.JWEHeaderValidation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.MultiCryptoProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONObjectUtils;

@ThreadSafe
public class MultiDecrypter
extends MultiCryptoProvider
implements CriticalHeaderParamsAware,
JWEDecrypter {
    private final JWK jwk;
    private final String kid;
    private final URI x5u;
    private final Base64URL x5t;
    private final Base64URL x5t256;
    private final List<Base64> x5c;
    private final Base64URL thumbprint;
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();

    public MultiDecrypter(JWK jWK) throws JOSEException, KeyLengthException {
        this(jWK, null);
    }

    public MultiDecrypter(JWK jWK, Set<String> set) throws JOSEException, KeyLengthException {
        super(null);
        if (jWK == null) {
            throw new IllegalArgumentException("The private key (JWK) must not be null");
        }
        this.jwk = jWK;
        this.kid = jWK.getKeyID();
        this.x5c = jWK.getX509CertChain();
        this.x5u = jWK.getX509CertURL();
        this.x5t = jWK.getX509CertThumbprint();
        this.x5t256 = jWK.getX509CertSHA256Thumbprint();
        this.thumbprint = jWK.computeThumbprint();
        this.critPolicy.setDeferredCriticalHeaderParams(set);
    }

    @Override
    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    private boolean jwkMatched(JWEHeader jWEHeader) throws JOSEException {
        if (this.thumbprint.toString().equals(jWEHeader.getKeyID())) {
            return true;
        }
        JWK jWK = jWEHeader.getJWK();
        if (jWK != null && this.thumbprint.equals(jWK.computeThumbprint())) {
            return true;
        }
        if (this.x5u != null && this.x5u.equals(jWEHeader.getX509CertURL())) {
            return true;
        }
        if (this.x5t != null && this.x5t.equals(jWEHeader.getX509CertThumbprint())) {
            return true;
        }
        if (this.x5t256 != null && this.x5t256.equals(jWEHeader.getX509CertSHA256Thumbprint())) {
            return true;
        }
        List list = jWEHeader.getX509CertChain();
        if (this.x5c != null && list != null && this.x5c.containsAll(list) && list.containsAll(this.x5c)) {
            return true;
        }
        return this.kid != null && this.kid.equals(jWEHeader.getKeyID());
    }

    @Deprecated
    public byte[] decrypt(JWEHeader jWEHeader, Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4) throws JOSEException {
        return this.decrypt(jWEHeader, base64URL, base64URL2, base64URL3, base64URL4, AAD.compute(jWEHeader));
    }

    @Override
    public byte[] decrypt(JWEHeader jWEHeader, Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4, byte[] byArray) throws JOSEException {
        BaseJWEProvider baseJWEProvider;
        if (base64URL2 == null) {
            throw new JOSEException("Unexpected present JWE initialization vector (IV)");
        }
        if (base64URL4 == null) {
            throw new JOSEException("Missing JWE authentication tag");
        }
        if (byArray == null) {
            throw new JOSEException("Missing JWE additional authenticated data (AAD)");
        }
        KeyType keyType = this.jwk.getKeyType();
        Set<String> set = this.critPolicy.getDeferredCriticalHeaderParams();
        JWEObjectJSON.Recipient recipient = null;
        JWEHeader jWEHeader2 = null;
        try {
            for (Object object : JSONObjectUtils.getJSONArray(JSONObjectUtils.parse(base64URL.decodeToString()), "recipients")) {
                try {
                    recipient = JWEObjectJSON.Recipient.parse((Map)object);
                    jWEHeader2 = (JWEHeader)jWEHeader.join(recipient.getUnprotectedHeader());
                }
                catch (Exception exception) {
                    throw new JOSEException(exception.getMessage());
                }
                if (!this.jwkMatched(jWEHeader2)) {
                    jWEHeader2 = null;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            jWEHeader2 = jWEHeader;
            recipient = new JWEObjectJSON.Recipient(null, base64URL);
        }
        if (jWEHeader2 == null) {
            throw new JOSEException("No recipient found");
        }
        JWEAlgorithm jWEAlgorithm = JWEHeaderValidation.getAlgorithmAndEnsureNotNull(jWEHeader2);
        this.critPolicy.ensureHeaderPasses(jWEHeader2);
        if (KeyType.RSA.equals(keyType) && RSADecrypter.SUPPORTED_ALGORITHMS.contains(jWEAlgorithm)) {
            baseJWEProvider = new RSADecrypter(this.jwk.toRSAKey().toRSAPrivateKey(), set);
        } else if (KeyType.EC.equals(keyType) && ECDHDecrypter.SUPPORTED_ALGORITHMS.contains(jWEAlgorithm)) {
            baseJWEProvider = new ECDHDecrypter(this.jwk.toECKey().toECPrivateKey(), set);
        } else if (KeyType.OCT.equals(keyType) && AESDecrypter.SUPPORTED_ALGORITHMS.contains(jWEAlgorithm)) {
            baseJWEProvider = new AESDecrypter(this.jwk.toOctetSequenceKey().toSecretKey("AES"), set);
        } else if (KeyType.OCT.equals(keyType) && DirectDecrypter.SUPPORTED_ALGORITHMS.contains(jWEAlgorithm)) {
            baseJWEProvider = new DirectDecrypter(this.jwk.toOctetSequenceKey().toSecretKey("AES"), set);
        } else if (KeyType.OKP.equals(keyType) && X25519Decrypter.SUPPORTED_ALGORITHMS.contains(jWEAlgorithm)) {
            baseJWEProvider = new X25519Decrypter(this.jwk.toOctetKeyPair(), set);
        } else {
            throw new JOSEException("Unsupported algorithm");
        }
        return baseJWEProvider.decrypt(jWEHeader2, recipient.getEncryptedKey(), base64URL2, base64URL3, base64URL4, byArray);
    }
}

