/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClaimsRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpMethod;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAccount;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAcquireTokenParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ParameterValidationUtils;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.PopParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;

public class SilentParameters
implements IAcquireTokenParameters {
    @NonNull
    private Set<String> scopes;
    private IAccount account;
    private ClaimsRequest claims;
    private String authorityUrl;
    private boolean forceRefresh;
    private Map<String, String> extraHttpHeaders;
    private Map<String, String> extraQueryParameters;
    private String tenant;
    private PopParameters proofOfPossession;

    private static SilentParametersBuilder builder() {
        return new SilentParametersBuilder();
    }

    public static SilentParametersBuilder builder(Set<String> set, IAccount iAccount) {
        ParameterValidationUtils.validateNotNull("account", iAccount);
        ParameterValidationUtils.validateNotNull("scopes", set);
        return SilentParameters.builder().scopes(SilentParameters.removeEmptyScope(set)).account(iAccount);
    }

    public static SilentParametersBuilder builder(Set<String> set) {
        ParameterValidationUtils.validateNotNull("scopes", set);
        return SilentParameters.builder().scopes(SilentParameters.removeEmptyScope(set));
    }

    private static Set<String> removeEmptyScope(Set<String> set) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            if (string.equalsIgnoreCase(StringHelper.EMPTY_STRING)) continue;
            hashSet.add(string.trim());
        }
        return hashSet;
    }

    @Override
    @NonNull
    public Set<String> scopes() {
        return this.scopes;
    }

    public IAccount account() {
        return this.account;
    }

    @Override
    public ClaimsRequest claims() {
        return this.claims;
    }

    public String authorityUrl() {
        return this.authorityUrl;
    }

    public boolean forceRefresh() {
        return this.forceRefresh;
    }

    @Override
    public Map<String, String> extraHttpHeaders() {
        return this.extraHttpHeaders;
    }

    @Override
    public Map<String, String> extraQueryParameters() {
        return this.extraQueryParameters;
    }

    @Override
    public String tenant() {
        return this.tenant;
    }

    public PopParameters proofOfPossession() {
        return this.proofOfPossession;
    }

    private SilentParameters(@NonNull Set<String> set, IAccount iAccount, ClaimsRequest claimsRequest, String string, boolean bl2, Map<String, String> map, Map<String, String> map2, String string2, PopParameters popParameters) {
        if (set == null) {
            throw new NullPointerException("scopes is marked @NonNull but is null");
        }
        this.scopes = set;
        this.account = iAccount;
        this.claims = claimsRequest;
        this.authorityUrl = string;
        this.forceRefresh = bl2;
        this.extraHttpHeaders = map;
        this.extraQueryParameters = map2;
        this.tenant = string2;
        this.proofOfPossession = popParameters;
    }

    public static class SilentParametersBuilder {
        private Set<String> scopes;
        private IAccount account;
        private ClaimsRequest claims;
        private String authorityUrl;
        private boolean forceRefresh;
        private Map<String, String> extraHttpHeaders;
        private Map<String, String> extraQueryParameters;
        private String tenant;
        private PopParameters proofOfPossession;

        public SilentParametersBuilder proofOfPossession(HttpMethod httpMethod, URI uRI, String string) {
            this.proofOfPossession = new PopParameters(httpMethod, uRI, string);
            return this;
        }

        SilentParametersBuilder() {
        }

        public SilentParametersBuilder scopes(Set<String> set) {
            this.scopes = set;
            return this;
        }

        public SilentParametersBuilder account(IAccount iAccount) {
            this.account = iAccount;
            return this;
        }

        public SilentParametersBuilder claims(ClaimsRequest claimsRequest) {
            this.claims = claimsRequest;
            return this;
        }

        public SilentParametersBuilder authorityUrl(String string) {
            this.authorityUrl = string;
            return this;
        }

        public SilentParametersBuilder forceRefresh(boolean bl2) {
            this.forceRefresh = bl2;
            return this;
        }

        public SilentParametersBuilder extraHttpHeaders(Map<String, String> map) {
            this.extraHttpHeaders = map;
            return this;
        }

        public SilentParametersBuilder extraQueryParameters(Map<String, String> map) {
            this.extraQueryParameters = map;
            return this;
        }

        public SilentParametersBuilder tenant(String string) {
            this.tenant = string;
            return this;
        }

        public SilentParameters build() {
            return new SilentParameters(this.scopes, this.account, this.claims, this.authorityUrl, this.forceRefresh, this.extraHttpHeaders, this.extraQueryParameters, this.tenant, this.proofOfPossession);
        }

        public String toString() {
            return "SilentParameters.SilentParametersBuilder(scopes=" + this.scopes + ", account=" + this.account + ", claims=" + this.claims + ", authorityUrl=" + this.authorityUrl + ", forceRefresh=" + this.forceRefresh + ", extraHttpHeaders=" + this.extraHttpHeaders + ", extraQueryParameters=" + this.extraQueryParameters + ", tenant=" + this.tenant + ", proofOfPossession=" + this.proofOfPossession + ")";
        }
    }
}

