/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClaimsRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpMethod;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAcquireTokenParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ParameterValidationUtils;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.PopParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.Prompt;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.SystemBrowserOptions;

public class InteractiveRequestParameters
implements IAcquireTokenParameters {
    @NonNull
    private URI redirectUri;
    private ClaimsRequest claims;
    private Set<String> scopes;
    private Prompt prompt;
    private String loginHint;
    private String domainHint;
    private SystemBrowserOptions systemBrowserOptions;
    private String claimsChallenge;
    private Map<String, String> extraHttpHeaders;
    private Map<String, String> extraQueryParameters;
    private String tenant;
    private int httpPollingTimeoutInSeconds;
    private boolean instanceAware;
    private long windowHandle;
    private PopParameters proofOfPossession;

    private static InteractiveRequestParametersBuilder builder() {
        return new InteractiveRequestParametersBuilder();
    }

    public static InteractiveRequestParametersBuilder builder(URI uRI) {
        ParameterValidationUtils.validateNotNull("redirect_uri", uRI);
        return InteractiveRequestParameters.builder().redirectUri(uRI);
    }

    private static int $default$httpPollingTimeoutInSeconds() {
        return 120;
    }

    @NonNull
    public URI redirectUri() {
        return this.redirectUri;
    }

    @Override
    public ClaimsRequest claims() {
        return this.claims;
    }

    @Override
    public Set<String> scopes() {
        return this.scopes;
    }

    public Prompt prompt() {
        return this.prompt;
    }

    public String loginHint() {
        return this.loginHint;
    }

    public String domainHint() {
        return this.domainHint;
    }

    public SystemBrowserOptions systemBrowserOptions() {
        return this.systemBrowserOptions;
    }

    public String claimsChallenge() {
        return this.claimsChallenge;
    }

    @Override
    public Map<String, String> extraHttpHeaders() {
        return this.extraHttpHeaders;
    }

    @Override
    public Map<String, String> extraQueryParameters() {
        return this.extraQueryParameters;
    }

    @Override
    public String tenant() {
        return this.tenant;
    }

    public int httpPollingTimeoutInSeconds() {
        return this.httpPollingTimeoutInSeconds;
    }

    public boolean instanceAware() {
        return this.instanceAware;
    }

    public long windowHandle() {
        return this.windowHandle;
    }

    public PopParameters proofOfPossession() {
        return this.proofOfPossession;
    }

    private InteractiveRequestParameters(@NonNull URI uRI, ClaimsRequest claimsRequest, Set<String> set, Prompt prompt, String string, String string2, SystemBrowserOptions systemBrowserOptions, String string3, Map<String, String> map, Map<String, String> map2, String string4, int n2, boolean bl2, long l2, PopParameters popParameters) {
        if (uRI == null) {
            throw new NullPointerException("redirectUri is marked @NonNull but is null");
        }
        this.redirectUri = uRI;
        this.claims = claimsRequest;
        this.scopes = set;
        this.prompt = prompt;
        this.loginHint = string;
        this.domainHint = string2;
        this.systemBrowserOptions = systemBrowserOptions;
        this.claimsChallenge = string3;
        this.extraHttpHeaders = map;
        this.extraQueryParameters = map2;
        this.tenant = string4;
        this.httpPollingTimeoutInSeconds = n2;
        this.instanceAware = bl2;
        this.windowHandle = l2;
        this.proofOfPossession = popParameters;
    }

    InteractiveRequestParameters redirectUri(@NonNull URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("redirectUri is marked @NonNull but is null");
        }
        this.redirectUri = uRI;
        return this;
    }

    public static class InteractiveRequestParametersBuilder {
        private URI redirectUri;
        private ClaimsRequest claims;
        private Set<String> scopes;
        private Prompt prompt;
        private String loginHint;
        private String domainHint;
        private SystemBrowserOptions systemBrowserOptions;
        private String claimsChallenge;
        private Map<String, String> extraHttpHeaders;
        private Map<String, String> extraQueryParameters;
        private String tenant;
        private boolean httpPollingTimeoutInSeconds$set;
        private int httpPollingTimeoutInSeconds;
        private boolean instanceAware;
        private long windowHandle;
        private PopParameters proofOfPossession;

        public InteractiveRequestParametersBuilder proofOfPossession(HttpMethod httpMethod, URI uRI, String string) {
            this.proofOfPossession = new PopParameters(httpMethod, uRI, string);
            return this;
        }

        InteractiveRequestParametersBuilder() {
        }

        public InteractiveRequestParametersBuilder redirectUri(URI uRI) {
            this.redirectUri = uRI;
            return this;
        }

        public InteractiveRequestParametersBuilder claims(ClaimsRequest claimsRequest) {
            this.claims = claimsRequest;
            return this;
        }

        public InteractiveRequestParametersBuilder scopes(Set<String> set) {
            this.scopes = set;
            return this;
        }

        public InteractiveRequestParametersBuilder prompt(Prompt prompt) {
            this.prompt = prompt;
            return this;
        }

        public InteractiveRequestParametersBuilder loginHint(String string) {
            this.loginHint = string;
            return this;
        }

        public InteractiveRequestParametersBuilder domainHint(String string) {
            this.domainHint = string;
            return this;
        }

        public InteractiveRequestParametersBuilder systemBrowserOptions(SystemBrowserOptions systemBrowserOptions) {
            this.systemBrowserOptions = systemBrowserOptions;
            return this;
        }

        public InteractiveRequestParametersBuilder claimsChallenge(String string) {
            this.claimsChallenge = string;
            return this;
        }

        public InteractiveRequestParametersBuilder extraHttpHeaders(Map<String, String> map) {
            this.extraHttpHeaders = map;
            return this;
        }

        public InteractiveRequestParametersBuilder extraQueryParameters(Map<String, String> map) {
            this.extraQueryParameters = map;
            return this;
        }

        public InteractiveRequestParametersBuilder tenant(String string) {
            this.tenant = string;
            return this;
        }

        public InteractiveRequestParametersBuilder httpPollingTimeoutInSeconds(int n2) {
            this.httpPollingTimeoutInSeconds = n2;
            this.httpPollingTimeoutInSeconds$set = true;
            return this;
        }

        public InteractiveRequestParametersBuilder instanceAware(boolean bl2) {
            this.instanceAware = bl2;
            return this;
        }

        public InteractiveRequestParametersBuilder windowHandle(long l2) {
            this.windowHandle = l2;
            return this;
        }

        public InteractiveRequestParameters build() {
            int n2 = this.httpPollingTimeoutInSeconds;
            if (!this.httpPollingTimeoutInSeconds$set) {
                n2 = InteractiveRequestParameters.$default$httpPollingTimeoutInSeconds();
            }
            return new InteractiveRequestParameters(this.redirectUri, this.claims, this.scopes, this.prompt, this.loginHint, this.domainHint, this.systemBrowserOptions, this.claimsChallenge, this.extraHttpHeaders, this.extraQueryParameters, this.tenant, n2, this.instanceAware, this.windowHandle, this.proofOfPossession);
        }

        public String toString() {
            return "InteractiveRequestParameters.InteractiveRequestParametersBuilder(redirectUri=" + this.redirectUri + ", claims=" + this.claims + ", scopes=" + this.scopes + ", prompt=" + (Object)((Object)this.prompt) + ", loginHint=" + this.loginHint + ", domainHint=" + this.domainHint + ", systemBrowserOptions=" + this.systemBrowserOptions + ", claimsChallenge=" + this.claimsChallenge + ", extraHttpHeaders=" + this.extraHttpHeaders + ", extraQueryParameters=" + this.extraQueryParameters + ", tenant=" + this.tenant + ", httpPollingTimeoutInSeconds=" + this.httpPollingTimeoutInSeconds + ", instanceAware=" + this.instanceAware + ", windowHandle=" + this.windowHandle + ", proofOfPossession=" + this.proofOfPossession + ")";
        }
    }
}

