/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.URI;
import java.util.ArrayList;
import java.util.Locale;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.Event;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.XmsClientTelemetryInfo;

class HttpEvent
extends Event {
    private static final String HTTP_PATH_KEY = "msal.http_path";
    private static final String USER_AGENT_KEY = "msal.user_agent";
    private static final String QUERY_PARAMETERS_KEY = "msal.query_parameters";
    private static final String API_VERSION_KEY = "msal.api_version";
    private static final String RESPONSE_CODE_KEY = "msal.response_code";
    private static final String OAUTH_ERROR_CODE_KEY = "msal.oauth_error_code";
    private static final String HTTP_METHOD_KEY = "msal.http_method";
    private static final String REQUEST_ID_HEADER_KEY = "msal.request_id_header";
    private static final String TOKEN_AGEN_KEY = "msal.token_age";
    private static final String SPE_INFO_KEY = "msal.spe_info";
    private static final String SERVER_ERROR_CODE_KEY = "msal.server_error_code";
    private static final String SERVER_SUB_ERROR_CODE_KEY = "msal.server_sub_error_code";

    HttpEvent() {
        super("msal.http_event");
    }

    void setHttpPath(URI uRI) {
        this.put(HTTP_PATH_KEY, HttpEvent.scrubTenant(uRI));
    }

    void setUserAgent(String string) {
        this.put(USER_AGENT_KEY, string.toLowerCase(Locale.ROOT));
    }

    void setQueryParameters(String string) {
        this.put(QUERY_PARAMETERS_KEY, String.join((CharSequence)"&", this.parseQueryParametersAndReturnKeys(string)));
    }

    void setApiVersion(String string) {
        this.put(API_VERSION_KEY, string.toLowerCase());
    }

    void setHttpResponseStatus(Integer n2) {
        this.put(RESPONSE_CODE_KEY, n2.toString().toLowerCase());
    }

    void setHttpMethod(String string) {
        this.put(HTTP_METHOD_KEY, string);
    }

    void setOauthErrorCode(String string) {
        this.put(OAUTH_ERROR_CODE_KEY, string.toLowerCase());
    }

    void setRequestIdHeader(String string) {
        this.put(REQUEST_ID_HEADER_KEY, string.toLowerCase());
    }

    private void setTokenAge(String string) {
        this.put(TOKEN_AGEN_KEY, string.toLowerCase());
    }

    private void setSpeInfo(String string) {
        this.put(SPE_INFO_KEY, string.toLowerCase());
    }

    private void setServerErrorCode(String string) {
        this.put(SERVER_ERROR_CODE_KEY, string.toLowerCase());
    }

    private void setSubServerErrorCode(String string) {
        this.put(SERVER_SUB_ERROR_CODE_KEY, string.toLowerCase());
    }

    void setXmsClientTelemetryInfo(XmsClientTelemetryInfo xmsClientTelemetryInfo) {
        this.setTokenAge(xmsClientTelemetryInfo.getTokenAge());
        this.setSpeInfo(xmsClientTelemetryInfo.getSpeInfo());
        this.setServerErrorCode(xmsClientTelemetryInfo.getServerErrorCode());
        this.setSubServerErrorCode(xmsClientTelemetryInfo.getServerSubErrorCode());
    }

    private ArrayList<String> parseQueryParametersAndReturnKeys(String string) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray = string.split("&")) {
            String[] stringArray2 = string2.split("=");
            if (stringArray2.length != 2 || StringHelper.isBlank(stringArray2[0]) || StringHelper.isBlank(stringArray2[1])) continue;
            arrayList.add(stringArray2[0].toLowerCase(Locale.ROOT));
        }
        return arrayList;
    }
}

