/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpMethod;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IHttpClient;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IHttpResponse;
import macromedia.jdbc.sqlserver.externals.org.slf4j.Logger;
import macromedia.jdbc.sqlserver.externals.org.slf4j.LoggerFactory;

class DefaultHttpClient
implements IHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpClient.class);
    final Proxy proxy;
    final SSLSocketFactory sslSocketFactory;
    int connectTimeout = 0;
    int readTimeout = 0;

    DefaultHttpClient(Proxy proxy, SSLSocketFactory sSLSocketFactory, Integer n2, Integer n3) {
        this.proxy = proxy;
        this.sslSocketFactory = sSLSocketFactory;
        if (n2 != null) {
            this.connectTimeout = n2;
        }
        if (n3 != null) {
            this.readTimeout = n3;
        }
    }

    @Override
    public IHttpResponse send(HttpRequest httpRequest) throws Exception {
        HttpResponse httpResponse = null;
        if (httpRequest.httpMethod() == HttpMethod.GET) {
            httpResponse = this.executeHttpGet(httpRequest);
        } else if (httpRequest.httpMethod() == HttpMethod.POST) {
            httpResponse = this.executeHttpPost(httpRequest);
        }
        return httpResponse;
    }

    private HttpResponse executeHttpGet(HttpRequest httpRequest) throws Exception {
        HttpURLConnection httpURLConnection = this.openConnection(httpRequest.url());
        this.configureAdditionalHeaders(httpURLConnection, httpRequest);
        return this.readResponseFromConnection(httpURLConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse executeHttpPost(HttpRequest httpRequest) throws Exception {
        HttpURLConnection httpURLConnection = this.openConnection(httpRequest.url());
        this.configureAdditionalHeaders(httpURLConnection, httpRequest);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setDoOutput(true);
        try (DataOutputStream dataOutputStream = null;){
            dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            dataOutputStream.writeBytes(httpRequest.body());
            dataOutputStream.flush();
            HttpResponse httpResponse = this.readResponseFromConnection(httpURLConnection);
            return httpResponse;
        }
    }

    HttpURLConnection openConnection(URL uRL) throws IOException {
        URLConnection uRLConnection = this.proxy != null ? uRL.openConnection(this.proxy) : uRL.openConnection();
        uRLConnection.setConnectTimeout(this.connectTimeout);
        uRLConnection.setReadTimeout(this.readTimeout);
        if (uRLConnection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRLConnection;
            if (this.sslSocketFactory != null) {
                httpsURLConnection.setSSLSocketFactory(this.sslSocketFactory);
            }
            return httpsURLConnection;
        }
        return (HttpURLConnection)uRLConnection;
    }

    private void configureAdditionalHeaders(HttpURLConnection httpURLConnection, HttpRequest httpRequest) {
        if (httpRequest.headers() != null) {
            for (Map.Entry<String, String> entry : httpRequest.headers().entrySet()) {
                if (entry.getValue() == null) continue;
                httpURLConnection.addRequestProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    private HttpResponse readResponseFromConnection(HttpURLConnection httpURLConnection) throws IOException {
        try (InputStream inputStream = null;){
            HttpResponse httpResponse = new HttpResponse();
            int n2 = httpURLConnection.getResponseCode();
            httpResponse.statusCode(n2);
            if (n2 != 200) {
                inputStream = httpURLConnection.getErrorStream();
                if (inputStream != null) {
                    httpResponse.addHeaders(httpURLConnection.getHeaderFields());
                    httpResponse.body(this.inputStreamToString(inputStream));
                }
                HttpResponse httpResponse2 = httpResponse;
                return httpResponse2;
            }
            inputStream = httpURLConnection.getInputStream();
            httpResponse.addHeaders(httpURLConnection.getHeaderFields());
            httpResponse.body(this.inputStreamToString(inputStream));
            HttpResponse httpResponse3 = httpResponse;
            return httpResponse3;
        }
    }

    private String inputStreamToString(InputStream inputStream) {
        Scanner scanner = new Scanner(inputStream, StandardCharsets.UTF_8.name()).useDelimiter("\\A");
        return scanner.hasNext() ? scanner.next() : "";
    }
}

