/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AbstractClientApplicationBase;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AppTokenProviderParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthenticationResultSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClientCredentialRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalAzureSDKException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.TokenProviderResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.TokenRequestExecutor;

class AcquireTokenByAppProviderSupplier
extends AuthenticationResultSupplier {
    private static final int TWO_HOURS = 7200;
    private AppTokenProviderParameters appTokenProviderParameters;
    private ClientCredentialRequest clientCredentialRequest;

    AcquireTokenByAppProviderSupplier(AbstractClientApplicationBase abstractClientApplicationBase, ClientCredentialRequest clientCredentialRequest, AppTokenProviderParameters appTokenProviderParameters) {
        super(abstractClientApplicationBase, clientCredentialRequest);
        this.clientCredentialRequest = clientCredentialRequest;
        this.appTokenProviderParameters = appTokenProviderParameters;
    }

    private static void validateAndUpdateTokenProviderResult(TokenProviderResult tokenProviderResult) {
        long l2;
        if (null == tokenProviderResult.getAccessToken() || tokenProviderResult.getAccessToken().isEmpty()) {
            AcquireTokenByAppProviderSupplier.handleInvalidExternalValueError(tokenProviderResult.getAccessToken());
        }
        if (tokenProviderResult.getExpiresInSeconds() == 0L || tokenProviderResult.getExpiresInSeconds() < 0L) {
            AcquireTokenByAppProviderSupplier.handleInvalidExternalValueError(Long.valueOf(tokenProviderResult.getExpiresInSeconds()).toString());
        }
        if (null == tokenProviderResult.getTenantId() || tokenProviderResult.getTenantId().isEmpty()) {
            AcquireTokenByAppProviderSupplier.handleInvalidExternalValueError(tokenProviderResult.getTenantId());
        }
        if (0L == tokenProviderResult.getRefreshInSeconds() && (l2 = tokenProviderResult.getExpiresInSeconds()) >= 7200L) {
            tokenProviderResult.setRefreshInSeconds(l2 / 2L);
        }
    }

    private static void handleInvalidExternalValueError(String string) {
        throw new MsalClientException("The following token provider result value is invalid" + string, "Invalid_TokenProviderResult_Input");
    }

    @Override
    AuthenticationResult execute() throws Exception {
        AuthenticationResult authenticationResult = this.fetchTokenUsingAppTokenProvider(this.appTokenProviderParameters);
        TokenRequestExecutor tokenRequestExecutor = new TokenRequestExecutor(this.clientCredentialRequest.application().authenticationAuthority, this.msalRequest, this.clientApplication.serviceBundle());
        this.clientApplication.tokenCache.saveTokens(tokenRequestExecutor, authenticationResult, this.clientCredentialRequest.application().authenticationAuthority.host);
        return authenticationResult;
    }

    public AuthenticationResult fetchTokenUsingAppTokenProvider(AppTokenProviderParameters appTokenProviderParameters) throws ExecutionException, InterruptedException {
        TokenProviderResult tokenProviderResult;
        try {
            CompletableFuture<TokenProviderResult> completableFuture = this.clientCredentialRequest.appTokenProvider.apply(appTokenProviderParameters);
            tokenProviderResult = completableFuture.get();
        }
        catch (Exception exception) {
            throw new MsalAzureSDKException(exception);
        }
        AcquireTokenByAppProviderSupplier.validateAndUpdateTokenProviderResult(tokenProviderResult);
        return AuthenticationResult.builder().accessToken(tokenProviderResult.getAccessToken()).refreshToken(null).idToken(null).expiresOn(tokenProviderResult.getExpiresInSeconds()).refreshOn(tokenProviderResult.getRefreshInSeconds()).build();
    }
}

