/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.google.gson.internal.sql;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import macromedia.jdbc.sqlserver.externals.com.google.gson.Gson;
import macromedia.jdbc.sqlserver.externals.com.google.gson.JsonSyntaxException;
import macromedia.jdbc.sqlserver.externals.com.google.gson.TypeAdapter;
import macromedia.jdbc.sqlserver.externals.com.google.gson.TypeAdapterFactory;
import macromedia.jdbc.sqlserver.externals.com.google.gson.reflect.TypeToken;
import macromedia.jdbc.sqlserver.externals.com.google.gson.stream.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.google.gson.stream.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.google.gson.stream.JsonWriter;

final class SqlDateTypeAdapter
extends TypeAdapter<java.sql.Date> {
    static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == java.sql.Date.class ? new SqlDateTypeAdapter() : null;
        }
    };
    private final DateFormat format = new SimpleDateFormat("MMM d, yyyy");

    private SqlDateTypeAdapter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public java.sql.Date read(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        String string = jsonReader.nextString();
        try {
            Date date;
            SqlDateTypeAdapter sqlDateTypeAdapter = this;
            synchronized (sqlDateTypeAdapter) {
                date = this.format.parse(string);
            }
            return new java.sql.Date(date.getTime());
        }
        catch (ParseException parseException) {
            throw new JsonSyntaxException("Failed parsing '" + string + "' as SQL Date; at path " + jsonReader.getPreviousPath(), parseException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(JsonWriter jsonWriter, java.sql.Date date) throws IOException {
        String string;
        if (date == null) {
            jsonWriter.nullValue();
            return;
        }
        SqlDateTypeAdapter sqlDateTypeAdapter = this;
        synchronized (sqlDateTypeAdapter) {
            string = this.format.format(date);
        }
        jsonWriter.value(string);
    }
}

