/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.datatype.jsr310.deser;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonFormat;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.BeanProperty;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JavaType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;

public class LocalDateTimeDeserializer
extends JSR310DateTimeDeserializerBase<LocalDateTime> {
    private static final long serialVersionUID = 1L;
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    public static final LocalDateTimeDeserializer INSTANCE = new LocalDateTimeDeserializer();
    protected final Boolean _readTimestampsAsNanosOverride;

    protected LocalDateTimeDeserializer() {
        this(DEFAULT_FORMATTER);
    }

    public LocalDateTimeDeserializer(DateTimeFormatter dateTimeFormatter) {
        super(LocalDateTime.class, dateTimeFormatter);
        this._readTimestampsAsNanosOverride = null;
    }

    protected LocalDateTimeDeserializer(LocalDateTimeDeserializer localDateTimeDeserializer, Boolean bl2) {
        super(localDateTimeDeserializer, bl2);
        this._readTimestampsAsNanosOverride = localDateTimeDeserializer._readTimestampsAsNanosOverride;
    }

    protected LocalDateTimeDeserializer(LocalDateTimeDeserializer localDateTimeDeserializer, Boolean bl2, DateTimeFormatter dateTimeFormatter, JsonFormat.Shape shape, Boolean bl3) {
        super(localDateTimeDeserializer, bl2, dateTimeFormatter, shape);
        this._readTimestampsAsNanosOverride = bl3;
    }

    protected LocalDateTimeDeserializer withDateFormat(DateTimeFormatter dateTimeFormatter) {
        return new LocalDateTimeDeserializer(this, this._isLenient, dateTimeFormatter, this._shape, this._readTimestampsAsNanosOverride);
    }

    @Override
    protected LocalDateTimeDeserializer withLeniency(Boolean bl2) {
        return new LocalDateTimeDeserializer(this, bl2);
    }

    @Override
    protected JSR310DateTimeDeserializerBase<?> _withFormatOverrides(DeserializationContext deserializationContext, BeanProperty beanProperty, JsonFormat.Value value) {
        LocalDateTimeDeserializer localDateTimeDeserializer = (LocalDateTimeDeserializer)super._withFormatOverrides(deserializationContext, beanProperty, value);
        Boolean bl2 = value.getFeature(JsonFormat.Feature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS);
        if (!Objects.equals(bl2, localDateTimeDeserializer._readTimestampsAsNanosOverride)) {
            return new LocalDateTimeDeserializer(localDateTimeDeserializer, localDateTimeDeserializer._isLenient, localDateTimeDeserializer._formatter, localDateTimeDeserializer._shape, bl2);
        }
        return localDateTimeDeserializer;
    }

    @Override
    public LocalDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasTokenId(6)) {
            return this._fromString(jsonParser, deserializationContext, jsonParser.getText());
        }
        if (jsonParser.isExpectedStartObjectToken()) {
            return this._fromString(jsonParser, deserializationContext, deserializationContext.extractScalarFromObject(jsonParser, this, this.handledType()));
        }
        if (jsonParser.isExpectedStartArrayToken()) {
            JsonToken jsonToken = jsonParser.nextToken();
            if (jsonToken == JsonToken.END_ARRAY) {
                return null;
            }
            if ((jsonToken == JsonToken.VALUE_STRING || jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) && deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                LocalDateTime localDateTime = this.deserialize(jsonParser, deserializationContext);
                if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
                }
                return localDateTime;
            }
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                LocalDateTime localDateTime;
                int n2 = jsonParser.getIntValue();
                int n3 = jsonParser.nextIntValue(-1);
                int n4 = jsonParser.nextIntValue(-1);
                int n5 = jsonParser.nextIntValue(-1);
                int n6 = jsonParser.nextIntValue(-1);
                jsonToken = jsonParser.nextToken();
                if (jsonToken == JsonToken.END_ARRAY) {
                    localDateTime = LocalDateTime.of(n2, n3, n4, n5, n6);
                } else {
                    int n7 = jsonParser.getIntValue();
                    jsonToken = jsonParser.nextToken();
                    if (jsonToken == JsonToken.END_ARRAY) {
                        localDateTime = LocalDateTime.of(n2, n3, n4, n5, n6, n7);
                    } else {
                        int n8 = jsonParser.getIntValue();
                        if (n8 < 1000 && !this.shouldReadTimestampsAsNanoseconds(deserializationContext)) {
                            n8 *= 1000000;
                        }
                        if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                            throw deserializationContext.wrongTokenException(jsonParser, this.handledType(), JsonToken.END_ARRAY, "Expected array to end");
                        }
                        localDateTime = LocalDateTime.of(n2, n3, n4, n5, n6, n7, n8);
                    }
                }
                return localDateTime;
            }
            deserializationContext.reportInputMismatch(this.handledType(), "Unexpected token (%s) within Array, expected VALUE_NUMBER_INT", new Object[]{jsonToken});
        }
        if (jsonParser.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
            return (LocalDateTime)jsonParser.getEmbeddedObject();
        }
        if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            this._throwNoNumericTimestampNeedTimeZone(jsonParser, deserializationContext);
        }
        return (LocalDateTime)this._handleUnexpectedToken(deserializationContext, jsonParser, "Expected array or string.", new Object[0]);
    }

    protected boolean shouldReadTimestampsAsNanoseconds(DeserializationContext deserializationContext) {
        return this._readTimestampsAsNanosOverride != null ? this._readTimestampsAsNanosOverride.booleanValue() : deserializationContext.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS);
    }

    protected LocalDateTime _fromString(JsonParser jsonParser, DeserializationContext deserializationContext, String string) throws IOException {
        String string2 = string.trim();
        if (string2.length() == 0) {
            return (LocalDateTime)this._fromEmptyString(jsonParser, deserializationContext, string2);
        }
        try {
            if (this._formatter == DEFAULT_FORMATTER && string2.length() > 10 && string2.charAt(10) == 'T' && string2.endsWith("Z")) {
                if (this.isLenient()) {
                    return LocalDateTime.parse(string2.substring(0, string2.length() - 1), this._formatter);
                }
                JavaType javaType = this.getValueType(deserializationContext);
                return (LocalDateTime)deserializationContext.handleWeirdStringValue(javaType.getRawClass(), string2, "Should not contain offset when 'strict' mode set for property or type (enable 'lenient' handling to allow)", new Object[0]);
            }
            return LocalDateTime.parse(string2, this._formatter);
        }
        catch (DateTimeException dateTimeException) {
            return (LocalDateTime)this._handleDateTimeException(deserializationContext, dateTimeException, string2);
        }
    }
}

