/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.internal;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.internal.Linked;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.internal.LinkedDeque;

public final class PrivateMaxEntriesMap<K, V>
extends AbstractMap<K, V>
implements Serializable,
ConcurrentMap<K, V> {
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    static final long MAXIMUM_CAPACITY = 9223372034707292160L;
    static final int NUMBER_OF_READ_BUFFERS = Math.min(4, PrivateMaxEntriesMap.ceilingNextPowerOfTwo(NCPU));
    static final int READ_BUFFERS_MASK = NUMBER_OF_READ_BUFFERS - 1;
    static final int READ_BUFFER_THRESHOLD = 4;
    static final int READ_BUFFER_DRAIN_THRESHOLD = 8;
    static final int READ_BUFFER_SIZE = 16;
    static final int READ_BUFFER_INDEX_MASK = 15;
    static final int WRITE_BUFFER_DRAIN_THRESHOLD = 16;
    final ConcurrentMap<K, Node<K, V>> data;
    final int concurrencyLevel;
    final long[] readBufferReadCount;
    final LinkedDeque<Node<K, V>> evictionDeque;
    final AtomicLong weightedSize;
    final AtomicLong capacity;
    final Lock evictionLock;
    final Queue<Runnable> writeBuffer;
    final AtomicLongArray readBufferWriteCount;
    final AtomicLongArray readBufferDrainAtWriteCount;
    final AtomicReferenceArray<Node<K, V>> readBuffers;
    final AtomicReference<DrainStatus> drainStatus;
    transient Set<K> keySet;
    transient Collection<V> values;
    transient Set<Map.Entry<K, V>> entrySet;
    static final long serialVersionUID = 1L;

    static int ceilingNextPowerOfTwo(int n2) {
        return 1 << 32 - Integer.numberOfLeadingZeros(n2 - 1);
    }

    private static int readBufferIndex(int n2, int n3) {
        return 16 * n2 + n3;
    }

    PrivateMaxEntriesMap(Builder<K, V> builder) {
        this.concurrencyLevel = builder.concurrencyLevel;
        this.capacity = new AtomicLong(Math.min(builder.capacity, 9223372034707292160L));
        this.data = new ConcurrentHashMap<K, Node<K, V>>(builder.initialCapacity, 0.75f, this.concurrencyLevel);
        this.evictionLock = new ReentrantLock();
        this.weightedSize = new AtomicLong();
        this.evictionDeque = new LinkedDeque();
        this.writeBuffer = new ConcurrentLinkedQueue<Runnable>();
        this.drainStatus = new AtomicReference<DrainStatus>(DrainStatus.IDLE);
        this.readBufferReadCount = new long[NUMBER_OF_READ_BUFFERS];
        this.readBufferWriteCount = new AtomicLongArray(NUMBER_OF_READ_BUFFERS);
        this.readBufferDrainAtWriteCount = new AtomicLongArray(NUMBER_OF_READ_BUFFERS);
        this.readBuffers = new AtomicReferenceArray(NUMBER_OF_READ_BUFFERS * 16);
    }

    static void checkNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    static void checkArgument(boolean bl2) {
        if (!bl2) {
            throw new IllegalArgumentException();
        }
    }

    static void checkState(boolean bl2) {
        if (!bl2) {
            throw new IllegalStateException();
        }
    }

    public long capacity() {
        return this.capacity.get();
    }

    public void setCapacity(long l2) {
        PrivateMaxEntriesMap.checkArgument(l2 >= 0L);
        this.evictionLock.lock();
        try {
            this.capacity.lazySet(Math.min(l2, 9223372034707292160L));
            this.drainBuffers();
            this.evict();
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    boolean hasOverflowed() {
        return this.weightedSize.get() > this.capacity.get();
    }

    void evict() {
        while (this.hasOverflowed()) {
            Node node = (Node)this.evictionDeque.poll();
            if (node == null) {
                return;
            }
            this.data.remove(node.key, node);
            this.makeDead(node);
        }
    }

    void afterRead(Node<K, V> node) {
        int n2 = PrivateMaxEntriesMap.readBufferIndex();
        long l2 = this.recordRead(n2, node);
        this.drainOnReadIfNeeded(n2, l2);
    }

    static int readBufferIndex() {
        return (int)Thread.currentThread().getId() & READ_BUFFERS_MASK;
    }

    long recordRead(int n2, Node<K, V> node) {
        long l2 = this.readBufferWriteCount.get(n2);
        this.readBufferWriteCount.lazySet(n2, l2 + 1L);
        int n3 = (int)(l2 & 0xFL);
        this.readBuffers.lazySet(PrivateMaxEntriesMap.readBufferIndex(n2, n3), node);
        return l2;
    }

    void drainOnReadIfNeeded(int n2, long l2) {
        long l3 = l2 - this.readBufferDrainAtWriteCount.get(n2);
        boolean bl2 = l3 < 4L;
        DrainStatus drainStatus = this.drainStatus.get();
        if (drainStatus.shouldDrainBuffers(bl2)) {
            this.tryToDrainBuffers();
        }
    }

    void afterWrite(Runnable runnable) {
        this.writeBuffer.add(runnable);
        this.drainStatus.lazySet(DrainStatus.REQUIRED);
        this.tryToDrainBuffers();
    }

    void tryToDrainBuffers() {
        if (this.evictionLock.tryLock()) {
            try {
                this.drainStatus.lazySet(DrainStatus.PROCESSING);
                this.drainBuffers();
            }
            finally {
                this.drainStatus.compareAndSet(DrainStatus.PROCESSING, DrainStatus.IDLE);
                this.evictionLock.unlock();
            }
        }
    }

    void drainBuffers() {
        this.drainReadBuffers();
        this.drainWriteBuffer();
    }

    void drainReadBuffers() {
        int n2 = (int)Thread.currentThread().getId();
        int n3 = n2 + NUMBER_OF_READ_BUFFERS;
        for (int i2 = n2; i2 < n3; ++i2) {
            this.drainReadBuffer(i2 & READ_BUFFERS_MASK);
        }
    }

    void drainReadBuffer(int n2) {
        int n3;
        int n4;
        Node<K, V> node;
        long l2 = this.readBufferWriteCount.get(n2);
        for (int i2 = 0; i2 < 8 && (node = this.readBuffers.get(n4 = PrivateMaxEntriesMap.readBufferIndex(n2, n3 = (int)(this.readBufferReadCount[n2] & 0xFL)))) != null; ++i2) {
            this.readBuffers.lazySet(n4, null);
            this.applyRead(node);
            int n5 = n2;
            this.readBufferReadCount[n5] = this.readBufferReadCount[n5] + 1L;
        }
        this.readBufferDrainAtWriteCount.lazySet(n2, l2);
    }

    void applyRead(Node<K, V> node) {
        if (this.evictionDeque.contains(node)) {
            this.evictionDeque.moveToBack(node);
        }
    }

    void drainWriteBuffer() {
        Runnable runnable;
        for (int i2 = 0; i2 < 16 && (runnable = this.writeBuffer.poll()) != null; ++i2) {
            runnable.run();
        }
    }

    boolean tryToRetire(Node<K, V> node, WeightedValue<V> weightedValue) {
        if (weightedValue.isAlive()) {
            WeightedValue weightedValue2 = new WeightedValue(weightedValue.value, -weightedValue.weight);
            return node.compareAndSet(weightedValue, weightedValue2);
        }
        return false;
    }

    void makeRetired(Node<K, V> node) {
        WeightedValue weightedValue;
        WeightedValue weightedValue2;
        do {
            if ((weightedValue2 = (WeightedValue)node.get()).isAlive()) continue;
            return;
        } while (!node.compareAndSet(weightedValue2, weightedValue = new WeightedValue(weightedValue2.value, -weightedValue2.weight)));
    }

    void makeDead(Node<K, V> node) {
        WeightedValue weightedValue;
        WeightedValue weightedValue2;
        while (!node.compareAndSet(weightedValue2 = (WeightedValue)node.get(), weightedValue = new WeightedValue(weightedValue2.value, 0))) {
        }
        this.weightedSize.lazySet(this.weightedSize.get() - (long)Math.abs(weightedValue2.weight));
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public void clear() {
        this.evictionLock.lock();
        try {
            Runnable runnable;
            Node node;
            while ((node = (Node)this.evictionDeque.poll()) != null) {
                this.data.remove(node.key, node);
                this.makeDead(node);
            }
            for (int i2 = 0; i2 < this.readBuffers.length(); ++i2) {
                this.readBuffers.lazySet(i2, null);
            }
            while ((runnable = this.writeBuffer.poll()) != null) {
                runnable.run();
            }
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @Override
    public boolean containsKey(Object object) {
        return this.data.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        PrivateMaxEntriesMap.checkNotNull(object);
        for (Node node : this.data.values()) {
            if (!node.getValue().equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object object) {
        Node node = (Node)this.data.get(object);
        if (node == null) {
            return null;
        }
        this.afterRead(node);
        return node.getValue();
    }

    @Override
    public V put(K k2, V v2) {
        return this.put(k2, v2, false);
    }

    @Override
    public V putIfAbsent(K k2, V v2) {
        return this.put(k2, v2, true);
    }

    V put(K k2, V v2, boolean bl2) {
        WeightedValue weightedValue;
        Node<K, WeightedValue<V>> node;
        PrivateMaxEntriesMap.checkNotNull(k2);
        PrivateMaxEntriesMap.checkNotNull(v2);
        boolean bl3 = true;
        WeightedValue<V> weightedValue2 = new WeightedValue<V>(v2, 1);
        Node<K, V> node2 = new Node<K, V>(k2, weightedValue2);
        block0: while (true) {
            if ((node = this.data.putIfAbsent(node2.key, node2)) == null) {
                this.afterWrite(new AddTask(node2, 1));
                return null;
            }
            if (bl2) {
                this.afterRead(node);
                return node.getValue();
            }
            do {
                if (!(weightedValue = (WeightedValue)node.get()).isAlive()) continue block0;
            } while (!node.compareAndSet(weightedValue, weightedValue2));
            break;
        }
        int n2 = 1 - weightedValue.weight;
        if (n2 == 0) {
            this.afterRead(node);
        } else {
            this.afterWrite(new UpdateTask(node, n2));
        }
        return weightedValue.value;
    }

    @Override
    public V remove(Object object) {
        Node node = (Node)this.data.remove(object);
        if (node == null) {
            return null;
        }
        this.makeRetired(node);
        this.afterWrite(new RemovalTask(node));
        return node.getValue();
    }

    @Override
    public boolean remove(Object object, Object object2) {
        Node node = (Node)this.data.get(object);
        if (node == null || object2 == null) {
            return false;
        }
        WeightedValue weightedValue = (WeightedValue)node.get();
        while (weightedValue.contains(object2)) {
            if (this.tryToRetire(node, weightedValue)) {
                if (!this.data.remove(object, node)) break;
                this.afterWrite(new RemovalTask(node));
                return true;
            }
            weightedValue = (WeightedValue)node.get();
            if (weightedValue.isAlive()) continue;
        }
        return false;
    }

    @Override
    public V replace(K k2, V v2) {
        WeightedValue weightedValue;
        PrivateMaxEntriesMap.checkNotNull(k2);
        PrivateMaxEntriesMap.checkNotNull(v2);
        boolean bl2 = true;
        WeightedValue<V> weightedValue2 = new WeightedValue<V>(v2, 1);
        Node node = (Node)this.data.get(k2);
        if (node == null) {
            return null;
        }
        do {
            if ((weightedValue = (WeightedValue)node.get()).isAlive()) continue;
            return null;
        } while (!node.compareAndSet(weightedValue, weightedValue2));
        int n2 = 1 - weightedValue.weight;
        if (n2 == 0) {
            this.afterRead(node);
        } else {
            this.afterWrite(new UpdateTask(node, n2));
        }
        return weightedValue.value;
    }

    @Override
    public boolean replace(K k2, V v2, V v3) {
        WeightedValue weightedValue;
        PrivateMaxEntriesMap.checkNotNull(k2);
        PrivateMaxEntriesMap.checkNotNull(v2);
        PrivateMaxEntriesMap.checkNotNull(v3);
        boolean bl2 = true;
        WeightedValue<V> weightedValue2 = new WeightedValue<V>(v3, 1);
        Node node = (Node)this.data.get(k2);
        if (node == null) {
            return false;
        }
        do {
            if ((weightedValue = (WeightedValue)node.get()).isAlive() && weightedValue.contains(v2)) continue;
            return false;
        } while (!node.compareAndSet(weightedValue, weightedValue2));
        int n2 = 1 - weightedValue.weight;
        if (n2 == 0) {
            this.afterRead(node);
        } else {
            this.afterWrite(new UpdateTask(node, n2));
        }
        return true;
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet = this.keySet;
        return keySet == null ? (this.keySet = new KeySet()) : keySet;
    }

    @Override
    public Collection<V> values() {
        Values values = this.values;
        return values == null ? (this.values = new Values()) : values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet == null ? (this.entrySet = new EntrySet()) : entrySet;
    }

    Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    public static final class Builder<K, V> {
        static final int DEFAULT_CONCURRENCY_LEVEL = 16;
        static final int DEFAULT_INITIAL_CAPACITY = 16;
        int concurrencyLevel = 16;
        int initialCapacity = 16;
        long capacity = -1L;

        public Builder<K, V> initialCapacity(int n2) {
            PrivateMaxEntriesMap.checkArgument(n2 >= 0);
            this.initialCapacity = n2;
            return this;
        }

        public Builder<K, V> maximumCapacity(long l2) {
            PrivateMaxEntriesMap.checkArgument(l2 >= 0L);
            this.capacity = l2;
            return this;
        }

        public Builder<K, V> concurrencyLevel(int n2) {
            PrivateMaxEntriesMap.checkArgument(n2 > 0);
            this.concurrencyLevel = n2;
            return this;
        }

        public PrivateMaxEntriesMap<K, V> build() {
            PrivateMaxEntriesMap.checkState(this.capacity >= 0L);
            return new PrivateMaxEntriesMap(this);
        }
    }

    static final class SerializationProxy<K, V>
    implements Serializable {
        final int concurrencyLevel;
        final Map<K, V> data;
        final long capacity;
        static final long serialVersionUID = 1L;

        SerializationProxy(PrivateMaxEntriesMap<K, V> privateMaxEntriesMap) {
            this.concurrencyLevel = privateMaxEntriesMap.concurrencyLevel;
            this.data = new HashMap<K, V>(privateMaxEntriesMap);
            this.capacity = privateMaxEntriesMap.capacity.get();
        }

        Object readResolve() {
            PrivateMaxEntriesMap<K, V> privateMaxEntriesMap = new Builder().maximumCapacity(this.capacity).build();
            privateMaxEntriesMap.putAll(this.data);
            return privateMaxEntriesMap;
        }
    }

    final class WriteThroughEntry
    extends AbstractMap.SimpleEntry<K, V> {
        static final long serialVersionUID = 1L;

        WriteThroughEntry(Node<K, V> node) {
            super(node.key, node.getValue());
        }

        @Override
        public V setValue(V v2) {
            PrivateMaxEntriesMap.this.put(this.getKey(), v2);
            return super.setValue(v2);
        }

        Object writeReplace() {
            return new AbstractMap.SimpleEntry(this);
        }
    }

    final class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        final Iterator<Node<K, V>> iterator;
        Node<K, V> current;

        EntryIterator() {
            this.iterator = PrivateMaxEntriesMap.this.data.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.current = this.iterator.next();
            return new WriteThroughEntry(this.current);
        }

        @Override
        public void remove() {
            PrivateMaxEntriesMap.checkState(this.current != null);
            PrivateMaxEntriesMap.this.remove(this.current.key);
            this.current = null;
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        final PrivateMaxEntriesMap<K, V> map;

        EntrySet() {
            this.map = PrivateMaxEntriesMap.this;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Node node = (Node)this.map.data.get(entry.getKey());
            return node != null && node.getValue().equals(entry.getValue());
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            throw new UnsupportedOperationException("ConcurrentLinkedHashMap does not allow add to be called on entrySet()");
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.map.remove(entry.getKey(), entry.getValue());
        }
    }

    final class ValueIterator
    implements Iterator<V> {
        final Iterator<Node<K, V>> iterator;
        Node<K, V> current;

        ValueIterator() {
            this.iterator = PrivateMaxEntriesMap.this.data.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            this.current = this.iterator.next();
            return this.current.getValue();
        }

        @Override
        public void remove() {
            PrivateMaxEntriesMap.checkState(this.current != null);
            PrivateMaxEntriesMap.this.remove(this.current.key);
            this.current = null;
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public int size() {
            return PrivateMaxEntriesMap.this.size();
        }

        @Override
        public void clear() {
            PrivateMaxEntriesMap.this.clear();
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public boolean contains(Object object) {
            return PrivateMaxEntriesMap.this.containsValue(object);
        }
    }

    final class KeyIterator
    implements Iterator<K> {
        final Iterator<K> iterator;
        K current;

        KeyIterator() {
            this.iterator = PrivateMaxEntriesMap.this.data.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K next() {
            this.current = this.iterator.next();
            return this.current;
        }

        @Override
        public void remove() {
            PrivateMaxEntriesMap.checkState(this.current != null);
            PrivateMaxEntriesMap.this.remove(this.current);
            this.current = null;
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        final PrivateMaxEntriesMap<K, V> map;

        KeySet() {
            this.map = PrivateMaxEntriesMap.this;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean contains(Object object) {
            return PrivateMaxEntriesMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return this.map.remove(object) != null;
        }

        @Override
        public Object[] toArray() {
            return this.map.data.keySet().toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.map.data.keySet().toArray(TArray);
        }
    }

    static final class Node<K, V>
    extends AtomicReference<WeightedValue<V>>
    implements Linked<Node<K, V>> {
        final K key;
        Node<K, V> prev;
        Node<K, V> next;

        Node(K k2, WeightedValue<V> weightedValue) {
            super(weightedValue);
            this.key = k2;
        }

        @Override
        public Node<K, V> getPrevious() {
            return this.prev;
        }

        @Override
        public void setPrevious(Node<K, V> node) {
            this.prev = node;
        }

        @Override
        public Node<K, V> getNext() {
            return this.next;
        }

        @Override
        public void setNext(Node<K, V> node) {
            this.next = node;
        }

        V getValue() {
            return ((WeightedValue)this.get()).value;
        }
    }

    static final class WeightedValue<V> {
        final int weight;
        final V value;

        WeightedValue(V v2, int n2) {
            this.weight = n2;
            this.value = v2;
        }

        boolean contains(Object object) {
            return object == this.value || this.value.equals(object);
        }

        boolean isAlive() {
            return this.weight > 0;
        }
    }

    static enum DrainStatus {
        IDLE{

            @Override
            boolean shouldDrainBuffers(boolean bl2) {
                return !bl2;
            }
        }
        ,
        REQUIRED{

            @Override
            boolean shouldDrainBuffers(boolean bl2) {
                return true;
            }
        }
        ,
        PROCESSING{

            @Override
            boolean shouldDrainBuffers(boolean bl2) {
                return false;
            }
        };


        abstract boolean shouldDrainBuffers(boolean var1);
    }

    final class UpdateTask
    implements Runnable {
        final int weightDifference;
        final Node<K, V> node;

        UpdateTask(Node<K, V> node, int n2) {
            this.weightDifference = n2;
            this.node = node;
        }

        @Override
        public void run() {
            PrivateMaxEntriesMap.this.weightedSize.lazySet(PrivateMaxEntriesMap.this.weightedSize.get() + (long)this.weightDifference);
            PrivateMaxEntriesMap.this.applyRead(this.node);
            PrivateMaxEntriesMap.this.evict();
        }
    }

    final class RemovalTask
    implements Runnable {
        final Node<K, V> node;

        RemovalTask(Node<K, V> node) {
            this.node = node;
        }

        @Override
        public void run() {
            PrivateMaxEntriesMap.this.evictionDeque.remove(this.node);
            PrivateMaxEntriesMap.this.makeDead(this.node);
        }
    }

    final class AddTask
    implements Runnable {
        final Node<K, V> node;
        final int weight;

        AddTask(Node<K, V> node, int n2) {
            this.weight = n2;
            this.node = node;
        }

        @Override
        public void run() {
            PrivateMaxEntriesMap.this.weightedSize.lazySet(PrivateMaxEntriesMap.this.weightedSize.get() + (long)this.weight);
            if (((WeightedValue)this.node.get()).isAlive()) {
                PrivateMaxEntriesMap.this.evictionDeque.add(this.node);
                PrivateMaxEntriesMap.this.evict();
            }
        }
    }
}

