/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonIgnore;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JacksonException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonGenerator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonLocation;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DatabindException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializerProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.ClassUtil;

public class JsonMappingException
extends DatabindException {
    private static final long serialVersionUID = 3L;
    static final int MAX_REFS_TO_LIST = 1000;
    protected LinkedList<Reference> _path;
    protected transient Closeable _processor;

    @Deprecated
    public JsonMappingException(String string) {
        super(string);
    }

    @Deprecated
    public JsonMappingException(String string, Throwable throwable) {
        super(string, throwable);
    }

    @Deprecated
    public JsonMappingException(String string, JsonLocation jsonLocation) {
        super(string, jsonLocation);
    }

    @Deprecated
    public JsonMappingException(String string, JsonLocation jsonLocation, Throwable throwable) {
        super(string, jsonLocation, throwable);
    }

    public JsonMappingException(Closeable closeable, String string) {
        super(string);
        this._processor = closeable;
        if (closeable instanceof JsonParser) {
            this._location = ((JsonParser)closeable).currentTokenLocation();
        }
    }

    public JsonMappingException(Closeable closeable, String string, Throwable throwable) {
        super(string, throwable);
        this._processor = closeable;
        if (throwable instanceof JacksonException) {
            this._location = ((JacksonException)throwable).getLocation();
        } else if (closeable instanceof JsonParser) {
            this._location = ((JsonParser)closeable).currentTokenLocation();
        }
    }

    public JsonMappingException(Closeable closeable, String string, JsonLocation jsonLocation) {
        super(string, jsonLocation);
        this._processor = closeable;
    }

    public static JsonMappingException from(JsonParser jsonParser, String string) {
        return new JsonMappingException(jsonParser, string);
    }

    public static JsonMappingException from(JsonParser jsonParser, String string, Throwable throwable) {
        return new JsonMappingException((Closeable)jsonParser, string, throwable);
    }

    public static JsonMappingException from(JsonGenerator jsonGenerator, String string) {
        return new JsonMappingException((Closeable)jsonGenerator, string, (Throwable)null);
    }

    public static JsonMappingException from(JsonGenerator jsonGenerator, String string, Throwable throwable) {
        return new JsonMappingException((Closeable)jsonGenerator, string, throwable);
    }

    public static JsonMappingException from(DeserializationContext deserializationContext, String string) {
        return new JsonMappingException(JsonMappingException._parser(deserializationContext), string);
    }

    public static JsonMappingException from(DeserializationContext deserializationContext, String string, Throwable throwable) {
        return new JsonMappingException((Closeable)JsonMappingException._parser(deserializationContext), string, throwable);
    }

    private static JsonParser _parser(DeserializationContext deserializationContext) {
        return deserializationContext == null ? null : deserializationContext.getParser();
    }

    public static JsonMappingException from(SerializerProvider serializerProvider, String string) {
        return new JsonMappingException(JsonMappingException._generator(serializerProvider), string);
    }

    public static JsonMappingException from(SerializerProvider serializerProvider, String string, Throwable throwable) {
        return new JsonMappingException((Closeable)JsonMappingException._generator(serializerProvider), string, throwable);
    }

    private static JsonGenerator _generator(SerializerProvider serializerProvider) {
        return serializerProvider == null ? null : serializerProvider.getGenerator();
    }

    public static JsonMappingException fromUnexpectedIOE(IOException iOException) {
        return new JsonMappingException(null, String.format("Unexpected IOException (of type %s): %s", iOException.getClass().getName(), ClassUtil.exceptionMessage(iOException)));
    }

    public static JsonMappingException wrapWithPath(Throwable throwable, Object object, String string) {
        return JsonMappingException.wrapWithPath(throwable, new Reference(object, string));
    }

    public static JsonMappingException wrapWithPath(Throwable throwable, Object object, int n2) {
        return JsonMappingException.wrapWithPath(throwable, new Reference(object, n2));
    }

    public static JsonMappingException wrapWithPath(Throwable throwable, Reference reference) {
        JsonMappingException jsonMappingException;
        if (throwable instanceof JsonMappingException) {
            jsonMappingException = (JsonMappingException)throwable;
        } else {
            Object object;
            String string = ClassUtil.exceptionMessage(throwable);
            if (string == null || string.isEmpty()) {
                string = "(was " + throwable.getClass().getName() + ")";
            }
            Closeable closeable = null;
            if (throwable instanceof JacksonException && (object = ((JacksonException)throwable).getProcessor()) instanceof Closeable) {
                closeable = (Closeable)object;
            }
            jsonMappingException = new JsonMappingException(closeable, string, throwable);
        }
        jsonMappingException.prependPath(reference);
        return jsonMappingException;
    }

    public JsonMappingException withCause(Throwable throwable) {
        this.initCause(throwable);
        return this;
    }

    public List<Reference> getPath() {
        if (this._path == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this._path);
    }

    public String getPathReference() {
        return this.getPathReference(new StringBuilder()).toString();
    }

    public StringBuilder getPathReference(StringBuilder stringBuilder) {
        this._appendPathDesc(stringBuilder);
        return stringBuilder;
    }

    @Override
    public void prependPath(Object object, String string) {
        this.prependPath(new Reference(object, string));
    }

    @Override
    public void prependPath(Object object, int n2) {
        this.prependPath(new Reference(object, n2));
    }

    public void prependPath(Reference reference) {
        if (this._path == null) {
            this._path = new LinkedList();
        }
        if (this._path.size() < 1000) {
            this._path.addFirst(reference);
        }
    }

    @Override
    @JsonIgnore
    public Object getProcessor() {
        return this._processor;
    }

    @Override
    public String getLocalizedMessage() {
        return this._buildMessage();
    }

    @Override
    public String getMessage() {
        return this._buildMessage();
    }

    protected String _buildMessage() {
        String string = super.getMessage();
        if (this._path == null) {
            return string;
        }
        StringBuilder stringBuilder = string == null ? new StringBuilder() : new StringBuilder(string);
        stringBuilder.append(" (through reference chain: ");
        stringBuilder = this.getPathReference(stringBuilder);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": " + this.getMessage();
    }

    protected void _appendPathDesc(StringBuilder stringBuilder) {
        if (this._path == null) {
            return;
        }
        Iterator iterator = this._path.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(((Reference)iterator.next()).toString());
            if (!iterator.hasNext()) continue;
            stringBuilder.append("->");
        }
    }

    public static class Reference
    implements Serializable {
        private static final long serialVersionUID = 2L;
        protected transient Object _from;
        protected String _fieldName;
        protected int _index = -1;
        protected String _desc;

        protected Reference() {
        }

        public Reference(Object object) {
            this._from = object;
        }

        public Reference(Object object, String string) {
            this._from = object;
            if (string == null) {
                throw new NullPointerException("Cannot pass null fieldName");
            }
            this._fieldName = string;
        }

        public Reference(Object object, int n2) {
            this._from = object;
            this._index = n2;
        }

        void setFieldName(String string) {
            this._fieldName = string;
        }

        void setIndex(int n2) {
            this._index = n2;
        }

        void setDescription(String string) {
            this._desc = string;
        }

        @JsonIgnore
        public Object getFrom() {
            return this._from;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        public int getIndex() {
            return this._index;
        }

        public String getDescription() {
            if (this._desc == null) {
                StringBuilder stringBuilder = new StringBuilder();
                if (this._from == null) {
                    stringBuilder.append("UNKNOWN");
                } else {
                    Class<?> clazz = this._from instanceof Class ? (Class<?>)this._from : this._from.getClass();
                    int n2 = 0;
                    while (clazz.isArray()) {
                        clazz = clazz.getComponentType();
                        ++n2;
                    }
                    stringBuilder.append(clazz.getName());
                    while (--n2 >= 0) {
                        stringBuilder.append("[]");
                    }
                }
                stringBuilder.append('[');
                if (this._fieldName != null) {
                    stringBuilder.append('\"');
                    stringBuilder.append(this._fieldName);
                    stringBuilder.append('\"');
                } else if (this._index >= 0) {
                    stringBuilder.append(this._index);
                } else {
                    stringBuilder.append('?');
                }
                stringBuilder.append(']');
                this._desc = stringBuilder.toString();
            }
            return this._desc;
        }

        public String toString() {
            return this.getDescription();
        }

        Object writeReplace() {
            this.getDescription();
            return this;
        }
    }
}

