/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.json;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonSerializable;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonWriteContext;
import macromedia.jdbc.sqlserver.externals.com.azure.json.WriteValueCallback;

public abstract class JsonWriter
implements Closeable {
    public abstract JsonWriteContext getWriteContext();

    @Override
    public abstract void close() throws IOException;

    public abstract JsonWriter flush() throws IOException;

    public abstract JsonWriter writeStartObject() throws IOException;

    public final JsonWriter writeStartObject(String string) throws IOException {
        Objects.requireNonNull(string, "'fieldName' cannot be null.");
        return this.writeFieldName(string).writeStartObject();
    }

    public abstract JsonWriter writeEndObject() throws IOException;

    public abstract JsonWriter writeStartArray() throws IOException;

    public final JsonWriter writeStartArray(String string) throws IOException {
        Objects.requireNonNull(string, "'fieldName' cannot be null.");
        return this.writeFieldName(string).writeStartArray();
    }

    public abstract JsonWriter writeEndArray() throws IOException;

    public abstract JsonWriter writeFieldName(String var1) throws IOException;

    public final JsonWriter writeJson(JsonSerializable<?> jsonSerializable) throws IOException {
        return jsonSerializable == null ? this : jsonSerializable.toJson(this);
    }

    public final <T> JsonWriter writeArray(T[] TArray, WriteValueCallback<JsonWriter, T> writeValueCallback) throws IOException {
        Objects.requireNonNull(writeValueCallback, "'elementWriterFunc' cannot be null.");
        if (TArray == null) {
            return this.writeNull();
        }
        return this.writeArrayInternal(Arrays.asList(TArray), writeValueCallback, null);
    }

    public final <T> JsonWriter writeArray(Iterable<T> iterable, WriteValueCallback<JsonWriter, T> writeValueCallback) throws IOException {
        Objects.requireNonNull(writeValueCallback, "'elementWriterFunc' cannot be null.");
        if (iterable == null) {
            return this.writeNull();
        }
        return this.writeArrayInternal(iterable, writeValueCallback, null);
    }

    private <T> JsonWriter writeArrayInternal(Iterable<T> iterable, WriteValueCallback<JsonWriter, T> writeValueCallback, String string) throws IOException {
        if (string == null) {
            this.writeStartArray();
        } else {
            this.writeStartArray(string);
        }
        for (T t2 : iterable) {
            writeValueCallback.write(this, (JsonWriter)t2);
        }
        return this.writeEndArray();
    }

    public final <T> JsonWriter writeMap(Map<String, T> map, WriteValueCallback<JsonWriter, T> writeValueCallback) throws IOException {
        Objects.requireNonNull(writeValueCallback, "'valueWriterFunc' cannot be null.");
        if (map == null) {
            return this.writeNull();
        }
        this.writeStartObject();
        for (Map.Entry<String, T> entry : map.entrySet()) {
            this.writeFieldName(entry.getKey());
            writeValueCallback.write(this, (JsonWriter)entry.getValue());
        }
        return this.writeEndObject();
    }

    public abstract JsonWriter writeBinary(byte[] var1) throws IOException;

    public abstract JsonWriter writeBoolean(boolean var1) throws IOException;

    public final JsonWriter writeBoolean(Boolean bl2) throws IOException {
        return bl2 == null ? this.writeNull() : this.writeBoolean((boolean)bl2);
    }

    public abstract JsonWriter writeDouble(double var1) throws IOException;

    public abstract JsonWriter writeFloat(float var1) throws IOException;

    public abstract JsonWriter writeInt(int var1) throws IOException;

    public abstract JsonWriter writeLong(long var1) throws IOException;

    public abstract JsonWriter writeNull() throws IOException;

    public final JsonWriter writeNumber(Number number) throws IOException {
        if (number == null) {
            return this.writeNull();
        }
        if (number instanceof Byte || number instanceof Short || number instanceof Integer) {
            return this.writeInt(number.intValue());
        }
        if (number instanceof Long) {
            return this.writeLong(number.longValue());
        }
        if (number instanceof Float) {
            return this.writeFloat(number.floatValue());
        }
        if (number instanceof Double) {
            return this.writeDouble(number.doubleValue());
        }
        return this.writeRawValue(number.toString());
    }

    public abstract JsonWriter writeString(String var1) throws IOException;

    public abstract JsonWriter writeRawValue(String var1) throws IOException;

    public final <T> JsonWriter writeNullableField(String string, T t2, WriteValueCallback<JsonWriter, T> writeValueCallback) throws IOException {
        Objects.requireNonNull(string, "'fieldName' cannot be null.");
        Objects.requireNonNull(writeValueCallback, "'writerFunc' cannot be null.");
        if (t2 == null) {
            return this.writeNullField(string);
        }
        writeValueCallback.write(this.writeFieldName(string), (JsonWriter)t2);
        return this;
    }

    public final JsonWriter writeJsonField(String string, JsonSerializable<?> jsonSerializable) throws IOException {
        Objects.requireNonNull(string, "'fieldName' cannot be null.");
        return jsonSerializable == null ? this : jsonSerializable.toJson(this.writeFieldName(string));
    }

    public final <T> JsonWriter writeArrayField(String string, T[] TArray, WriteValueCallback<JsonWriter, T> writeValueCallback) throws IOException {
        Objects.requireNonNull(string, "'fieldName' cannot be null.");
        Objects.requireNonNull(writeValueCallback, "'elementWriterFunc' cannot be null.");
        if (TArray == null) {
            return this;
        }
        return this.writeArrayInternal(Arrays.asList(TArray), writeValueCallback, string);
    }

    public final <T> JsonWriter writeArrayField(String string, Iterable<T> iterable, WriteValueCallback<JsonWriter, T> writeValueCallback) throws IOException {
        Objects.requireNonNull(string, "'fieldName' cannot be null.");
        Objects.requireNonNull(writeValueCallback, "'elementWriterFunc' cannot be null.");
        if (iterable == null) {
            return this;
        }
        return this.writeArrayInternal(iterable, writeValueCallback, string);
    }

    public final <T> JsonWriter writeMapField(String string, Map<String, T> map, WriteValueCallback<JsonWriter, T> writeValueCallback) throws IOException {
        Objects.requireNonNull(string, "'fieldName' cannot be null.");
        Objects.requireNonNull(writeValueCallback, "'valueWriterFunc' cannot be null.");
        if (map == null) {
            return this;
        }
        this.writeStartObject(string);
        for (Map.Entry<String, T> entry : map.entrySet()) {
            this.writeFieldName(entry.getKey());
            writeValueCallback.write(this, (JsonWriter)entry.getValue());
        }
        return this.writeEndObject();
    }

    public final JsonWriter writeBinaryField(String string, byte[] byArray) throws IOException {
        Objects.requireNonNull(string, "'fieldName' cannot be null.");
        if (byArray == null) {
            return this;
        }
        return this.writeFieldName(string).writeBinary(byArray);
    }

    public final JsonWriter writeBooleanField(String string, boolean bl2) throws IOException {
        Objects.requireNonNull(string, "'fieldName' cannot be null.");
        return this.writeFieldName(string).writeBoolean(bl2);
    }

    public final JsonWriter writeBooleanField(String string, Boolean bl2) throws IOException {
        Objects.requireNonNull(string, "'fieldName' cannot be null.");
        return bl2 == null ? this : this.writeBooleanField(string, (boolean)bl2);
    }

    public final JsonWriter writeDoubleField(String string, double d2) throws IOException {
        Objects.requireNonNull(string, "'fieldName' cannot be null.");
        return this.writeFieldName(string).writeDouble(d2);
    }

    public final JsonWriter writeFloatField(String string, float f2) throws IOException {
        Objects.requireNonNull(string, "'fieldName' cannot be null.");
        return this.writeFieldName(string).writeFloat(f2);
    }

    public final JsonWriter writeIntField(String string, int n2) throws IOException {
        Objects.requireNonNull(string, "'fieldName' cannot be null.");
        return this.writeFieldName(string).writeInt(n2);
    }

    public final JsonWriter writeLongField(String string, long l2) throws IOException {
        Objects.requireNonNull(string, "'fieldName' cannot be null.");
        return this.writeFieldName(string).writeLong(l2);
    }

    public final JsonWriter writeNullField(String string) throws IOException {
        Objects.requireNonNull(string, "'fieldName' cannot be null.");
        return this.writeFieldName(string).writeNull();
    }

    public final JsonWriter writeNumberField(String string, Number number) throws IOException {
        Objects.requireNonNull(string, "'fieldName' cannot be null.");
        if (number == null) {
            return this;
        }
        return this.writeFieldName(string).writeNumber(number);
    }

    public final JsonWriter writeStringField(String string, String string2) throws IOException {
        Objects.requireNonNull(string, "'fieldName' cannot be null.");
        if (string2 == null) {
            return this;
        }
        return this.writeFieldName(string).writeString(string2);
    }

    public final JsonWriter writeRawField(String string, String string2) throws IOException {
        Objects.requireNonNull(string, "'fieldName' cannot be null.");
        Objects.requireNonNull(string2, "'value' cannot be null.");
        return this.writeFieldName(string).writeRawValue(string2);
    }

    public JsonWriter writeUntypedField(String string, Object object) throws IOException {
        Objects.requireNonNull(string, "'fieldName' cannot be null.");
        return this.writeFieldName(string).writeUntyped(object);
    }

    public JsonWriter writeUntyped(Object object) throws IOException {
        if (object == null) {
            return this.writeNull();
        }
        if (object instanceof Short) {
            return this.writeInt(((Short)object).shortValue());
        }
        if (object instanceof Integer) {
            return this.writeInt((Integer)object);
        }
        if (object instanceof Long) {
            return this.writeLong((Long)object);
        }
        if (object instanceof Float) {
            return this.writeFloat(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return this.writeDouble((Double)object);
        }
        if (object instanceof Boolean) {
            return this.writeBoolean((boolean)((Boolean)object));
        }
        if (object instanceof byte[]) {
            return this.writeBinary((byte[])object);
        }
        if (object instanceof CharSequence) {
            return this.writeString(String.valueOf(object));
        }
        if (object instanceof Character) {
            return this.writeString(String.valueOf(((Character)object).charValue()));
        }
        if (object instanceof JsonSerializable) {
            return ((JsonSerializable)object).toJson(this);
        }
        if (object instanceof Object[]) {
            this.writeStartArray();
            for (Object object2 : (Object[])object) {
                this.writeUntyped(object2);
            }
            return this.writeEndArray();
        }
        if (object instanceof Iterable) {
            this.writeStartArray();
            for (Object t2 : (Iterable)object) {
                this.writeUntyped(t2);
            }
            return this.writeEndArray();
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            this.writeStartObject();
            for (Map.Entry entry : map.entrySet()) {
                this.writeFieldName(String.valueOf(entry.getKey())).writeUntyped(entry.getValue());
            }
            return this.writeEndObject();
        }
        if (object.getClass() == Object.class) {
            return this.writeStartObject().writeEndObject();
        }
        return this.writeString(String.valueOf(object));
    }
}

