/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util;

import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public final class ScopeUtil {
    private static final String DEFAULT_SUFFIX = "/.default";
    private static final Pattern SCOPE_PATTERN = Pattern.compile("^[0-9a-zA-Z-.:/]+$");

    public static String scopesToResource(List<String> list) {
        Objects.requireNonNull(list);
        if (list.size() != 1) {
            throw new IllegalArgumentException("To convert to a resource string the specified array must be exactly length 1");
        }
        if (!list.get(0).endsWith(DEFAULT_SUFFIX)) {
            return list.get(0);
        }
        return list.get(0).substring(0, list.get(0).lastIndexOf(DEFAULT_SUFFIX));
    }

    public static String[] resourceToScopes(String string) {
        Objects.requireNonNull(string);
        return new String[]{string + DEFAULT_SUFFIX};
    }

    public static void validateScope(String string) {
        boolean bl2 = SCOPE_PATTERN.matcher(string).matches();
        if (!bl2) {
            throw new IllegalArgumentException("The specified scope is not in expected format. Only alphanumeric characters, '.', '-', ':', and '/' are allowed");
        }
    }

    private ScopeUtil() {
    }
}

