/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Base64Util;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public final class CertificateUtil {
    private static final ClientLogger LOGGER = new ClientLogger(CertificateUtil.class);

    public static PrivateKey privateKeyFromPem(byte[] byArray) {
        Pattern pattern = Pattern.compile("(?s)-----BEGIN PRIVATE KEY-----.*-----END PRIVATE KEY-----");
        Matcher matcher = pattern.matcher(new String(byArray, StandardCharsets.UTF_8));
        if (!matcher.find()) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("Certificate file provided is not a valid PEM file."));
        }
        String string = matcher.group().replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replace("\n", "").replace("\r", "");
        byte[] byArray2 = Base64Util.decode(string.getBytes(StandardCharsets.UTF_8));
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray2);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            throw LOGGER.logExceptionAsError(new IllegalStateException(generalSecurityException));
        }
    }

    public static List<X509Certificate> publicKeyFromPem(byte[] byArray) {
        Pattern pattern = Pattern.compile("(?s)-----BEGIN CERTIFICATE-----.*?-----END CERTIFICATE-----");
        Matcher matcher = pattern.matcher(new String(byArray, StandardCharsets.UTF_8));
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        while (matcher.find()) {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(matcher.group().getBytes(StandardCharsets.UTF_8));
                arrayList.add((X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream));
            }
            catch (CertificateException certificateException) {
                throw LOGGER.logExceptionAsError(new IllegalStateException(certificateException));
            }
        }
        if (arrayList.size() == 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("PEM certificate provided does not contain -----BEGIN CERTIFICATE-----END CERTIFICATE----- block"));
        }
        return arrayList;
    }

    private CertificateUtil() {
    }
}

