/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.intellij;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Aes {
    private static final String MSG_KEY_MUST_NOT_BE_NULL = "Key must not be null";
    private static final String MSG_IV_MUST_NOT_BE_NULL = "IV must not be null";
    private static final String MSG_DATA_MUST_NOT_BE_NULL = "Data must not be null";
    private static final String KEY_TRANSFORMATION = "AES/ECB/NoPadding";
    private static final String DATA_TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final String KEY_ALGORITHM = "AES";

    private Aes() {
    }

    public static byte[] decrypt(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (byArray == null) {
            throw new IllegalArgumentException(MSG_KEY_MUST_NOT_BE_NULL);
        }
        if (byArray2 == null) {
            throw new IllegalArgumentException(MSG_IV_MUST_NOT_BE_NULL);
        }
        if (byArray3 == null) {
            throw new IllegalArgumentException(MSG_DATA_MUST_NOT_BE_NULL);
        }
        return Aes.transformData(byArray, byArray2, byArray3, 2);
    }

    private static byte[] transformData(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        try {
            Cipher cipher = Cipher.getInstance(DATA_TRANSFORMATION);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, KEY_ALGORITHM);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
            cipher.init(n2, (Key)secretKeySpec, ivParameterSpec);
            return cipher.doFinal(byArray3);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UnsupportedOperationException("The specified algorithm is unknown", noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new UnsupportedOperationException("The specified padding is unknown", noSuchPaddingException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new UnsupportedOperationException(invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new UnsupportedOperationException(invalidAlgorithmParameterException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new UnsupportedOperationException(illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new UnsupportedOperationException(badPaddingException);
        }
    }

    public static byte[] transformKey(byte[] byArray, byte[] byArray2, long l2) {
        if (byArray == null) {
            throw new IllegalArgumentException(MSG_KEY_MUST_NOT_BE_NULL);
        }
        if (byArray2 == null) {
            throw new IllegalArgumentException(MSG_DATA_MUST_NOT_BE_NULL);
        }
        if (l2 < 1L) {
            throw new IllegalArgumentException("Rounds must be > 1");
        }
        try {
            Cipher cipher = Cipher.getInstance(KEY_TRANSFORMATION);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, KEY_ALGORITHM);
            cipher.init(1, secretKeySpec);
            for (long i2 = 0L; i2 < l2; ++i2) {
                cipher.update(byArray2, 0, 16, byArray2, 0);
                cipher.update(byArray2, 16, 16, byArray2, 16);
            }
            return byArray2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UnsupportedOperationException("The specified algorithm is unknown", noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new UnsupportedOperationException("The specified padding is unknown", noSuchPaddingException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new UnsupportedOperationException("The key has the wrong size. Have you installed Java Cryptography Extension (JCE)? Is the master key correct?", invalidKeyException);
        }
        catch (ShortBufferException shortBufferException) {
            throw new AssertionError((Object)shortBufferException);
        }
    }
}

