/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenRequestContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.exception.ClientAuthenticationException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.CredentialUnavailableException;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.DeviceCodeInfo;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.CustomClaimRequest;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientBase;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.MsalToken;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.SynchronousAccessor;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.IdentityUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.LoggingUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.ScopeUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.ValidationUtil;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AppTokenProviderParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClaimsRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClientCredentialFactory;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClientCredentialParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ConfidentialClientApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.DeviceCodeFlowParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAccount;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.InteractiveRequestParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.PublicClientApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.SilentParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.TokenProviderResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.UserNamePasswordParameters;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class IdentitySyncClient
extends IdentityClientBase {
    private final SynchronousAccessor<PublicClientApplication> publicClientApplicationAccessor = new SynchronousAccessor<PublicClientApplication>(() -> this.getPublicClient(bl2, false));
    private final SynchronousAccessor<PublicClientApplication> publicClientApplicationAccessorWithCae = new SynchronousAccessor<PublicClientApplication>(() -> this.getPublicClient(bl2, true));
    private final SynchronousAccessor<ConfidentialClientApplication> confidentialClientApplicationAccessor = new SynchronousAccessor<ConfidentialClientApplication>(() -> this.getConfidentialClient(false));
    private final SynchronousAccessor<ConfidentialClientApplication> confidentialClientApplicationAccessorWithCae = new SynchronousAccessor<ConfidentialClientApplication>(() -> this.getConfidentialClient(true));
    private final SynchronousAccessor<ConfidentialClientApplication> managedIdentityConfidentialClientApplicationAccessor = new SynchronousAccessor<ConfidentialClientApplication>(() -> this.getManagedIdentityConfidentialClient());
    private final SynchronousAccessor<ConfidentialClientApplication> workloadIdentityConfidentialClientApplicationAccessor = new SynchronousAccessor<ConfidentialClientApplication>(() -> this.getWorkloadIdentityConfidentialClient());
    private final SynchronousAccessor<String> clientAssertionAccessor;

    IdentitySyncClient(String string, String string2, String string3, String string4, String string5, String string6, Supplier<String> supplier, byte[] byArray, String string7, boolean bl2, Duration duration, IdentityClientOptions identityClientOptions) {
        super(string, string2, string3, string4, string5, string6, supplier, byArray, string7, bl2, duration, identityClientOptions);
        this.clientAssertionAccessor = duration == null ? new SynchronousAccessor<String>(() -> this.parseClientAssertion(), Duration.ofMinutes(5L)) : new SynchronousAccessor<String>(() -> this.parseClientAssertion(), duration);
    }

    private String parseClientAssertion() {
        if (this.clientAssertionFilePath != null) {
            try {
                byte[] byArray = Files.readAllBytes(Paths.get(this.clientAssertionFilePath, new String[0]));
                return new String(byArray, StandardCharsets.UTF_8);
            }
            catch (IOException iOException) {
                throw LOGGER.logExceptionAsError(new RuntimeException(iOException));
            }
        }
        throw LOGGER.logExceptionAsError(new IllegalStateException("Client Assertion File Path is not provided. It should be provided to authenticate with client assertion."));
    }

    public AccessToken authenticateWithConfidentialClient(TokenRequestContext tokenRequestContext) {
        ConfidentialClientApplication confidentialClientApplication = this.getConfidentialClientInstance(tokenRequestContext).getValue();
        ClientCredentialParameters.ClientCredentialParametersBuilder clientCredentialParametersBuilder = ClientCredentialParameters.builder(new HashSet<String>(tokenRequestContext.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, tokenRequestContext, this.options));
        if (this.clientAssertionSupplier != null) {
            clientCredentialParametersBuilder.clientCredential(ClientCredentialFactory.createFromClientAssertion((String)this.clientAssertionSupplier.get()));
        }
        try {
            return new MsalToken(confidentialClientApplication.acquireToken(clientCredentialParametersBuilder.build()).get());
        }
        catch (InterruptedException | ExecutionException exception) {
            throw LOGGER.logExceptionAsError(new RuntimeException(exception));
        }
    }

    private SynchronousAccessor<ConfidentialClientApplication> getConfidentialClientInstance(TokenRequestContext tokenRequestContext) {
        return tokenRequestContext.isCaeEnabled() ? this.confidentialClientApplicationAccessorWithCae : this.confidentialClientApplicationAccessor;
    }

    private SynchronousAccessor<PublicClientApplication> getPublicClientInstance(TokenRequestContext tokenRequestContext) {
        return tokenRequestContext.isCaeEnabled() ? this.publicClientApplicationAccessorWithCae : this.publicClientApplicationAccessor;
    }

    public AccessToken authenticateWithManagedIdentityConfidentialClient(TokenRequestContext tokenRequestContext) {
        ConfidentialClientApplication confidentialClientApplication = this.managedIdentityConfidentialClientApplicationAccessor.getValue();
        ClientCredentialParameters.ClientCredentialParametersBuilder clientCredentialParametersBuilder = ClientCredentialParameters.builder(new HashSet<String>(tokenRequestContext.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, tokenRequestContext, this.options));
        try {
            return new MsalToken(confidentialClientApplication.acquireToken(clientCredentialParametersBuilder.build()).get());
        }
        catch (Exception exception) {
            throw new CredentialUnavailableException("Managed Identity authentication is not available.", (Throwable)exception);
        }
    }

    public AccessToken authenticateWithConfidentialClientCache(TokenRequestContext tokenRequestContext) {
        Object object;
        ConfidentialClientApplication confidentialClientApplication = this.getConfidentialClientInstance(tokenRequestContext).getValue();
        SilentParameters.SilentParametersBuilder silentParametersBuilder = SilentParameters.builder(new HashSet<String>(tokenRequestContext.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, tokenRequestContext, this.options));
        if (tokenRequestContext.isCaeEnabled() && tokenRequestContext.getClaims() != null) {
            object = CustomClaimRequest.formatAsClaimsRequest(tokenRequestContext.getClaims());
            silentParametersBuilder.claims((ClaimsRequest)object);
            silentParametersBuilder.forceRefresh(true);
        }
        try {
            object = confidentialClientApplication.acquireTokenSilently(silentParametersBuilder.build()).get();
            MsalToken msalToken = new MsalToken((IAuthenticationResult)object);
            if (OffsetDateTime.now().isBefore(msalToken.getExpiresAt().minus(REFRESH_OFFSET))) {
                return msalToken;
            }
            throw new IllegalStateException("Received token is close to expiry.");
        }
        catch (MalformedURLException malformedURLException) {
            throw LOGGER.logExceptionAsError(new RuntimeException(malformedURLException.getMessage(), malformedURLException));
        }
        catch (InterruptedException | ExecutionException exception) {
            if (exception.getMessage().contains("Token not found in the cache")) {
                LOGGER.verbose("Token not found in the MSAL cache.");
                return null;
            }
            throw LOGGER.logExceptionAsError(new ClientAuthenticationException(exception.getMessage(), null, exception));
        }
    }

    public MsalToken authenticateWithPublicClientCache(TokenRequestContext tokenRequestContext, IAccount iAccount) {
        PublicClientApplication publicClientApplication = this.getPublicClientInstance(tokenRequestContext).getValue();
        MsalToken msalToken = this.acquireTokenFromPublicClientSilently(tokenRequestContext, publicClientApplication, iAccount, false);
        if (OffsetDateTime.now().isAfter(msalToken.getExpiresAt().minus(REFRESH_OFFSET))) {
            msalToken = this.acquireTokenFromPublicClientSilently(tokenRequestContext, publicClientApplication, iAccount, true);
        }
        return msalToken;
    }

    private MsalToken acquireTokenFromPublicClientSilently(TokenRequestContext tokenRequestContext, PublicClientApplication publicClientApplication, IAccount iAccount, boolean bl2) {
        SilentParameters.SilentParametersBuilder silentParametersBuilder = SilentParameters.builder(new HashSet<String>(tokenRequestContext.getScopes()));
        if (bl2) {
            silentParametersBuilder.forceRefresh(true);
        }
        if (tokenRequestContext.isCaeEnabled() && tokenRequestContext.getClaims() != null) {
            ClaimsRequest claimsRequest = CustomClaimRequest.formatAsClaimsRequest(tokenRequestContext.getClaims());
            silentParametersBuilder.claims(claimsRequest);
            silentParametersBuilder.forceRefresh(true);
        }
        if (iAccount != null) {
            silentParametersBuilder = silentParametersBuilder.account(iAccount);
        }
        silentParametersBuilder.tenant(IdentityUtil.resolveTenantId(this.tenantId, tokenRequestContext, this.options));
        try {
            return new MsalToken(publicClientApplication.acquireTokenSilently(silentParametersBuilder.build()).get());
        }
        catch (MalformedURLException malformedURLException) {
            throw LOGGER.logExceptionAsError(new RuntimeException(malformedURLException.getMessage(), malformedURLException));
        }
        catch (InterruptedException | ExecutionException exception) {
            if (exception.getMessage().contains("Token not found in the cache")) {
                LOGGER.verbose("Token not found in the MSAL cache.");
                return null;
            }
            throw LOGGER.logExceptionAsError(new ClientAuthenticationException(exception.getMessage(), null, exception));
        }
    }

    public MsalToken authenticateWithUsernamePassword(TokenRequestContext tokenRequestContext, String string, String string2) {
        PublicClientApplication publicClientApplication = this.getPublicClientInstance(tokenRequestContext).getValue();
        UserNamePasswordParameters.UserNamePasswordParametersBuilder userNamePasswordParametersBuilder = this.buildUsernamePasswordFlowParameters(tokenRequestContext, string, string2);
        try {
            return new MsalToken(publicClientApplication.acquireToken(userNamePasswordParametersBuilder.build()).get());
        }
        catch (Exception exception) {
            throw LOGGER.logExceptionAsError(new ClientAuthenticationException("Failed to acquire token with username and password. To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/usernamepasswordcredential/troubleshoot", null, exception));
        }
    }

    public MsalToken authenticateWithDeviceCode(TokenRequestContext tokenRequestContext, Consumer<DeviceCodeInfo> consumer) {
        PublicClientApplication publicClientApplication = this.getPublicClientInstance(tokenRequestContext).getValue();
        DeviceCodeFlowParameters.DeviceCodeFlowParametersBuilder deviceCodeFlowParametersBuilder = this.buildDeviceCodeFlowParameters(tokenRequestContext, consumer);
        try {
            return new MsalToken(publicClientApplication.acquireToken(deviceCodeFlowParametersBuilder.build()).get());
        }
        catch (Exception exception) {
            throw LOGGER.logExceptionAsError(new ClientAuthenticationException("Failed to acquire token with device code.", null, exception));
        }
    }

    public MsalToken authenticateWithBrowserInteraction(TokenRequestContext tokenRequestContext, Integer n2, String string, String string2) {
        URI uRI;
        String string3 = n2 != null ? "http://localhost:" + n2 : (string != null ? string : "http://localhost");
        try {
            uRI = new URI(string3);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw LOGGER.logExceptionAsError(new RuntimeException(uRISyntaxException));
        }
        PublicClientApplication publicClientApplication = this.getPublicClientInstance(tokenRequestContext).getValue();
        MsalToken msalToken = null;
        if (this.options.isBrokerEnabled() && this.options.useDefaultBrokerAccount()) {
            try {
                msalToken = this.acquireTokenFromPublicClientSilently(tokenRequestContext, publicClientApplication, null, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (msalToken == null) {
            InteractiveRequestParameters.InteractiveRequestParametersBuilder interactiveRequestParametersBuilder = this.buildInteractiveRequestParameters(tokenRequestContext, string2, uRI);
            try {
                return new MsalToken(publicClientApplication.acquireToken(interactiveRequestParametersBuilder.build()).get());
            }
            catch (Exception exception) {
                throw LOGGER.logExceptionAsError(new ClientAuthenticationException("Failed to acquire token with Interactive Browser Authentication.", null, exception));
            }
        }
        return msalToken;
    }

    public AccessToken authenticateWithAzureCli(TokenRequestContext tokenRequestContext) {
        StringBuilder stringBuilder = new StringBuilder("az account get-access-token --output json --resource ");
        String string = ScopeUtil.scopesToResource(tokenRequestContext.getScopes());
        try {
            ScopeUtil.validateScope(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LOGGER.logExceptionAsError(illegalArgumentException);
        }
        stringBuilder.append(string);
        String string2 = IdentityUtil.resolveTenantId(this.tenantId, tokenRequestContext, this.options);
        ValidationUtil.validateTenantIdCharacterRange(string2, LOGGER);
        if (!CoreUtils.isNullOrEmpty(string2) && !string2.equals("organizations")) {
            stringBuilder.append(" --tenant ").append(string2);
        }
        try {
            return this.getTokenFromAzureCLIAuthentication(stringBuilder);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException instanceof CredentialUnavailableException ? LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, (CredentialUnavailableException)runtimeException) : LOGGER.logExceptionAsError(runtimeException);
        }
    }

    public AccessToken authenticateWithAzureDeveloperCli(TokenRequestContext tokenRequestContext) {
        StringBuilder stringBuilder = new StringBuilder("azd auth token --output json --scope ");
        List<String> list = tokenRequestContext.getScopes();
        if (list.size() == 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("Missing scope in request"));
        }
        list.forEach(string -> {
            try {
                ScopeUtil.validateScope(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw LOGGER.logExceptionAsError(illegalArgumentException);
            }
        });
        stringBuilder.append(String.join((CharSequence)" --scope ", list));
        String string2 = IdentityUtil.resolveTenantId(this.tenantId, tokenRequestContext, this.options);
        ValidationUtil.validateTenantIdCharacterRange(string2, LOGGER);
        if (!CoreUtils.isNullOrEmpty(string2) && !string2.equals("organizations")) {
            stringBuilder.append(" --tenant-id ").append(string2);
        }
        try {
            return this.getTokenFromAzureDeveloperCLIAuthentication(stringBuilder);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException instanceof CredentialUnavailableException ? LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, (CredentialUnavailableException)runtimeException) : LOGGER.logExceptionAsError(runtimeException);
        }
    }

    public AccessToken authenticateWithOBO(TokenRequestContext tokenRequestContext) {
        ConfidentialClientApplication confidentialClientApplication = this.getConfidentialClientInstance(tokenRequestContext).getValue();
        try {
            return new MsalToken(confidentialClientApplication.acquireToken(this.buildOBOFlowParameters(tokenRequestContext)).get());
        }
        catch (Exception exception) {
            throw LOGGER.logExceptionAsError(new ClientAuthenticationException("Failed to acquire token with On Behalf Of Authentication.", null, exception));
        }
    }

    public AccessToken authenticateWithExchangeTokenSync(TokenRequestContext tokenRequestContext) {
        try {
            String string = this.clientAssertionAccessor.getValue();
            return this.authenticateWithExchangeTokenHelper(tokenRequestContext, string);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    Function<AppTokenProviderParameters, CompletableFuture<TokenProviderResult>> getWorkloadIdentityTokenProvider() {
        return appTokenProviderParameters -> {
            TokenRequestContext tokenRequestContext = new TokenRequestContext().setScopes(new ArrayList<String>(appTokenProviderParameters.scopes)).setClaims(appTokenProviderParameters.claims).setTenantId(appTokenProviderParameters.tenantId);
            AccessToken accessToken = this.authenticateWithExchangeTokenSync(tokenRequestContext);
            Supplier<TokenProviderResult> supplier = () -> {
                TokenProviderResult tokenProviderResult = new TokenProviderResult();
                tokenProviderResult.setAccessToken(accessToken.getToken());
                tokenProviderResult.setTenantId(tokenRequestContext.getTenantId());
                tokenProviderResult.setExpiresInSeconds(accessToken.getExpiresAt().toEpochSecond());
                return tokenProviderResult;
            };
            return this.options.getExecutorService() != null ? CompletableFuture.supplyAsync(supplier, this.options.getExecutorService()) : CompletableFuture.supplyAsync(supplier);
        };
    }

    public AccessToken authenticateWithWorkloadIdentityConfidentialClient(TokenRequestContext tokenRequestContext) {
        ConfidentialClientApplication confidentialClientApplication = this.workloadIdentityConfidentialClientApplicationAccessor.getValue();
        try {
            ClientCredentialParameters.ClientCredentialParametersBuilder clientCredentialParametersBuilder = ClientCredentialParameters.builder(new HashSet<String>(tokenRequestContext.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, tokenRequestContext, this.options));
            return new MsalToken(confidentialClientApplication.acquireToken(clientCredentialParametersBuilder.build()).get());
        }
        catch (Exception exception) {
            throw new CredentialUnavailableException("Managed Identity authentication is not available.", (Throwable)exception);
        }
    }

    public IdentityClientOptions getIdentityClientOptions() {
        return this.options;
    }

    @Override
    Mono<AccessToken> getTokenFromTargetManagedIdentity(TokenRequestContext tokenRequestContext) {
        return null;
    }
}

