/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenRequestContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.exception.ClientAuthenticationException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpClient;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeader;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaders;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipeline;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineBuilder;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.ProxyOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.AddHeadersPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpLogOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpLoggingPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpPipelinePolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpPolicyProviders;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.UserAgentPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ClientOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.UserAgentUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.builder.ClientBuilderUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.JacksonAdapter;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.SerializerAdapter;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.SerializerEncoding;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.BrowserCustomizationOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.CredentialUnavailableException;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.DeviceCodeInfo;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.TokenCachePersistenceOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.CustomClaimRequest;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.HttpPipelineAdapter;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClient;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.MSIToken;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.PersistentTokenCacheImpl;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.RegionalAuthority;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.models.AzureCliToken;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.CertificateUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.IdentityUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.LoggingUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonProviders;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AbstractApplicationBase;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AbstractClientApplicationBase;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AppTokenProviderParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClaimsRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClientCredentialFactory;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ConfidentialClientApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.DeviceCodeFlowParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IBroker;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IClientCredential;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IClientSecret;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ITokenCacheAccessAspect;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.InteractiveRequestParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.OnBehalfOfParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.Prompt;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.PublicClientApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.SystemBrowserOptions;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.TokenProviderResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.UserNamePasswordParameters;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public abstract class IdentityClientBase {
    static final SerializerAdapter SERIALIZER_ADAPTER = JacksonAdapter.createDefaultSerializerAdapter();
    static final String WINDOWS_STARTER = "cmd.exe";
    static final String LINUX_MAC_STARTER = "/bin/sh";
    static final String WINDOWS_SWITCHER = "/c";
    static final String LINUX_MAC_SWITCHER = "-c";
    static final Pattern WINDOWS_PROCESS_ERROR_MESSAGE = Pattern.compile("'azd?' is not recognized");
    static final Pattern SH_PROCESS_ERROR_MESSAGE = Pattern.compile("azd?:.*not found");
    static final String DEFAULT_WINDOWS_PS_EXECUTABLE = "pwsh.exe";
    static final String LEGACY_WINDOWS_PS_EXECUTABLE = "powershell.exe";
    static final String DEFAULT_LINUX_PS_EXECUTABLE = "pwsh";
    static final String DEFAULT_MAC_LINUX_PATH = "/bin/";
    static final Duration REFRESH_OFFSET = Duration.ofMinutes(5L);
    static final String IDENTITY_ENDPOINT_VERSION = "2019-08-01";
    static final String MSI_ENDPOINT_VERSION = "2017-09-01";
    static final String ARC_MANAGED_IDENTITY_ENDPOINT_API_VERSION = "2019-11-01";
    static final String ADFS_TENANT = "adfs";
    static final String HTTP_LOCALHOST = "http://localhost";
    static final String SERVICE_FABRIC_MANAGED_IDENTITY_API_VERSION = "2019-07-01-preview";
    static final ClientLogger LOGGER = new ClientLogger(IdentityClient.class);
    static final Pattern ACCESS_TOKEN_PATTERN = Pattern.compile("\"accessToken\": \"(.*?)(\"|$)");
    static final Pattern TRAILING_FORWARD_SLASHES = Pattern.compile("/+$");
    private static final String AZURE_IDENTITY_PROPERTIES = "azure-identity.properties";
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private static final ClientOptions DEFAULT_CLIENT_OPTIONS = new ClientOptions();
    private final Map<String, String> properties;
    final IdentityClientOptions options;
    final String tenantId;
    final String clientId;
    final String resourceId;
    final String clientSecret;
    final String clientAssertionFilePath;
    final byte[] certificate;
    final String certificatePath;
    final Supplier<String> clientAssertionSupplier;
    final String certificatePassword;
    HttpPipelineAdapter httpPipelineAdapter;
    String userAgent = "azsdk-java";
    private Class<?> interactiveBrowserBroker;
    private Method getMsalRuntimeBroker;

    IdentityClientBase(String string, String string2, String string3, String string4, String string5, String string6, Supplier<String> supplier, byte[] byArray, String string7, boolean bl2, Duration duration, IdentityClientOptions identityClientOptions) {
        if (string == null) {
            string = "organizations";
            identityClientOptions.setAdditionallyAllowedTenants(Collections.singletonList("*"));
        }
        if (identityClientOptions == null) {
            identityClientOptions = new IdentityClientOptions();
        }
        this.tenantId = string;
        this.clientId = string2;
        this.resourceId = string6;
        this.clientSecret = string3;
        this.clientAssertionFilePath = string5;
        this.certificatePath = string4;
        this.certificate = byArray;
        this.certificatePassword = string7;
        this.clientAssertionSupplier = supplier;
        this.options = identityClientOptions;
        this.properties = CoreUtils.getProperties(AZURE_IDENTITY_PROPERTIES);
    }

    ConfidentialClientApplication getConfidentialClient(boolean bl2) {
        Object object;
        Object object2;
        Object object3;
        IClientCredential iClientCredential;
        if (this.clientId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("A non-null value for client ID must be provided for user authentication."));
        }
        String string = TRAILING_FORWARD_SLASHES.matcher(this.options.getAuthorityHost()).replaceAll("") + "/" + this.tenantId;
        if (this.clientSecret != null) {
            iClientCredential = ClientCredentialFactory.createFromSecret(this.clientSecret);
        } else if (this.certificate != null || this.certificatePath != null) {
            try {
                if (this.certificatePassword == null) {
                    object3 = this.getCertificateBytes();
                    object2 = CertificateUtil.publicKeyFromPem((byte[])object3);
                    object = CertificateUtil.privateKeyFromPem((byte[])object3);
                    if (object2.size() == 1) {
                        iClientCredential = ClientCredentialFactory.createFromCertificate((PrivateKey)object, object2.get(0));
                    }
                    iClientCredential = ClientCredentialFactory.createFromCertificateChain((PrivateKey)object, object2);
                }
                object3 = this.getCertificateInputStream();
                try {
                    iClientCredential = ClientCredentialFactory.createFromCertificate((InputStream)object3, this.certificatePassword);
                }
                finally {
                    if (object3 != null) {
                        ((InputStream)object3).close();
                    }
                }
            }
            catch (IOException | GeneralSecurityException exception) {
                throw LOGGER.logExceptionAsError(new RuntimeException("Failed to parse the certificate for the credential: " + exception.getMessage(), exception));
            }
        } else if (this.clientAssertionSupplier != null) {
            iClientCredential = ClientCredentialFactory.createFromClientAssertion(this.clientAssertionSupplier.get());
        } else {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("Must provide client secret or client certificate path. To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/serviceprincipalauthentication/troubleshoot"));
        }
        object3 = ConfidentialClientApplication.builder(this.clientId, iClientCredential);
        try {
            object3 = (ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)((AbstractApplicationBase.Builder)object3).logPii(this.options.isUnsafeSupportLoggingEnabled())).authority(string)).instanceDiscovery(this.options.isInstanceDiscoveryEnabled());
            if (!this.options.isInstanceDiscoveryEnabled()) {
                LOGGER.log(LogLevel.VERBOSE, () -> "Instance discovery and authority validation is disabled. In this state, the library will not fetch metadata to validate the specified authority host. As a result, it is crucial to ensure that the configured authority host is valid and trustworthy.");
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw LOGGER.logExceptionAsWarning(new IllegalStateException(malformedURLException));
        }
        if (bl2) {
            object2 = new HashSet(1);
            object2.add((String)"CP1");
            ((AbstractClientApplicationBase.Builder)object3).clientCapabilities((Set<String>)object2);
        }
        ((ConfidentialClientApplication.Builder)object3).sendX5c(this.options.isIncludeX5c());
        this.initializeHttpPipelineAdapter();
        if (this.httpPipelineAdapter != null) {
            ((AbstractApplicationBase.Builder)object3).httpClient(this.httpPipelineAdapter);
        } else {
            ((AbstractApplicationBase.Builder)object3).proxy(IdentityClientBase.proxyOptionsToJavaNetProxy(this.options.getProxyOptions()));
        }
        if (this.options.getExecutorService() != null) {
            ((AbstractApplicationBase.Builder)object3).executorService(this.options.getExecutorService());
        }
        object2 = this.options.getTokenCacheOptions();
        object = null;
        if (object2 != null) {
            try {
                object = new PersistentTokenCacheImpl(bl2).setAllowUnencryptedStorage(((TokenCachePersistenceOptions)object2).isUnencryptedStorageAllowed()).setName(((TokenCachePersistenceOptions)object2).getName());
                ((AbstractClientApplicationBase.Builder)object3).setTokenCacheAccessAspect((ITokenCacheAccessAspect)object);
            }
            catch (Throwable throwable) {
                throw LOGGER.logExceptionAsError(new ClientAuthenticationException("Shared token cache is unavailable in this environment.", null, throwable));
            }
        }
        if (this.options.getRegionalAuthority() != null) {
            if (this.options.getRegionalAuthority() == RegionalAuthority.AUTO_DISCOVER_REGION) {
                ((AbstractClientApplicationBase.Builder)object3).autoDetectRegion(true);
            } else {
                ((AbstractClientApplicationBase.Builder)object3).azureRegion(this.options.getRegionalAuthority().toString());
            }
        }
        ConfidentialClientApplication confidentialClientApplication = ((ConfidentialClientApplication.Builder)object3).build();
        if (object != null) {
            ((PersistentTokenCacheImpl)object).registerCache();
        }
        return confidentialClientApplication;
    }

    PublicClientApplication getPublicClient(boolean bl2, boolean bl3) {
        Object object;
        if (this.clientId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("A non-null value for client ID must be provided for user authentication."));
        }
        String string = TRAILING_FORWARD_SLASHES.matcher(this.options.getAuthorityHost()).replaceAll("") + "/" + this.tenantId;
        PublicClientApplication.Builder builder = PublicClientApplication.builder(this.clientId);
        try {
            builder = (PublicClientApplication.Builder)((PublicClientApplication.Builder)((PublicClientApplication.Builder)builder.logPii(this.options.isUnsafeSupportLoggingEnabled())).authority(string)).instanceDiscovery(this.options.isInstanceDiscoveryEnabled());
            if (!this.options.isInstanceDiscoveryEnabled()) {
                LOGGER.log(LogLevel.VERBOSE, () -> "Instance discovery and authority validation is disabled. In this state, the library will not fetch metadata to validate the specified authority host. As a result, it is crucial to ensure that the configured authority host is valid and trustworthy.");
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw LOGGER.logExceptionAsWarning(new IllegalStateException(malformedURLException));
        }
        this.initializeHttpPipelineAdapter();
        if (this.httpPipelineAdapter != null) {
            builder.httpClient(this.httpPipelineAdapter);
        } else {
            builder.proxy(IdentityClientBase.proxyOptionsToJavaNetProxy(this.options.getProxyOptions()));
        }
        if (this.options.getExecutorService() != null) {
            builder.executorService(this.options.getExecutorService());
        }
        if (bl3) {
            object = new HashSet<String>(1);
            object.add("CP1");
            builder.clientCapabilities((Set<String>)object);
        }
        if (this.options.isBrokerEnabled()) {
            if (this.interactiveBrowserBroker == null) {
                try {
                    this.interactiveBrowserBroker = Class.forName("macromedia.jdbc.sqlserver.externals.com.azure.identity.broker.implementation.InteractiveBrowserBroker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw LOGGER.logExceptionAsError(new IllegalStateException("Could not load the brokered authentication library. Ensure that the azure-identity-broker library is on the classpath.", classNotFoundException));
                }
                this.getMsalRuntimeBroker = null;
                try {
                    this.getMsalRuntimeBroker = this.interactiveBrowserBroker.getMethod("getMsalRuntimeBroker", new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw LOGGER.logExceptionAsError(new IllegalStateException("Could not obtain the InteractiveBrowserBroker. Ensure that the azure-identity-broker library is on the classpath.", noSuchMethodException));
                }
            }
            try {
                if (this.getMsalRuntimeBroker == null) {
                    throw LOGGER.logExceptionAsError(new IllegalStateException("Could not obtain the MSAL Broker. Ensure that the azure-identity-broker library is on the classpath.", null));
                }
                builder.broker((IBroker)this.getMsalRuntimeBroker.invoke(null, new Object[0]));
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                throw LOGGER.logExceptionAsError(new IllegalStateException("Could not invoke the MSAL Broker. Ensure that the azure-identity-broker library is on the classpath.", reflectiveOperationException));
            }
        }
        object = this.options.getTokenCacheOptions();
        PersistentTokenCacheImpl persistentTokenCacheImpl = null;
        if (object != null) {
            try {
                persistentTokenCacheImpl = new PersistentTokenCacheImpl(bl3).setAllowUnencryptedStorage(((TokenCachePersistenceOptions)object).isUnencryptedStorageAllowed()).setName(((TokenCachePersistenceOptions)object).getName());
                builder.setTokenCacheAccessAspect(persistentTokenCacheImpl);
            }
            catch (Throwable throwable) {
                throw LOGGER.logExceptionAsError(new ClientAuthenticationException("Shared token cache is unavailable in this environment.", null, throwable));
            }
        }
        PublicClientApplication publicClientApplication = builder.build();
        if (persistentTokenCacheImpl != null) {
            persistentTokenCacheImpl.registerCache();
        }
        return publicClientApplication;
    }

    ConfidentialClientApplication getManagedIdentityConfidentialClient() {
        String string = TRAILING_FORWARD_SLASHES.matcher(this.options.getAuthorityHost()).replaceAll("") + "/" + this.tenantId;
        IClientSecret iClientSecret = ClientCredentialFactory.createFromSecret(this.clientSecret != null ? this.clientSecret : "dummy-secret");
        ConfidentialClientApplication.Builder builder = ConfidentialClientApplication.builder(this.clientId == null ? "SYSTEM-ASSIGNED-MANAGED-IDENTITY" : this.clientId, iClientSecret);
        ((ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)builder.instanceDiscovery(false)).validateAuthority(false)).logPii(this.options.isUnsafeSupportLoggingEnabled());
        try {
            builder = (ConfidentialClientApplication.Builder)builder.authority(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw LOGGER.logExceptionAsWarning(new IllegalStateException(malformedURLException));
        }
        if (this.options.getManagedIdentityType() == null) {
            throw LOGGER.logExceptionAsError(new CredentialUnavailableException("Managed Identity type not configured, authentication not available."));
        }
        builder.appTokenProvider(appTokenProviderParameters -> {
            TokenRequestContext tokenRequestContext = new TokenRequestContext().setScopes(new ArrayList<String>(appTokenProviderParameters.scopes)).setClaims(appTokenProviderParameters.claims).setTenantId(appTokenProviderParameters.tenantId);
            Mono<AccessToken> mono = this.getTokenFromTargetManagedIdentity(tokenRequestContext);
            return mono.map(accessToken -> {
                TokenProviderResult tokenProviderResult = new TokenProviderResult();
                tokenProviderResult.setAccessToken(accessToken.getToken());
                tokenProviderResult.setTenantId(tokenRequestContext.getTenantId());
                tokenProviderResult.setExpiresInSeconds(accessToken.getExpiresAt().toEpochSecond());
                return tokenProviderResult;
            }).toFuture();
        });
        this.initializeHttpPipelineAdapter();
        if (this.httpPipelineAdapter != null) {
            builder.httpClient(this.httpPipelineAdapter);
        } else {
            builder.proxy(IdentityClientBase.proxyOptionsToJavaNetProxy(this.options.getProxyOptions()));
        }
        if (this.options.getExecutorService() != null) {
            builder.executorService(this.options.getExecutorService());
        }
        return builder.build();
    }

    ConfidentialClientApplication getWorkloadIdentityConfidentialClient() {
        String string = TRAILING_FORWARD_SLASHES.matcher(this.options.getAuthorityHost()).replaceAll("") + "/" + this.tenantId;
        IClientSecret iClientSecret = ClientCredentialFactory.createFromSecret(this.clientSecret != null ? this.clientSecret : "dummy-secret");
        ConfidentialClientApplication.Builder builder = ConfidentialClientApplication.builder(this.clientId == null ? "SYSTEM-ASSIGNED-MANAGED-IDENTITY" : this.clientId, iClientSecret);
        try {
            builder = (ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)builder.authority(string)).logPii(this.options.isUnsafeSupportLoggingEnabled())).instanceDiscovery(this.options.isInstanceDiscoveryEnabled());
            if (!this.options.isInstanceDiscoveryEnabled()) {
                LOGGER.log(LogLevel.VERBOSE, () -> "Instance discovery and authority validation is disabled. In this state, the library will not fetch metadata to validate the specified authority host. As a result, it is crucial to ensure that the configured authority host is valid and trustworthy.");
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw LOGGER.logExceptionAsWarning(new IllegalStateException(malformedURLException));
        }
        builder.appTokenProvider(this.getWorkloadIdentityTokenProvider());
        this.initializeHttpPipelineAdapter();
        if (this.httpPipelineAdapter != null) {
            builder.httpClient(this.httpPipelineAdapter);
        } else {
            builder.proxy(IdentityClientBase.proxyOptionsToJavaNetProxy(this.options.getProxyOptions()));
        }
        if (this.options.getExecutorService() != null) {
            builder.executorService(this.options.getExecutorService());
        }
        return builder.build();
    }

    abstract Function<AppTokenProviderParameters, CompletableFuture<TokenProviderResult>> getWorkloadIdentityTokenProvider();

    DeviceCodeFlowParameters.DeviceCodeFlowParametersBuilder buildDeviceCodeFlowParameters(TokenRequestContext tokenRequestContext, Consumer<DeviceCodeInfo> consumer) {
        DeviceCodeFlowParameters.DeviceCodeFlowParametersBuilder deviceCodeFlowParametersBuilder = DeviceCodeFlowParameters.builder(new HashSet<String>(tokenRequestContext.getScopes()), deviceCode -> consumer.accept(new DeviceCodeInfo(deviceCode.userCode(), deviceCode.deviceCode(), deviceCode.verificationUri(), OffsetDateTime.now().plusSeconds(deviceCode.expiresIn()), deviceCode.message()))).tenant(IdentityUtil.resolveTenantId(this.tenantId, tokenRequestContext, this.options));
        if (tokenRequestContext.getClaims() != null) {
            ClaimsRequest claimsRequest = CustomClaimRequest.formatAsClaimsRequest(tokenRequestContext.getClaims());
            deviceCodeFlowParametersBuilder.claims(claimsRequest);
        }
        return deviceCodeFlowParametersBuilder;
    }

    OnBehalfOfParameters buildOBOFlowParameters(TokenRequestContext tokenRequestContext) {
        OnBehalfOfParameters.OnBehalfOfParametersBuilder onBehalfOfParametersBuilder = OnBehalfOfParameters.builder(new HashSet<String>(tokenRequestContext.getScopes()), this.options.getUserAssertion()).tenant(IdentityUtil.resolveTenantId(this.tenantId, tokenRequestContext, this.options));
        if (tokenRequestContext.isCaeEnabled() && tokenRequestContext.getClaims() != null) {
            ClaimsRequest claimsRequest = CustomClaimRequest.formatAsClaimsRequest(tokenRequestContext.getClaims());
            onBehalfOfParametersBuilder.claims(claimsRequest);
        }
        return onBehalfOfParametersBuilder.build();
    }

    InteractiveRequestParameters.InteractiveRequestParametersBuilder buildInteractiveRequestParameters(TokenRequestContext tokenRequestContext, String string, URI uRI) {
        Object object;
        Object object2;
        InteractiveRequestParameters.InteractiveRequestParametersBuilder interactiveRequestParametersBuilder = InteractiveRequestParameters.builder(uRI).scopes(new HashSet<String>(tokenRequestContext.getScopes())).prompt(Prompt.SELECT_ACCOUNT).tenant(IdentityUtil.resolveTenantId(this.tenantId, tokenRequestContext, this.options));
        if (tokenRequestContext.isCaeEnabled() && tokenRequestContext.getClaims() != null) {
            object2 = CustomClaimRequest.formatAsClaimsRequest(tokenRequestContext.getClaims());
            interactiveRequestParametersBuilder.claims((ClaimsRequest)object2);
        }
        if (IdentityUtil.browserCustomizationOptionsPresent((BrowserCustomizationOptions)(object2 = this.options.getBrowserCustomizationOptions()))) {
            object = SystemBrowserOptions.builder();
            if (!CoreUtils.isNullOrEmpty(((BrowserCustomizationOptions)object2).getSuccessMessage())) {
                ((SystemBrowserOptions.SystemBrowserOptionsBuilder)object).htmlMessageSuccess(((BrowserCustomizationOptions)object2).getSuccessMessage());
            }
            if (!CoreUtils.isNullOrEmpty(((BrowserCustomizationOptions)object2).getErrorMessage())) {
                ((SystemBrowserOptions.SystemBrowserOptionsBuilder)object).htmlMessageError(((BrowserCustomizationOptions)object2).getErrorMessage());
            }
            interactiveRequestParametersBuilder.systemBrowserOptions(((SystemBrowserOptions.SystemBrowserOptionsBuilder)object).build());
        }
        if (this.options.isBrokerEnabled()) {
            interactiveRequestParametersBuilder.windowHandle(this.options.getBrokerWindowHandle());
            if (this.options.isMsaPassthroughEnabled()) {
                object = new HashMap();
                object.put("msal_request_type", "consumer_passthrough");
                interactiveRequestParametersBuilder.extraQueryParameters((Map<String, String>)object);
            }
        }
        if (string != null) {
            interactiveRequestParametersBuilder.loginHint(string);
        }
        return interactiveRequestParametersBuilder;
    }

    UserNamePasswordParameters.UserNamePasswordParametersBuilder buildUsernamePasswordFlowParameters(TokenRequestContext tokenRequestContext, String string, String string2) {
        UserNamePasswordParameters.UserNamePasswordParametersBuilder userNamePasswordParametersBuilder = UserNamePasswordParameters.builder(new HashSet<String>(tokenRequestContext.getScopes()), string, string2.toCharArray());
        if (tokenRequestContext.isCaeEnabled() && tokenRequestContext.getClaims() != null) {
            ClaimsRequest claimsRequest = CustomClaimRequest.formatAsClaimsRequest(tokenRequestContext.getClaims());
            userNamePasswordParametersBuilder.claims(claimsRequest);
        }
        userNamePasswordParametersBuilder.tenant(IdentityUtil.resolveTenantId(this.tenantId, tokenRequestContext, this.options));
        return userNamePasswordParametersBuilder;
    }

    AccessToken getTokenFromAzureCLIAuthentication(StringBuilder stringBuilder) {
        AccessToken accessToken;
        try {
            Object object;
            String string;
            String string2;
            if (IdentityUtil.isWindowsPlatform()) {
                string2 = WINDOWS_STARTER;
                string = WINDOWS_SWITCHER;
            } else {
                string2 = LINUX_MAC_STARTER;
                string = LINUX_MAC_SWITCHER;
            }
            ProcessBuilder processBuilder = new ProcessBuilder(string2, string, stringBuilder.toString());
            processBuilder.redirectInput(ProcessBuilder.Redirect.from(IdentityUtil.NULL_FILE));
            String string3 = this.getSafeWorkingDirectory();
            if (string3 == null) {
                throw LOGGER.logExceptionAsError(new IllegalStateException("A Safe Working directory could not be found to execute CLI command from. To mitigate this issue, please refer to the troubleshooting  guidelines here at https://aka.ms/azsdk/java/identity/azclicredential/troubleshoot"));
            }
            processBuilder.directory(new File(string3));
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            StringBuilder stringBuilder2 = new StringBuilder();
            try (Object object2 = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                while ((object = ((BufferedReader)object2).readLine()) != null) {
                    if (WINDOWS_PROCESS_ERROR_MESSAGE.matcher((CharSequence)object).find() || SH_PROCESS_ERROR_MESSAGE.matcher((CharSequence)object).find()) {
                        throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("AzureCliCredential authentication unavailable. Azure CLI not installed.To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/azclicredential/troubleshoot"));
                    }
                    stringBuilder2.append((String)object);
                }
            }
            object2 = stringBuilder2.toString();
            process.waitFor(this.options.getCredentialProcessTimeout().getSeconds(), TimeUnit.SECONDS);
            if (process.exitValue() != 0) {
                if (((String)object2).length() > 0) {
                    object = this.redactInfo((String)object2);
                    if (((String)object).contains("az login") || ((String)object).contains("az account set")) {
                        throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("AzureCliCredential authentication unavailable. Please run 'az login' to set up account. To further mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/azclicredential/troubleshoot"));
                    }
                    throw LOGGER.logExceptionAsError(new ClientAuthenticationException((String)object, null));
                }
                throw LOGGER.logExceptionAsError(new ClientAuthenticationException("Failed to invoke Azure CLI ", null));
            }
            LOGGER.verbose("Azure CLI Authentication => A token response was received from Azure CLI, deserializing the response into an Access Token.");
            object = JsonProviders.createReader((String)object2);
            try {
                AzureCliToken azureCliToken = AzureCliToken.fromJson((JsonReader)object);
                String string4 = azureCliToken.getAccessToken();
                OffsetDateTime offsetDateTime = azureCliToken.getTokenExpiration();
                accessToken = new AccessToken(string4, offsetDateTime);
            }
            finally {
                if (object != null) {
                    ((JsonReader)object).close();
                }
            }
        }
        catch (IOException | InterruptedException exception) {
            IllegalStateException illegalStateException = new IllegalStateException(this.redactInfo(exception.getMessage()));
            illegalStateException.setStackTrace(exception.getStackTrace());
            throw LOGGER.logExceptionAsError(illegalStateException);
        }
        return accessToken;
    }

    AccessToken getTokenFromAzureDeveloperCLIAuthentication(StringBuilder stringBuilder) {
        AccessToken accessToken;
        try {
            Object object;
            String string;
            String string2;
            if (IdentityUtil.isWindowsPlatform()) {
                string2 = WINDOWS_STARTER;
                string = WINDOWS_SWITCHER;
            } else {
                string2 = LINUX_MAC_STARTER;
                string = LINUX_MAC_SWITCHER;
            }
            ProcessBuilder processBuilder = new ProcessBuilder(string2, string, stringBuilder.toString());
            processBuilder.redirectInput(ProcessBuilder.Redirect.from(IdentityUtil.NULL_FILE));
            String string3 = this.getSafeWorkingDirectory();
            if (string3 == null) {
                throw LOGGER.logExceptionAsError(new IllegalStateException("A Safe Working directory could not be found to execute Azure Developer CLI command from."));
            }
            processBuilder.directory(new File(string3));
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            StringBuilder stringBuilder2 = new StringBuilder();
            try (Object object2 = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8.name()));){
                while ((object = ((BufferedReader)object2).readLine()) != null) {
                    if (WINDOWS_PROCESS_ERROR_MESSAGE.matcher((CharSequence)object).find() || SH_PROCESS_ERROR_MESSAGE.matcher((CharSequence)object).find()) {
                        throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("AzureDeveloperCliCredential authentication unavailable. Azure Developer CLI not installed.To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/azdevclicredential/troubleshoot"));
                    }
                    stringBuilder2.append((String)object);
                }
            }
            object2 = stringBuilder2.toString();
            process.waitFor(this.options.getCredentialProcessTimeout().getSeconds(), TimeUnit.SECONDS);
            if (process.exitValue() != 0) {
                if (((String)object2).length() > 0) {
                    object = this.redactInfo((String)object2);
                    if (((String)object).contains("azd auth login") || ((String)object).contains("not logged in")) {
                        throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("AzureDeveloperCliCredential authentication unavailable. Please run 'azd auth login' to set up account."));
                    }
                    throw LOGGER.logExceptionAsError(new ClientAuthenticationException((String)object, null));
                }
                throw LOGGER.logExceptionAsError(new ClientAuthenticationException("Failed to invoke Azure Developer CLI ", null));
            }
            LOGGER.verbose("Azure Developer CLI Authentication => A token response was received from Azure Developer CLI, deserializing the response into an Access Token.");
            object = (Map)SERIALIZER_ADAPTER.deserialize((String)object2, (Type)((Object)Map.class), SerializerEncoding.JSON);
            String string4 = (String)object.get("token");
            String string5 = (String)object.get("expiresOn");
            String string6 = string5.substring(0, string5.indexOf("Z"));
            OffsetDateTime offsetDateTime = LocalDateTime.parse(string6, DateTimeFormatter.ISO_LOCAL_DATE_TIME).atZone(ZoneId.of("Z")).toOffsetDateTime().withOffsetSameInstant(ZoneOffset.UTC);
            accessToken = new AccessToken(string4, offsetDateTime);
        }
        catch (IOException | InterruptedException exception) {
            IllegalStateException illegalStateException = new IllegalStateException(this.redactInfo(exception.getMessage()));
            illegalStateException.setStackTrace(exception.getStackTrace());
            throw LOGGER.logExceptionAsError(illegalStateException);
        }
        return accessToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AccessToken authenticateWithExchangeTokenHelper(TokenRequestContext tokenRequestContext, String string) throws IOException {
        String string2 = TRAILING_FORWARD_SLASHES.matcher(this.options.getAuthorityHost()).replaceAll("") + "/" + this.tenantId + "/oauth2/v2.0/token";
        String string3 = "client_assertion=" + string + "&client_assertion_type=urn:ietf:params:oauth:client-assertion-type:jwt-bearer&client_id=" + this.clientId + "&grant_type=client_credentials&scope=" + IdentityClientBase.urlEncode(tokenRequestContext.getScopes().get(0));
        byte[] byArray = string3.getBytes(StandardCharsets.UTF_8);
        int n2 = byArray.length;
        HttpURLConnection httpURLConnection = null;
        URL uRL = IdentityClientBase.getUrl(string2);
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpURLConnection.setRequestProperty("Content-Length", Integer.toString(n2));
            httpURLConnection.setRequestProperty("User-Agent", this.userAgent);
            httpURLConnection.setDoOutput(true);
            try (Object object = new DataOutputStream(httpURLConnection.getOutputStream());){
                ((FilterOutputStream)object).write(byArray);
            }
            httpURLConnection.connect();
            object = (AccessToken)SERIALIZER_ADAPTER.deserialize(httpURLConnection.getInputStream(), (Type)((Object)MSIToken.class), SerializerEncoding.JSON);
            return object;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    String getSafeWorkingDirectory() {
        if (IdentityUtil.isWindowsPlatform()) {
            String string = System.getenv("SystemRoot");
            if (CoreUtils.isNullOrEmpty(string)) {
                return null;
            }
            return string + "\\system32";
        }
        return DEFAULT_MAC_LINUX_PATH;
    }

    String redactInfo(String string) {
        return ACCESS_TOKEN_PATTERN.matcher(string).replaceAll("****");
    }

    abstract Mono<AccessToken> getTokenFromTargetManagedIdentity(TokenRequestContext var1);

    HttpPipeline setupPipeline(HttpClient httpClient) {
        ArrayList<HttpPipelinePolicy> arrayList = new ArrayList<HttpPipelinePolicy>();
        String string = this.properties.getOrDefault(SDK_NAME, "UnknownName");
        String string2 = this.properties.getOrDefault(SDK_VERSION, "UnknownVersion");
        Configuration configuration = Configuration.getGlobalConfiguration().clone();
        HttpLogOptions httpLogOptions = this.options.getHttpLogOptions() == null ? new HttpLogOptions() : this.options.getHttpLogOptions();
        ClientOptions clientOptions = this.options.getClientOptions() != null ? this.options.getClientOptions() : DEFAULT_CLIENT_OPTIONS;
        this.userAgent = UserAgentUtil.toUserAgentString(CoreUtils.getApplicationId(clientOptions, httpLogOptions), string, string2, configuration);
        arrayList.add(new UserAgentPolicy(this.userAgent));
        ArrayList<HttpHeader> arrayList2 = new ArrayList<HttpHeader>();
        clientOptions.getHeaders().forEach(header -> arrayList2.add(new HttpHeader(header.getName(), header.getValue())));
        arrayList.add(new AddHeadersPolicy(new HttpHeaders(arrayList2)));
        arrayList.addAll(this.options.getPerCallPolicies());
        HttpPolicyProviders.addBeforeRetryPolicies(arrayList);
        arrayList.add(ClientBuilderUtil.validateAndGetRetryPolicy(this.options.getRetryPolicy(), this.options.getRetryOptions()));
        arrayList.addAll(this.options.getPerRetryPolicies());
        HttpPolicyProviders.addAfterRetryPolicies(arrayList);
        arrayList.add(new HttpLoggingPolicy(httpLogOptions));
        return new HttpPipelineBuilder().httpClient(httpClient).clientOptions(clientOptions).policies(arrayList.toArray(new HttpPipelinePolicy[0])).build();
    }

    void initializeHttpPipelineAdapter() {
        HttpPipeline httpPipeline = this.options.getHttpPipeline();
        if (httpPipeline != null) {
            this.httpPipelineAdapter = new HttpPipelineAdapter(httpPipeline, this.options);
        } else {
            HttpClient httpClient = this.options.getHttpClient();
            if (httpClient != null) {
                this.httpPipelineAdapter = new HttpPipelineAdapter(this.setupPipeline(httpClient), this.options);
            } else if (this.options.getProxyOptions() == null) {
                this.httpPipelineAdapter = new HttpPipelineAdapter(this.setupPipeline(HttpClient.createDefault()), this.options);
            }
        }
    }

    private byte[] getCertificateBytes() throws IOException {
        if (this.certificatePath != null) {
            return Files.readAllBytes(Paths.get(this.certificatePath, new String[0]));
        }
        if (this.certificate != null) {
            return this.certificate;
        }
        return new byte[0];
    }

    private InputStream getCertificateInputStream() throws IOException {
        if (this.certificatePath != null) {
            return new BufferedInputStream(new FileInputStream(this.certificatePath));
        }
        return new ByteArrayInputStream(this.certificate);
    }

    private static Proxy proxyOptionsToJavaNetProxy(ProxyOptions proxyOptions) {
        switch (proxyOptions.getType()) {
            case SOCKS4: 
            case SOCKS5: {
                return new Proxy(Proxy.Type.SOCKS, proxyOptions.getAddress());
            }
        }
        return new Proxy(Proxy.Type.HTTP, proxyOptions.getAddress());
    }

    static String urlEncode(String string) throws IOException {
        return URLEncoder.encode(string, StandardCharsets.UTF_8.name());
    }

    static URL getUrl(String string) throws MalformedURLException {
        return new URL(string);
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getClientId() {
        return this.clientId;
    }
}

