/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import java.util.Arrays;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.CredentialBuilderBase;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.VisualStudioCodeCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.IdentityUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.ValidationUtil;

public class VisualStudioCodeCredentialBuilder
extends CredentialBuilderBase<VisualStudioCodeCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(VisualStudioCodeCredentialBuilder.class);
    private String tenantId;

    public VisualStudioCodeCredentialBuilder tenantId(String string) {
        ValidationUtil.validateTenantIdCharacterRange(string, LOGGER);
        this.tenantId = string;
        return this;
    }

    public VisualStudioCodeCredentialBuilder additionallyAllowedTenants(String ... stringArray) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(Arrays.asList(stringArray)));
        return this;
    }

    public VisualStudioCodeCredentialBuilder additionallyAllowedTenants(List<String> list) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(list));
        return this;
    }

    public VisualStudioCodeCredential build() {
        return new VisualStudioCodeCredential(this.tenantId, this.identityClientOptions);
    }
}

