/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import java.util.concurrent.atomic.AtomicReference;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenRequestContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.AuthenticationRecord;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.AuthenticationRequiredException;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.AzureAuthorityHosts;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.CredentialUnavailableException;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClient;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientBuilder;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentitySyncClient;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.MsalAuthenticationAccount;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.MsalToken;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.LoggingUtil;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class InteractiveBrowserCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(InteractiveBrowserCredential.class);
    private final Integer port;
    private final IdentityClient identityClient;
    private final IdentitySyncClient identitySyncClient;
    private final AtomicReference<MsalAuthenticationAccount> cachedToken;
    private final boolean automaticAuthentication;
    private final String authorityHost;
    private final String redirectUrl;
    private final String loginHint;
    private boolean isCaeEnabledRequestCached;
    private boolean isCaeDisabledRequestCached;
    private boolean isCachePopulated;

    InteractiveBrowserCredential(String string, String string2, Integer n2, String string3, boolean bl2, String string4, IdentityClientOptions identityClientOptions) {
        this.port = n2;
        this.redirectUrl = string3;
        IdentityClientBuilder identityClientBuilder = new IdentityClientBuilder().tenantId(string2).clientId(string).identityClientOptions(identityClientOptions);
        this.identityClient = identityClientBuilder.build();
        this.identitySyncClient = identityClientBuilder.buildSyncClient();
        this.cachedToken = new AtomicReference();
        this.authorityHost = identityClientOptions.getAuthorityHost();
        this.automaticAuthentication = bl2;
        this.loginHint = string4;
        if (identityClientOptions.getAuthenticationRecord() != null) {
            this.cachedToken.set(new MsalAuthenticationAccount(identityClientOptions.getAuthenticationRecord()));
        }
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext tokenRequestContext) {
        return Mono.defer(() -> {
            this.isCachePopulated = this.isCachePopulated(tokenRequestContext);
            if (this.isCachePopulated) {
                return this.identityClient.authenticateWithPublicClientCache(tokenRequestContext, this.cachedToken.get()).onErrorResume(throwable -> Mono.empty());
            }
            return Mono.empty();
        }).switchIfEmpty(Mono.defer(() -> {
            if (!this.automaticAuthentication) {
                return Mono.error((Throwable)LOGGER.logExceptionAsError(new AuthenticationRequiredException("Interactive authentication is needed to acquire token. Call Authenticate to initiate the device code authentication.", tokenRequestContext)));
            }
            return this.identityClient.authenticateWithBrowserInteraction(tokenRequestContext, this.port, this.redirectUrl, this.loginHint);
        })).map(msalToken -> {
            AccessToken accessToken = this.updateCache((MsalToken)msalToken);
            if (tokenRequestContext.isCaeEnabled()) {
                this.isCaeEnabledRequestCached = true;
            } else {
                this.isCaeDisabledRequestCached = true;
            }
            return accessToken;
        }).doOnNext(accessToken -> LoggingUtil.logTokenSuccess(LOGGER, tokenRequestContext)).doOnError(throwable -> LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), tokenRequestContext, throwable));
    }

    @Override
    public AccessToken getTokenSync(TokenRequestContext tokenRequestContext) {
        MsalToken msalToken;
        if (this.cachedToken.get() != null) {
            try {
                msalToken = this.identitySyncClient.authenticateWithPublicClientCache(tokenRequestContext, this.cachedToken.get());
                if (msalToken != null) {
                    LoggingUtil.logTokenSuccess(LOGGER, tokenRequestContext);
                    return msalToken;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (!this.automaticAuthentication) {
                throw LOGGER.logExceptionAsError(new AuthenticationRequiredException("Interactive authentication is needed to acquire token. Call Authenticate to initiate the device code authentication.", tokenRequestContext));
            }
            msalToken = this.identitySyncClient.authenticateWithBrowserInteraction(tokenRequestContext, this.port, this.redirectUrl, this.loginHint);
            this.updateCache(msalToken);
            LoggingUtil.logTokenSuccess(LOGGER, tokenRequestContext);
            return msalToken;
        }
        catch (Exception exception) {
            LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), tokenRequestContext, exception);
            throw exception;
        }
    }

    public Mono<AuthenticationRecord> authenticate(TokenRequestContext tokenRequestContext) {
        return Mono.defer(() -> this.identityClient.authenticateWithBrowserInteraction(tokenRequestContext, this.port, this.redirectUrl, this.loginHint)).map(this::updateCache).map(accessToken -> this.cachedToken.get().getAuthenticationRecord());
    }

    public Mono<AuthenticationRecord> authenticate() {
        String string = AzureAuthorityHosts.getDefaultScope(this.authorityHost);
        if (string == null) {
            return Mono.error((Throwable)LoggingUtil.logCredentialUnavailableException(LOGGER, this.identityClient.getIdentityClientOptions(), new CredentialUnavailableException("Authenticating in this environment requires specifying a TokenRequestContext.")));
        }
        return this.authenticate(new TokenRequestContext().addScopes(string));
    }

    private AccessToken updateCache(MsalToken msalToken) {
        this.cachedToken.set(new MsalAuthenticationAccount(new AuthenticationRecord(msalToken.getAuthenticationResult(), this.identityClient.getTenantId(), this.identityClient.getClientId()), msalToken.getAccount().getTenantProfiles()));
        return msalToken;
    }

    private boolean isCachePopulated(TokenRequestContext tokenRequestContext) {
        return this.cachedToken.get() != null && (tokenRequestContext.isCaeEnabled() && this.isCaeEnabledRequestCached || !tokenRequestContext.isCaeEnabled() && this.isCaeDisabledRequestCached);
    }
}

