/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import java.util.Arrays;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.CredentialBuilderBase;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.IntelliJCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.VisualStudioCodeCredentialBuilder;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.IdentityUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.ValidationUtil;

public class IntelliJCredentialBuilder
extends CredentialBuilderBase<VisualStudioCodeCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(IntelliJCredentialBuilder.class);
    private String tenantId;

    public IntelliJCredentialBuilder tenantId(String string) {
        ValidationUtil.validateTenantIdCharacterRange(string, LOGGER);
        this.tenantId = string;
        return this;
    }

    public IntelliJCredentialBuilder keePassDatabasePath(String string) {
        if (CoreUtils.isNullOrEmpty(string)) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("The KeePass database path is either empty or not configured. Please configure it on the builder."));
        }
        this.identityClientOptions.setIntelliJKeePassDatabasePath(string);
        return this;
    }

    public IntelliJCredentialBuilder additionallyAllowedTenants(String ... stringArray) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(Arrays.asList(stringArray)));
        return this;
    }

    public IntelliJCredentialBuilder additionallyAllowedTenants(List<String> list) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(list));
        return this;
    }

    public IntelliJCredential build() {
        return new IntelliJCredential(this.tenantId, this.identityClientOptions);
    }
}

