/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.AadCredentialBuilderBase;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.AuthenticationRecord;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.DeviceCodeCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.DeviceCodeInfo;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.TokenCachePersistenceOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.IdentityUtil;

public class DeviceCodeCredentialBuilder
extends AadCredentialBuilderBase<DeviceCodeCredentialBuilder> {
    private Consumer<DeviceCodeInfo> challengeConsumer = deviceCodeInfo -> System.out.println(deviceCodeInfo.getMessage());
    private boolean automaticAuthentication = true;

    public DeviceCodeCredentialBuilder challengeConsumer(Consumer<DeviceCodeInfo> consumer) {
        this.challengeConsumer = consumer;
        return this;
    }

    public DeviceCodeCredentialBuilder tokenCachePersistenceOptions(TokenCachePersistenceOptions tokenCachePersistenceOptions) {
        this.identityClientOptions.setTokenCacheOptions(tokenCachePersistenceOptions);
        return this;
    }

    public DeviceCodeCredentialBuilder authenticationRecord(AuthenticationRecord authenticationRecord) {
        this.identityClientOptions.setAuthenticationRecord(authenticationRecord);
        return this;
    }

    public DeviceCodeCredentialBuilder disableAutomaticAuthentication() {
        this.automaticAuthentication = false;
        return this;
    }

    @Override
    public DeviceCodeCredentialBuilder additionallyAllowedTenants(String ... stringArray) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(Arrays.asList(stringArray)));
        return this;
    }

    @Override
    public DeviceCodeCredentialBuilder additionallyAllowedTenants(List<String> list) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(list));
        return this;
    }

    public DeviceCodeCredential build() {
        String string = this.clientId != null ? this.clientId : "04b07795-8ddb-461a-bbee-02f9e1bf7b46";
        return new DeviceCodeCredential(string, this.tenantId, this.challengeConsumer, this.automaticAuthentication, this.identityClientOptions);
    }
}

