/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenRequestContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClient;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientBuilder;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentitySyncClient;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.LoggingUtil;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class ClientCertificateCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(ClientCertificateCredential.class);
    private final IdentityClient identityClient;
    private final IdentitySyncClient identitySyncClient;

    ClientCertificateCredential(String string, String string2, String string3, byte[] byArray, String string4, IdentityClientOptions identityClientOptions) {
        Objects.requireNonNull(string3 == null ? byArray : (byte[])string3, "'certificate' and 'certificatePath' cannot both be null.");
        IdentityClientBuilder identityClientBuilder = new IdentityClientBuilder().tenantId(string).clientId(string2).certificatePath(string3).certificate(byArray).certificatePassword(string4).identityClientOptions(identityClientOptions);
        this.identityClient = identityClientBuilder.build();
        this.identitySyncClient = identityClientBuilder.buildSyncClient();
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext tokenRequestContext) {
        return this.identityClient.authenticateWithConfidentialClientCache(tokenRequestContext).onErrorResume(throwable -> Mono.empty()).switchIfEmpty(Mono.defer(() -> this.identityClient.authenticateWithConfidentialClient(tokenRequestContext))).doOnNext(accessToken -> LoggingUtil.logTokenSuccess(LOGGER, tokenRequestContext)).doOnError(throwable -> LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), tokenRequestContext, throwable));
    }

    @Override
    public AccessToken getTokenSync(TokenRequestContext tokenRequestContext) {
        AccessToken accessToken;
        try {
            accessToken = this.identitySyncClient.authenticateWithConfidentialClientCache(tokenRequestContext);
            if (accessToken != null) {
                LoggingUtil.logTokenSuccess(LOGGER, tokenRequestContext);
                return accessToken;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            accessToken = this.identitySyncClient.authenticateWithConfidentialClient(tokenRequestContext);
            LoggingUtil.logTokenSuccess(LOGGER, tokenRequestContext);
            return accessToken;
        }
        catch (Exception exception) {
            LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), tokenRequestContext, exception);
            throw exception;
        }
    }
}

