/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.AzureApplicationCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.CredentialBuilderBase;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.EnvironmentCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.ManagedIdentityCredential;

class AzureApplicationCredentialBuilder
extends CredentialBuilderBase<AzureApplicationCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(AzureApplicationCredentialBuilder.class);
    private String managedIdentityClientId;
    private String managedIdentityResourceId;

    AzureApplicationCredentialBuilder() {
        Configuration configuration = Configuration.getGlobalConfiguration().clone();
        this.managedIdentityClientId = configuration.get("AZURE_CLIENT_ID");
    }

    public AzureApplicationCredentialBuilder authorityHost(String string) {
        this.identityClientOptions.setAuthorityHost(string);
        return this;
    }

    public AzureApplicationCredentialBuilder managedIdentityClientId(String string) {
        this.managedIdentityClientId = string;
        return this;
    }

    public AzureApplicationCredentialBuilder managedIdentityResourceId(String string) {
        this.managedIdentityResourceId = string;
        return this;
    }

    public AzureApplicationCredentialBuilder executorService(ExecutorService executorService) {
        this.identityClientOptions.setExecutorService(executorService);
        return this;
    }

    public AzureApplicationCredential build() {
        if (this.managedIdentityClientId != null && this.managedIdentityResourceId != null) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("Only one of managedIdentityClientId and managedIdentityResourceId can be specified."));
        }
        return new AzureApplicationCredential(this.getCredentialsChain());
    }

    private ArrayList<TokenCredential> getCredentialsChain() {
        ArrayList<TokenCredential> arrayList = new ArrayList<TokenCredential>(2);
        arrayList.add(new EnvironmentCredential(this.identityClientOptions));
        arrayList.add(new ManagedIdentityCredential(this.managedIdentityClientId, this.managedIdentityResourceId, this.identityClientOptions));
        return arrayList;
    }
}

