/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenRequestContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.ManagedIdentityServiceCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClient;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

class AppServiceMsiCredential
extends ManagedIdentityServiceCredential {
    private static final ClientLogger LOGGER = new ClientLogger(AppServiceMsiCredential.class);
    private final String identityEndpoint;
    private final String identityHeader;
    private final String msiEndpoint;
    private final String msiSecret;

    AppServiceMsiCredential(String string, IdentityClient identityClient) {
        super(string, identityClient, "AZURE APP SERVICE MSI/IDENTITY ENDPOINT");
        Configuration configuration = Configuration.getGlobalConfiguration().clone();
        this.identityEndpoint = configuration.get("IDENTITY_ENDPOINT");
        this.identityHeader = configuration.get("IDENTITY_HEADER");
        this.msiEndpoint = configuration.get("MSI_ENDPOINT");
        this.msiSecret = configuration.get("MSI_SECRET");
        if (this.identityEndpoint != null) {
            this.validateEndpointProtocol(this.identityEndpoint, "MSI", LOGGER);
        }
        if (this.msiEndpoint != null) {
            this.validateEndpointProtocol(this.msiEndpoint, "MSI", LOGGER);
        }
    }

    @Override
    public Mono<AccessToken> authenticate(TokenRequestContext tokenRequestContext) {
        return this.identityClient.authenticateWithManagedIdentityConfidentialClient(tokenRequestContext);
    }
}

