/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer;

import com.azure.xml.XmlSerializable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaders;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.AccessibleByteArrayOutputStream;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ImplUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectionSerializable;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.TypeUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.ObjectMapperShim;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.DateTimeRfc1123;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ExpandableStringEnum;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Header;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.CollectionFormat;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.SerializerAdapter;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.SerializerEncoding;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonSerializable;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ObjectMapper;

public class JacksonAdapter
implements SerializerAdapter {
    private static final ClientLogger LOGGER = new ClientLogger(JacksonAdapter.class);
    private static boolean useAccessHelper = Boolean.parseBoolean(Configuration.getGlobalConfiguration().get("AZURE_JACKSON_ADAPTER_USE_ACCESS_HELPER"));
    private final ObjectMapperShim mapper;
    private final ObjectMapperShim headerMapper;
    private ObjectMapper rawOuterMapper;
    private ObjectMapper rawInnerMapper;

    public JacksonAdapter() {
        this((objectMapper, objectMapper2) -> {});
    }

    @Deprecated
    public JacksonAdapter(BiConsumer<ObjectMapper, ObjectMapper> biConsumer) {
        Objects.requireNonNull(biConsumer, "'configureSerialization' cannot be null.");
        this.headerMapper = ObjectMapperShim.createHeaderMapper();
        this.mapper = ObjectMapperShim.createJsonMapper(ObjectMapperShim.createSimpleMapper(), (objectMapper, objectMapper2) -> this.captureRawMappersAndConfigure((ObjectMapper)objectMapper, (ObjectMapper)objectMapper2, biConsumer));
    }

    private void captureRawMappersAndConfigure(ObjectMapper objectMapper, ObjectMapper objectMapper2, BiConsumer<ObjectMapper, ObjectMapper> biConsumer) {
        this.rawOuterMapper = objectMapper;
        this.rawInnerMapper = objectMapper2;
        biConsumer.accept(objectMapper, objectMapper2);
    }

    @Deprecated
    protected ObjectMapper simpleMapper() {
        return this.rawInnerMapper;
    }

    public static SerializerAdapter createDefaultSerializerAdapter() {
        return GlobalSerializerAdapter.SERIALIZER_ADAPTER.getSerializerAdapter();
    }

    @Deprecated
    public ObjectMapper serializer() {
        return this.rawOuterMapper;
    }

    @Override
    public String serialize(Object object, SerializerEncoding serializerEncoding) throws IOException {
        if (object == null) {
            return null;
        }
        return (String)JacksonAdapter.useAccessHelper(() -> {
            if (serializerEncoding == SerializerEncoding.XML) {
                return ReflectionSerializable.supportsXmlSerializable(object.getClass()) ? ReflectionSerializable.serializeXmlSerializableToString((XmlSerializable)object) : this.getXmlMapper().writeValueAsString(object);
            }
            if (serializerEncoding == SerializerEncoding.TEXT) {
                return object.toString();
            }
            return ReflectionSerializable.supportsJsonSerializable(object.getClass()) ? ReflectionSerializable.serializeJsonSerializableToString((JsonSerializable)object) : this.mapper.writeValueAsString(object);
        });
    }

    @Override
    public byte[] serializeToBytes(Object object, SerializerEncoding serializerEncoding) throws IOException {
        if (object == null) {
            return null;
        }
        return (byte[])JacksonAdapter.useAccessHelper(() -> {
            if (serializerEncoding == SerializerEncoding.XML) {
                return ReflectionSerializable.supportsXmlSerializable(object.getClass()) ? ReflectionSerializable.serializeXmlSerializableToBytes((XmlSerializable)object) : this.getXmlMapper().writeValueAsBytes(object);
            }
            if (serializerEncoding == SerializerEncoding.TEXT) {
                return object.toString().getBytes(StandardCharsets.UTF_8);
            }
            return ReflectionSerializable.supportsJsonSerializable(object.getClass()) ? ReflectionSerializable.serializeJsonSerializableToBytes((JsonSerializable)object) : this.mapper.writeValueAsBytes(object);
        });
    }

    @Override
    public void serialize(Object object, SerializerEncoding serializerEncoding, OutputStream outputStream) throws IOException {
        if (object == null) {
            return;
        }
        JacksonAdapter.useAccessHelper(() -> {
            if (serializerEncoding == SerializerEncoding.XML) {
                if (ReflectionSerializable.supportsXmlSerializable(object.getClass())) {
                    ReflectionSerializable.serializeXmlSerializableIntoOutputStream((XmlSerializable)object, outputStream);
                } else {
                    this.getXmlMapper().writeValue(outputStream, object);
                }
            } else if (serializerEncoding == SerializerEncoding.TEXT) {
                outputStream.write(object.toString().getBytes(StandardCharsets.UTF_8));
            } else if (ReflectionSerializable.supportsJsonSerializable(object.getClass())) {
                ReflectionSerializable.serializeJsonSerializableIntoOutputStream((JsonSerializable)object, outputStream);
            } else {
                this.mapper.writeValue(outputStream, object);
            }
            return null;
        });
    }

    @Override
    public String serializeRaw(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return (String)JacksonAdapter.useAccessHelper(() -> {
                try {
                    return JacksonAdapter.removeLeadingAndTrailingQuotes(this.serialize(object, SerializerEncoding.JSON));
                }
                catch (IOException iOException) {
                    LOGGER.log(LogLevel.WARNING, () -> "Failed to serialize " + object.getClass() + " to JSON.", iOException);
                    return null;
                }
            });
        }
        catch (IOException iOException) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(iOException));
        }
    }

    static String removeLeadingAndTrailingQuotes(String string) {
        int n2;
        int n3;
        int n4 = string.length();
        for (n3 = 0; n3 < n4 && string.charAt(n3) == '\"'; ++n3) {
        }
        if (n3 == n4) {
            return "";
        }
        for (n2 = n4 - 1; n2 >= 0 && string.charAt(n2) == '\"'; --n2) {
        }
        return string.substring(n3, n2 + 1);
    }

    @Override
    public String serializeList(List<?> list, CollectionFormat collectionFormat) {
        try {
            return (String)JacksonAdapter.useAccessHelper(() -> this.serializeIterable(list, collectionFormat));
        }
        catch (IOException iOException) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(iOException));
        }
    }

    @Override
    public <T> T deserialize(String string, Type type, SerializerEncoding serializerEncoding) throws IOException {
        if (CoreUtils.isNullOrEmpty(string)) {
            return null;
        }
        return (T)JacksonAdapter.useAccessHelper(() -> {
            if (serializerEncoding == SerializerEncoding.XML) {
                Class<?> clazz = TypeUtil.getRawClass(type);
                return ReflectionSerializable.supportsXmlSerializable(clazz) ? ReflectionSerializable.deserializeAsXmlSerializable(clazz, string.getBytes(StandardCharsets.UTF_8)) : this.getXmlMapper().readValue(string, type);
            }
            if (serializerEncoding == SerializerEncoding.TEXT) {
                return JacksonAdapter.deserializeText(string, type);
            }
            Class<?> clazz = TypeUtil.getRawClass(type);
            return ReflectionSerializable.supportsJsonSerializable(clazz) ? ReflectionSerializable.deserializeAsJsonSerializable(clazz, string.getBytes(StandardCharsets.UTF_8)) : this.mapper.readValue(string, type);
        });
    }

    @Override
    public <T> T deserialize(byte[] byArray, Type type, SerializerEncoding serializerEncoding) throws IOException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        return (T)JacksonAdapter.useAccessHelper(() -> {
            if (serializerEncoding == SerializerEncoding.XML) {
                Class<?> clazz = TypeUtil.getRawClass(type);
                return ReflectionSerializable.supportsXmlSerializable(clazz) ? ReflectionSerializable.deserializeAsXmlSerializable(clazz, byArray) : this.getXmlMapper().readValue(byArray, type);
            }
            if (serializerEncoding == SerializerEncoding.TEXT) {
                return JacksonAdapter.deserializeText(CoreUtils.bomAwareToString(byArray, null), type);
            }
            Class<?> clazz = TypeUtil.getRawClass(type);
            return ReflectionSerializable.supportsJsonSerializable(clazz) ? ReflectionSerializable.deserializeAsJsonSerializable(clazz, byArray) : this.mapper.readValue(byArray, type);
        });
    }

    @Override
    public <T> T deserialize(InputStream inputStream, Type type, SerializerEncoding serializerEncoding) throws IOException {
        if (inputStream == null) {
            return null;
        }
        return (T)JacksonAdapter.useAccessHelper(() -> {
            if (serializerEncoding == SerializerEncoding.XML) {
                Class<?> clazz = TypeUtil.getRawClass(type);
                return ReflectionSerializable.supportsXmlSerializable(clazz) ? ReflectionSerializable.deserializeAsXmlSerializable(clazz, JacksonAdapter.inputStreamToBytes(inputStream)) : this.getXmlMapper().readValue(inputStream, type);
            }
            if (serializerEncoding == SerializerEncoding.TEXT) {
                int n2;
                AccessibleByteArrayOutputStream accessibleByteArrayOutputStream = new AccessibleByteArrayOutputStream();
                byte[] byArray = new byte[8192];
                while ((n2 = inputStream.read(byArray)) != -1) {
                    accessibleByteArrayOutputStream.write(byArray, 0, n2);
                }
                return JacksonAdapter.deserializeText(accessibleByteArrayOutputStream.bomAwareToString(null), type);
            }
            Class<?> clazz = TypeUtil.getRawClass(type);
            return ReflectionSerializable.supportsJsonSerializable(clazz) ? ReflectionSerializable.deserializeAsJsonSerializable(clazz, JacksonAdapter.inputStreamToBytes(inputStream)) : this.mapper.readValue(inputStream, type);
        });
    }

    private static byte[] inputStreamToBytes(InputStream inputStream) throws IOException {
        int n2;
        AccessibleByteArrayOutputStream accessibleByteArrayOutputStream = new AccessibleByteArrayOutputStream();
        byte[] byArray = new byte[8192];
        while ((n2 = inputStream.read(byArray)) != -1) {
            accessibleByteArrayOutputStream.write(byArray, 0, n2);
        }
        return accessibleByteArrayOutputStream.toByteArray();
    }

    private static Object deserializeText(String string, Type type) throws IOException {
        if (type == String.class || type == CharSequence.class) {
            return string;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return Integer.parseInt(string);
        }
        if (type == Character.TYPE || type == Character.class) {
            return CoreUtils.isNullOrEmpty(string) ? null : Character.valueOf(string.charAt(0));
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return CoreUtils.isNullOrEmpty(string) ? null : Byte.valueOf((byte)string.charAt(0));
        }
        if (type == byte[].class) {
            return CoreUtils.isNullOrEmpty(string) ? null : string.getBytes(StandardCharsets.UTF_8);
        }
        if (type == Long.TYPE || type == Long.class) {
            return Long.parseLong(string);
        }
        if (type == Short.TYPE || type == Short.class) {
            return Short.parseShort(string);
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(Float.parseFloat(string));
        }
        if (type == Double.TYPE || type == Double.class) {
            return Double.parseDouble(string);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Boolean.parseBoolean(string);
        }
        if (type == OffsetDateTime.class) {
            return OffsetDateTime.parse(string);
        }
        if (type == DateTimeRfc1123.class) {
            return new DateTimeRfc1123(string);
        }
        if (type == URL.class) {
            try {
                return ImplUtils.createUrl(string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IOException(malformedURLException);
            }
        }
        if (type == URI.class) {
            return URI.create(string);
        }
        if (type == UUID.class) {
            return UUID.fromString(string);
        }
        if (type == LocalDate.class) {
            return LocalDate.parse(string);
        }
        if (Enum.class.isAssignableFrom((Class)type)) {
            return Enum.valueOf((Class)type, string);
        }
        if (ExpandableStringEnum.class.isAssignableFrom((Class)type)) {
            try {
                return ((Class)type).getDeclaredMethod("fromString", String.class).invoke(null, string);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new IOException(reflectiveOperationException);
            }
        }
        throw new IllegalStateException("Unsupported text Content-Type Type: " + type);
    }

    @Override
    public <T> T deserialize(HttpHeaders httpHeaders, Type type) throws IOException {
        return (T)JacksonAdapter.useAccessHelper(() -> this.headerMapper.deserialize(httpHeaders, type));
    }

    @Override
    public <T> T deserializeHeader(Header header, Type type) throws IOException {
        return (T)JacksonAdapter.useAccessHelper(() -> this.headerMapper.readValue(header.getValue(), type));
    }

    private ObjectMapperShim getXmlMapper() {
        return GlobalXmlMapper.XML_MAPPER.getXmlMapper();
    }

    private static Object useAccessHelper(IOExceptionCallable iOExceptionCallable) throws IOException {
        if (useAccessHelper) {
            try {
                return AccessController.doPrivileged(iOExceptionCallable::call);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw LOGGER.logExceptionAsError(new RuntimeException(throwable));
            }
        }
        return iOExceptionCallable.call();
    }

    static boolean isUseAccessHelper() {
        return useAccessHelper;
    }

    static void setUseAccessHelper(boolean bl2) {
        useAccessHelper = bl2;
    }

    private static enum GlobalSerializerAdapter {
        SERIALIZER_ADAPTER(new JacksonAdapter());

        private final SerializerAdapter serializerAdapter;

        private GlobalSerializerAdapter(SerializerAdapter serializerAdapter) {
            this.serializerAdapter = serializerAdapter;
        }

        private SerializerAdapter getSerializerAdapter() {
            return this.serializerAdapter;
        }
    }

    @FunctionalInterface
    private static interface IOExceptionCallable {
        public Object call() throws IOException;
    }

    private static enum GlobalXmlMapper {
        XML_MAPPER(ObjectMapperShim.createXmlMapper());

        private final ObjectMapperShim xmlMapper;

        private GlobalXmlMapper(ObjectMapperShim objectMapperShim) {
            this.xmlMapper = objectMapperShim;
        }

        private ObjectMapperShim getXmlMapper() {
            return this.xmlMapper;
        }
    }
}

