/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.LongRunningOperationStatus;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollingContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollingUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.SyncPoller;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.implementation.PollContextRequiredException;
import macromedia.jdbc.sqlserver.externals.org.reactivestreams.Publisher;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

final class SyncOverAsyncPoller<T, U>
implements SyncPoller<T, U> {
    private static final ClientLogger LOGGER = new ClientLogger(SyncOverAsyncPoller.class);
    private final Function<PollingContext<T>, Mono<PollResponse<T>>> pollOperation;
    private final BiFunction<PollingContext<T>, PollResponse<T>, Mono<T>> cancelOperation;
    private final Function<PollingContext<T>, Mono<U>> fetchResultOperation;
    private final PollResponse<T> activationResponse;
    private final PollingContext<T> pollingContext = new PollingContext();
    private volatile PollingContext<T> terminalPollContext;
    private volatile Duration pollInterval;

    SyncOverAsyncPoller(Duration duration, Function<PollingContext<T>, PollResponse<T>> function, Function<PollingContext<T>, Mono<PollResponse<T>>> function2, BiFunction<PollingContext<T>, PollResponse<T>, Mono<T>> biFunction, Function<PollingContext<T>, Mono<U>> function3) {
        Objects.requireNonNull(duration, "'pollInterval' cannot be null.");
        if (duration.isNegative() || duration.isZero()) {
            throw LOGGER.logExceptionAsWarning(new IllegalArgumentException("Negative or zero value for 'defaultPollInterval' is not allowed."));
        }
        this.pollInterval = duration;
        Objects.requireNonNull(function, "'syncActivationOperation' cannot be null.");
        this.pollOperation = Objects.requireNonNull(function2, "'pollOperation' cannot be null.");
        this.cancelOperation = Objects.requireNonNull(biFunction, "'cancelOperation' cannot be null.");
        this.fetchResultOperation = Objects.requireNonNull(function3, "'fetchResultOperation' cannot be null.");
        this.activationResponse = function.apply(this.pollingContext);
        this.pollingContext.setOnetimeActivationResponse(this.activationResponse);
        this.pollingContext.setLatestResponse(this.activationResponse);
        if (this.activationResponse.getStatus().isComplete()) {
            this.terminalPollContext = this.pollingContext;
        }
    }

    @Override
    public PollResponse<T> poll() {
        return (PollResponse)this.pollOperation.apply(this.pollingContext).map(pollResponse -> {
            this.pollingContext.setLatestResponse((PollResponse<T>)pollResponse);
            if (pollResponse.getStatus().isComplete()) {
                this.terminalPollContext = this.pollingContext.copy();
            }
            return pollResponse;
        }).block();
    }

    @Override
    public PollResponse<T> waitForCompletion() {
        PollingContext<T> pollingContext = this.terminalPollContext;
        if (pollingContext != null) {
            return pollingContext.getLatestResponse();
        }
        PollingContext<T> pollingContext2 = this.pollingContext.copy();
        return (PollResponse)PollingUtil.pollingLoopAsync(pollingContext2, this.pollOperation, this.cancelOperation, this.fetchResultOperation, this.pollInterval).last().map(asyncPollResponse -> {
            this.terminalPollContext = pollingContext2;
            return PollingUtil.toPollResponse(asyncPollResponse);
        }).block();
    }

    @Override
    public PollResponse<T> waitForCompletion(Duration duration) {
        PollingUtil.validateTimeout(duration, LOGGER);
        PollingContext<T> pollingContext = this.terminalPollContext;
        if (pollingContext != null) {
            return pollingContext.getLatestResponse();
        }
        PollingContext<T> pollingContext2 = this.pollingContext.copy();
        return (PollResponse)PollingUtil.pollingLoopAsync(pollingContext2, this.pollOperation, this.cancelOperation, this.fetchResultOperation, this.pollInterval).take(duration).switchIfEmpty((Publisher)Mono.error(() -> new TimeoutException("Polling didn't complete before the timeout period."))).last().flatMap(asyncPollResponse -> {
            if (asyncPollResponse != null && asyncPollResponse.getStatus().isComplete()) {
                this.terminalPollContext = pollingContext2;
                return Mono.just(PollingUtil.toPollResponse(asyncPollResponse));
            }
            return Mono.error((Throwable)new TimeoutException("Polling didn't complete before the timeout period."));
        }).block();
    }

    @Override
    public PollResponse<T> waitUntil(LongRunningOperationStatus longRunningOperationStatus) {
        Objects.requireNonNull(longRunningOperationStatus, "'statusToWaitFor' cannot be null.");
        PollingContext<T> pollingContext = this.terminalPollContext;
        if (pollingContext != null) {
            return pollingContext.getLatestResponse();
        }
        PollingContext<T> pollingContext2 = this.pollingContext.copy();
        return (PollResponse)PollingUtil.pollingLoopAsync(pollingContext2, this.pollOperation, this.cancelOperation, this.fetchResultOperation, this.pollInterval).takeUntil(asyncPollResponse -> PollingUtil.matchStatus(asyncPollResponse, longRunningOperationStatus)).last().map(asyncPollResponse -> {
            if (asyncPollResponse.getStatus().isComplete()) {
                this.terminalPollContext = pollingContext2;
            }
            return PollingUtil.toPollResponse(asyncPollResponse);
        }).block();
    }

    @Override
    public PollResponse<T> waitUntil(Duration duration, LongRunningOperationStatus longRunningOperationStatus) {
        PollingUtil.validateTimeout(duration, LOGGER);
        Objects.requireNonNull(longRunningOperationStatus, "'statusToWaitFor' cannot be null.");
        PollingContext<T> pollingContext = this.terminalPollContext;
        if (pollingContext != null) {
            return pollingContext.getLatestResponse();
        }
        PollingContext<T> pollingContext2 = this.pollingContext.copy();
        return (PollResponse)PollingUtil.pollingLoopAsync(pollingContext2, this.pollOperation, this.cancelOperation, this.fetchResultOperation, this.pollInterval).take(duration).takeUntil(asyncPollResponse -> PollingUtil.matchStatus(asyncPollResponse, longRunningOperationStatus)).takeLast(1).flatMap(asyncPollResponse -> {
            if (asyncPollResponse.getStatus().isComplete()) {
                this.terminalPollContext = pollingContext2;
            }
            return Mono.just(PollingUtil.toPollResponse(asyncPollResponse));
        }).switchIfEmpty((Publisher)Mono.fromCallable(this.pollingContext::getLatestResponse)).blockLast();
    }

    @Override
    public U getFinalResult() {
        PollingContext<T> pollingContext = this.terminalPollContext;
        if (pollingContext != null) {
            return (U)this.fetchResultOperation.apply(pollingContext).block();
        }
        PollingContext<T> pollingContext2 = this.pollingContext.copy();
        return (U)PollingUtil.pollingLoopAsync(pollingContext2, this.pollOperation, this.cancelOperation, this.fetchResultOperation, this.pollInterval).last().flatMap(asyncPollResponse -> {
            this.terminalPollContext = pollingContext2;
            return asyncPollResponse.getFinalResult();
        }).block();
    }

    @Override
    public U getFinalResult(Duration duration) {
        PollingContext<T> pollingContext = this.terminalPollContext;
        if (pollingContext != null) {
            return (U)this.fetchResultOperation.apply(pollingContext).block();
        }
        PollingContext<T> pollingContext2 = this.pollingContext.copy();
        return (U)PollingUtil.pollingLoopAsync(pollingContext2, this.pollOperation, this.cancelOperation, this.fetchResultOperation, this.pollInterval).take(duration).switchIfEmpty((Publisher)Mono.error(() -> new TimeoutException("Polling didn't complete before the timeout period."))).last().flatMap(asyncPollResponse -> {
            if (asyncPollResponse != null && asyncPollResponse.getStatus().isComplete()) {
                this.terminalPollContext = pollingContext2;
                return asyncPollResponse.getFinalResult();
            }
            return Mono.error((Throwable)new TimeoutException("Polling didn't complete before the timeout period."));
        }).block();
    }

    @Override
    public void cancelOperation() {
        PollingContext<T> pollingContext = this.pollingContext.copy();
        if (pollingContext.getActivationResponse() == pollingContext.getLatestResponse()) {
            this.cancelOperation.apply(pollingContext, pollingContext.getActivationResponse()).block();
        } else {
            this.cancelOperation.apply(null, this.activationResponse).onErrorResume(PollContextRequiredException.class, pollContextRequiredException -> {
                PollingContext<T> pollingContext = this.pollingContext.copy();
                return PollingUtil.pollingLoopAsync(pollingContext, this.pollOperation, this.cancelOperation, this.fetchResultOperation, this.pollInterval).next().then(this.cancelOperation.apply(pollingContext, this.activationResponse));
            }).block();
        }
    }

    @Override
    public SyncPoller<T, U> setPollInterval(Duration duration) {
        this.pollInterval = PollingUtil.validatePollInterval(duration, LOGGER);
        return this;
    }
}

