/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging.ContinuablePage;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging.ContinuationState;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging.PageRetriever;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging.PageRetrieverSync;

abstract class ContinuablePagedByIteratorBase<C, T, P extends ContinuablePage<C, T>, E>
implements Iterator<E> {
    private final PageRetriever<C, P> pageRetriever;
    private final PageRetrieverSync<C, P> pageRetrieverSync;
    private final ContinuationState<C> continuationState;
    private final Integer defaultPageSize;
    private final ClientLogger logger;
    private volatile boolean done;

    ContinuablePagedByIteratorBase(PageRetriever<C, P> pageRetriever, ContinuationState<C> continuationState, Integer n2, ClientLogger clientLogger) {
        this.continuationState = continuationState;
        this.pageRetriever = pageRetriever;
        this.defaultPageSize = n2;
        this.logger = clientLogger;
        this.pageRetrieverSync = null;
    }

    ContinuablePagedByIteratorBase(PageRetrieverSync<C, P> pageRetrieverSync, ContinuationState<C> continuationState, Integer n2, ClientLogger clientLogger) {
        this.continuationState = continuationState;
        this.pageRetrieverSync = pageRetrieverSync;
        this.defaultPageSize = n2;
        this.logger = clientLogger;
        this.pageRetriever = null;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw this.logger.logExceptionAsError(new NoSuchElementException("Iterator contains no more elements."));
        }
        return this.getNext();
    }

    @Override
    public boolean hasNext() {
        while (!this.done && this.needToRequestPage()) {
            this.requestPage();
        }
        return this.isNextAvailable();
    }

    abstract boolean needToRequestPage();

    abstract boolean isNextAvailable();

    abstract E getNext();

    synchronized void requestPage() {
        ContinuablePage continuablePage2;
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        if (this.pageRetriever != null) {
            if (this.isNextAvailable() || this.done) {
                return;
            }
            this.pageRetriever.get(this.continuationState.getLastContinuationToken(), this.defaultPageSize).map(continuablePage -> {
                this.receivePage(atomicBoolean, continuablePage);
                return continuablePage;
            }).blockLast();
        } else if (this.pageRetrieverSync != null && (continuablePage2 = (ContinuablePage)this.pageRetrieverSync.getPage(this.continuationState.getLastContinuationToken(), this.defaultPageSize)) != null) {
            this.receivePage(atomicBoolean, continuablePage2);
        }
        this.done = this.done || !atomicBoolean.get() && !this.isNextAvailable();
    }

    abstract void addPage(P var1);

    private void receivePage(AtomicBoolean atomicBoolean, P p2) {
        atomicBoolean.set(true);
        this.addPage(p2);
        this.continuationState.setLastContinuationToken(p2.getContinuationToken());
        this.done = this.continuationState.isDone();
    }
}

