/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.logging.LoggingUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.JsonStringEncoder;
import macromedia.jdbc.sqlserver.externals.org.slf4j.Logger;
import macromedia.jdbc.sqlserver.externals.org.slf4j.helpers.FormattingTuple;
import macromedia.jdbc.sqlserver.externals.org.slf4j.helpers.MessageFormatter;

public final class LoggingEventBuilder {
    private static final JsonStringEncoder JSON_STRING_ENCODER = JsonStringEncoder.getInstance();
    private static final LoggingEventBuilder NOOP = new LoggingEventBuilder(null, null, null, false);
    private static final String AZURE_SDK_LOG_MESSAGE_JSON_START = "{\"az.sdk.message\":\"";
    private final Logger logger;
    private final LogLevel level;
    private List<ContextKeyValuePair> context;
    private final String globalContextCached;
    private final boolean hasGlobalContext;
    private final boolean isEnabled;

    static LoggingEventBuilder create(Logger logger, LogLevel logLevel, String string, boolean bl2) {
        if (bl2) {
            return new LoggingEventBuilder(logger, logLevel, string, true);
        }
        return NOOP;
    }

    private LoggingEventBuilder(Logger logger, LogLevel logLevel, String string, boolean bl2) {
        this.logger = logger;
        this.level = logLevel;
        this.isEnabled = bl2;
        this.globalContextCached = string == null ? "" : string;
        this.hasGlobalContext = !this.globalContextCached.isEmpty();
    }

    public LoggingEventBuilder addKeyValue(String string, String string2) {
        if (this.isEnabled) {
            this.addKeyValueInternal(string, string2);
        }
        return this;
    }

    public LoggingEventBuilder addKeyValue(String string, Object object) {
        if (this.isEnabled) {
            this.addKeyValueInternal(string, object);
        }
        return this;
    }

    public LoggingEventBuilder addKeyValue(String string, boolean bl2) {
        if (this.isEnabled) {
            this.addKeyValueInternal(string, bl2);
        }
        return this;
    }

    public LoggingEventBuilder addKeyValue(String string, long l2) {
        if (this.isEnabled) {
            this.addKeyValueInternal(string, l2);
        }
        return this;
    }

    public LoggingEventBuilder addKeyValue(String string, Supplier<String> supplier) {
        if (this.isEnabled) {
            if (this.context == null) {
                this.context = new ArrayList<ContextKeyValuePair>();
            }
            this.context.add(new ContextKeyValuePair(string, supplier));
        }
        return this;
    }

    public void log(String string) {
        if (this.isEnabled) {
            this.performLogging(this.level, this.getMessageWithContext(string, null), null);
        }
    }

    public void log(Supplier<String> supplier) {
        if (this.isEnabled) {
            String string = supplier != null ? supplier.get() : null;
            this.performLogging(this.level, this.getMessageWithContext(string, null), null);
        }
    }

    public void log(Supplier<String> supplier, Throwable throwable) {
        if (this.isEnabled) {
            String string = supplier != null ? supplier.get() : null;
            this.performLogging(this.level, this.getMessageWithContext(string, throwable), this.logger.isDebugEnabled() ? throwable : null);
        }
    }

    public void log(String string, Object ... objectArray) {
        if (this.isEnabled) {
            this.performLogging(this.level, string, objectArray);
        }
    }

    public Throwable log(Throwable throwable) {
        Objects.requireNonNull(throwable, "'throwable' cannot be null.");
        if (this.isEnabled) {
            this.performLogging(this.level, this.getMessageWithContext(null, throwable), this.logger.isDebugEnabled() ? throwable : null);
        }
        return throwable;
    }

    public RuntimeException log(RuntimeException runtimeException) {
        Objects.requireNonNull(runtimeException, "'runtimeException' cannot be null.");
        if (this.isEnabled) {
            this.performLogging(this.level, this.getMessageWithContext(null, runtimeException), this.logger.isDebugEnabled() ? runtimeException : null);
        }
        return runtimeException;
    }

    private String getMessageWithContext(String string, Throwable throwable) {
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder = new StringBuilder(20 + (this.context == null ? 0 : this.context.size()) * 20 + string.length() + this.globalContextCached.length());
        stringBuilder.append(AZURE_SDK_LOG_MESSAGE_JSON_START);
        JSON_STRING_ENCODER.quoteAsString(string, stringBuilder);
        stringBuilder.append('\"');
        if (throwable != null) {
            stringBuilder.append(",\"exception\":");
            String string2 = throwable.getMessage();
            if (string2 != null) {
                stringBuilder.append('\"');
                JSON_STRING_ENCODER.quoteAsString(string2, stringBuilder);
                stringBuilder.append('\"');
            } else {
                stringBuilder.append("null");
            }
        }
        if (this.hasGlobalContext) {
            stringBuilder.append(',').append(this.globalContextCached);
        }
        if (this.context != null) {
            for (ContextKeyValuePair contextKeyValuePair : this.context) {
                contextKeyValuePair.write(stringBuilder.append(','));
            }
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private void addKeyValueInternal(String string, Object object) {
        if (this.context == null) {
            this.context = new ArrayList<ContextKeyValuePair>();
        }
        this.context.add(new ContextKeyValuePair(string, object));
    }

    private void performLogging(LogLevel logLevel, String string, Object ... objectArray) {
        Object object;
        Throwable throwable = null;
        if (LoggingUtils.doesArgsHaveThrowable(objectArray)) {
            object = objectArray[objectArray.length - 1];
            if (object instanceof Throwable) {
                throwable = (Throwable)object;
            }
            if (!this.logger.isDebugEnabled()) {
                objectArray = LoggingUtils.removeThrowable(objectArray);
            }
        }
        object = MessageFormatter.arrayFormat(string, objectArray);
        String string2 = this.getMessageWithContext(((FormattingTuple)object).getMessage(), throwable);
        this.performLogging(logLevel, string2, ((FormattingTuple)object).getThrowable());
    }

    private void performLogging(LogLevel logLevel, String string, Throwable throwable) {
        switch (logLevel) {
            case VERBOSE: {
                this.logger.debug(string, throwable);
                break;
            }
            case INFORMATIONAL: {
                this.logger.info(string, throwable);
                break;
            }
            case WARNING: {
                this.logger.warn(string, throwable);
                break;
            }
            case ERROR: {
                this.logger.error(string, throwable);
                break;
            }
        }
    }

    static String writeJsonFragment(Map<String, Object> map) {
        if (CoreUtils.isNullOrEmpty(map)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(map.size() * 20);
        boolean bl2 = false;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (bl2) {
                stringBuilder.append(',');
            } else {
                bl2 = true;
            }
            LoggingEventBuilder.writeKeyAndValue(entry.getKey(), entry.getValue(), stringBuilder);
        }
        return stringBuilder.toString();
    }

    private static void writeKeyAndValue(String string, Object object, StringBuilder stringBuilder) {
        stringBuilder.append('\"');
        JSON_STRING_ENCODER.quoteAsString(string, stringBuilder);
        stringBuilder.append("\":");
        if (object == null) {
            stringBuilder.append("null");
        } else if (LoggingEventBuilder.isUnquotedType(object)) {
            JSON_STRING_ENCODER.quoteAsString(object.toString(), stringBuilder);
        } else {
            stringBuilder.append('\"');
            JSON_STRING_ENCODER.quoteAsString(object.toString(), stringBuilder);
            stringBuilder.append('\"');
        }
    }

    private static boolean isUnquotedType(Object object) {
        return object instanceof Boolean || object instanceof Number;
    }

    private static final class ContextKeyValuePair {
        private final String key;
        private final Object value;
        private final Supplier<String> valueSupplier;

        ContextKeyValuePair(String string, Object object) {
            this.key = string;
            this.value = object;
            this.valueSupplier = null;
        }

        ContextKeyValuePair(String string, Supplier<String> supplier) {
            this.key = string;
            this.value = null;
            this.valueSupplier = supplier;
        }

        public void write(StringBuilder stringBuilder) {
            if (this.valueSupplier == null) {
                LoggingEventBuilder.writeKeyAndValue(this.key, this.value, stringBuilder);
            } else {
                LoggingEventBuilder.writeKeyAndValue(this.key, this.valueSupplier.get(), stringBuilder);
            }
        }
    }
}

