/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ImplUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.QueryParameter;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.UrlToken;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.UrlTokenType;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.UrlTokenizer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.UrlTokenizerState;

public final class UrlBuilder {
    private static final Map<String, UrlBuilder> PARSED_URLS = new ConcurrentHashMap<String, UrlBuilder>();
    private String scheme;
    private String host;
    private Integer port;
    private String path;
    private Map<String, QueryParameter> queryToCopy;
    private Map<String, QueryParameter> query;

    public UrlBuilder() {
        this(null);
    }

    private UrlBuilder(Map<String, QueryParameter> map) {
        this.queryToCopy = map;
    }

    public UrlBuilder setScheme(String string) {
        if (string == null || string.isEmpty()) {
            this.scheme = null;
        } else {
            this.with(string, UrlTokenizerState.SCHEME);
        }
        return this;
    }

    public String getScheme() {
        return this.scheme;
    }

    public UrlBuilder setHost(String string) {
        if (string == null || string.isEmpty()) {
            this.host = null;
        } else {
            this.with(string, UrlTokenizerState.SCHEME_OR_HOST);
        }
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public UrlBuilder setPort(String string) {
        if (CoreUtils.isNullOrEmpty(string)) {
            this.port = null;
            return this;
        }
        return this.with(string, UrlTokenizerState.PORT);
    }

    public UrlBuilder setPort(int n2) {
        this.port = n2;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public UrlBuilder setPath(String string) {
        if (string == null || string.isEmpty()) {
            this.path = null;
        } else {
            this.with(string, UrlTokenizerState.PATH);
        }
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public UrlBuilder setQueryParameter(String string, String string2) {
        this.initializeQuery();
        this.query.put(string, new QueryParameter(string, string2));
        return this;
    }

    public UrlBuilder addQueryParameter(String string, String string2) {
        this.initializeQuery();
        this.query.compute(string, (string3, queryParameter) -> {
            if (queryParameter == null) {
                return new QueryParameter(string, string2);
            }
            queryParameter.addValue(string2);
            return queryParameter;
        });
        return this;
    }

    public UrlBuilder setQuery(String string) {
        return string == null || string.isEmpty() ? this.clearQuery() : this.with(string, UrlTokenizerState.QUERY);
    }

    public UrlBuilder clearQuery() {
        if (CoreUtils.isNullOrEmpty(this.query)) {
            return this;
        }
        this.query.clear();
        return this;
    }

    public Map<String, String> getQuery() {
        this.initializeQuery();
        return this.query.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((QueryParameter)entry.getValue()).getValue()));
    }

    public String getQueryString() {
        if (CoreUtils.isNullOrEmpty(this.queryToCopy) && CoreUtils.isNullOrEmpty(this.query)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.appendQueryString(stringBuilder);
        return stringBuilder.toString();
    }

    private void appendQueryString(StringBuilder stringBuilder) {
        if (CoreUtils.isNullOrEmpty(this.queryToCopy) && CoreUtils.isNullOrEmpty(this.query)) {
            return;
        }
        stringBuilder.append('?');
        boolean bl2 = true;
        if (this.query == null) {
            this.query = new LinkedHashMap<String, QueryParameter>(this.queryToCopy.size());
            for (Map.Entry<String, QueryParameter> entry : this.queryToCopy.entrySet()) {
                bl2 = UrlBuilder.writeQueryValues(stringBuilder, entry.getKey(), entry.getValue().getValuesList(), bl2);
                this.query.put(entry.getKey(), entry.getValue());
            }
        } else {
            for (Map.Entry<String, QueryParameter> entry : this.query.entrySet()) {
                bl2 = UrlBuilder.writeQueryValues(stringBuilder, entry.getKey(), entry.getValue().getValuesList(), bl2);
            }
        }
    }

    private static boolean writeQueryValues(StringBuilder stringBuilder, String string, List<String> list, boolean bl2) {
        for (String string2 : list) {
            if (!bl2) {
                stringBuilder.append('&');
            }
            stringBuilder.append(string).append('=').append(string2);
            bl2 = false;
        }
        return bl2;
    }

    private UrlBuilder with(String string, UrlTokenizerState urlTokenizerState) {
        UrlTokenizer urlTokenizer = new UrlTokenizer(string, urlTokenizerState);
        while (urlTokenizer.next()) {
            UrlToken urlToken = urlTokenizer.current();
            String string2 = UrlBuilder.emptyToNull(urlToken.text());
            UrlTokenType urlTokenType = urlToken.type();
            switch (urlTokenType) {
                case SCHEME: {
                    this.scheme = string2;
                    break;
                }
                case HOST: {
                    this.host = string2;
                    break;
                }
                case PORT: {
                    this.port = string2 == null ? null : Integer.valueOf(Integer.parseInt(string2));
                    break;
                }
                case PATH: {
                    if (this.path != null && !"/".equals(this.path) && "/".equals(string2)) break;
                    this.path = string2;
                    break;
                }
                case QUERY: {
                    CoreUtils.parseQueryParameters(string2).forEachRemaining(entry -> this.addQueryParameter((String)entry.getKey(), (String)entry.getValue()));
                    break;
                }
            }
        }
        return this;
    }

    public URL toUrl() throws MalformedURLException {
        return ImplUtils.createUrl(this.toString());
    }

    public String toString() {
        boolean bl2;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = bl2 = this.path != null && (this.path.startsWith("http://") || this.path.startsWith("https://"));
        if (!bl2) {
            if (this.scheme != null) {
                stringBuilder.append(this.scheme);
                if (!this.scheme.endsWith("://")) {
                    stringBuilder.append("://");
                }
            }
            if (this.host != null) {
                stringBuilder.append(this.host);
            }
        }
        if (this.port != null) {
            stringBuilder.append(':');
            stringBuilder.append(this.port);
        }
        if (this.path != null) {
            if (stringBuilder.length() != 0 && !this.path.startsWith("/")) {
                stringBuilder.append('/');
            }
            stringBuilder.append(this.path);
        }
        this.appendQueryString(stringBuilder);
        return stringBuilder.toString();
    }

    static Map<String, UrlBuilder> getParsedUrls() {
        return PARSED_URLS;
    }

    public static UrlBuilder parse(String string2) {
        String string3;
        String string4 = string3 = string2 == null ? "" : string2;
        if (PARSED_URLS.size() >= 10000) {
            PARSED_URLS.clear();
        }
        return PARSED_URLS.computeIfAbsent(string3, string -> new UrlBuilder().with((String)string, UrlTokenizerState.SCHEME_OR_HOST)).copy();
    }

    public static UrlBuilder parse(URL uRL) {
        return ImplUtils.parseUrl(uRL, true);
    }

    private static String emptyToNull(String string) {
        return string == null || string.isEmpty() ? null : string;
    }

    private UrlBuilder copy() {
        UrlBuilder urlBuilder = new UrlBuilder(this.query);
        urlBuilder.scheme = this.scheme;
        urlBuilder.host = this.host;
        urlBuilder.path = this.path;
        urlBuilder.port = this.port;
        return urlBuilder;
    }

    private void initializeQuery() {
        if (this.query == null) {
            this.query = new LinkedHashMap<String, QueryParameter>();
        }
        if (this.queryToCopy != null) {
            this.query.putAll(this.queryToCopy);
            this.queryToCopy = null;
        }
    }
}

