/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util;

import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ImplUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ConfigurationProperty;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ConfigurationPropertyBuilder;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.tracing.TracerProvider;

public class TracingOptions {
    private static final ConfigurationProperty<Boolean> IS_DISABLED_PROPERTY = ConfigurationPropertyBuilder.ofBoolean("tracing.disabled").environmentVariableName("AZURE_TRACING_DISABLED").shared(true).defaultValue(false).build();
    private static final ConfigurationProperty<String> PROVIDER_NAME_PROPERTY = ConfigurationPropertyBuilder.ofString("tracing.provider.implementation").environmentVariableName("AZURE_TRACING_IMPLEMENTATION").shared(true).build();
    private static final Configuration GLOBAL_CONFIG = Configuration.getGlobalConfiguration();
    private final Class<? extends TracerProvider> tracerProvider;
    private Set<String> allowedQueryParamNames;
    private boolean isEnabled;

    public TracingOptions() {
        this(GLOBAL_CONFIG);
    }

    protected TracingOptions(Class<? extends TracerProvider> clazz) {
        this.tracerProvider = clazz;
        this.isEnabled = GLOBAL_CONFIG.get(IS_DISABLED_PROPERTY) == false;
    }

    private TracingOptions(Configuration configuration) {
        this.isEnabled = configuration.get(IS_DISABLED_PROPERTY) == false;
        String string = configuration.get(PROVIDER_NAME_PROPERTY);
        this.tracerProvider = string != null ? ImplUtils.getClassByName(string) : null;
    }

    public static TracingOptions fromConfiguration(Configuration configuration) {
        return new TracingOptions(configuration);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public TracingOptions setEnabled(boolean bl2) {
        this.isEnabled = bl2;
        return this;
    }

    public Class<? extends TracerProvider> getTracerProvider() {
        return this.tracerProvider;
    }

    public Set<String> getAllowedTracingQueryParamNames() {
        return this.allowedQueryParamNames;
    }

    public TracingOptions setAllowedTracingQueryParamNames(Set<String> set) {
        this.allowedQueryParamNames = set;
        return this;
    }
}

