/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Flux;

public class IterableStream<T>
implements Iterable<T> {
    private static final int DEFAULT_BATCH_SIZE = 1;
    private static final IterableStream<Object> EMPTY = new IterableStream(new ArrayList());
    private final Flux<T> flux;
    private final Iterable<T> iterable;

    public IterableStream(Flux<T> flux) {
        this.flux = Objects.requireNonNull(flux, "'flux' cannot be null.");
        this.iterable = null;
    }

    public IterableStream(Iterable<T> iterable) {
        this.iterable = Objects.requireNonNull(iterable, "'iterable' cannot be null.");
        this.flux = null;
    }

    public Stream<T> stream() {
        return this.flux != null ? this.flux.toStream(1) : StreamSupport.stream(this.iterable.spliterator(), false);
    }

    @Override
    public Iterator<T> iterator() {
        return this.flux != null ? this.flux.toIterable(1).iterator() : this.iterable.iterator();
    }

    public static <T> IterableStream<T> of(Iterable<T> iterable) {
        if (iterable == null) {
            return EMPTY;
        }
        return new IterableStream<T>(iterable);
    }
}

