/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util;

import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public final class ETag {
    private static final ClientLogger LOGGER = new ClientLogger(ETag.class);
    private static final String QUOTE_STRING = "\"";
    private static final String WEAK_ETAG_PREFIX_QUOTE = "W/\"";
    private static final String ASTERISK = "*";
    public static final ETag ALL = new ETag("*");
    private final String eTag;

    public ETag(String string) {
        this.checkValidETag(string);
        this.eTag = string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ETag)) {
            return false;
        }
        return Objects.equals(this.eTag, ((ETag)object).eTag);
    }

    public int hashCode() {
        return Objects.hashCode(this.eTag);
    }

    public String toString() {
        return this.eTag;
    }

    private void checkValidETag(String string) {
        if (string == null || ASTERISK.equals(string)) {
            return;
        }
        if (!string.startsWith(QUOTE_STRING) && !string.startsWith(WEAK_ETAG_PREFIX_QUOTE) || !string.endsWith(QUOTE_STRING)) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(String.format("The value=%s should be equal to * , be wrapped in quotes, or be wrapped in quotes prefixed by W/", string)));
        }
    }
}

