/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;

public class AuthorizationChallengeHandler {
    private static final String BASIC = "Basic ";
    private static final String DIGEST = "Digest ";
    private static final String ALGORITHM = "algorithm";
    private static final String REALM = "realm";
    private static final String NONCE = "nonce";
    private static final String QOP = "qop";
    private static final String AUTH = "auth";
    private static final String AUTH_INT = "auth-int";
    private static final String USERHASH = "userhash";
    private static final String OPAQUE = "opaque";
    private static final String NEXT_NONCE = "nextnonce";
    private static final String SESS = "-SESS";
    private static final String SHA_512_256 = "SHA-512-256";
    private static final String SHA_512_256_SESS = "SHA-512-256-SESS";
    private static final String SHA_256 = "SHA-256";
    private static final String SHA_256_SESS = "SHA-256-SESS";
    private static final String MD5 = "MD5";
    private static final String MD5_SESS = "MD5-SESS";
    private static final String[] ALGORITHM_PREFERENCE_ORDER = new String[]{"SHA-512-256", "SHA-512-256-SESS", "SHA-256", "SHA-256-SESS", "MD5", "MD5-SESS"};
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    public static final String AUTHORIZATION = "Authorization";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String AUTHENTICATION_INFO = "Authentication-Info";
    public static final String PROXY_AUTHENTICATION_INFO = "Proxy-Authentication-Info";
    private final String username;
    private final String password;
    private final Map<String, AtomicInteger> nonceTracker = new ConcurrentHashMap<String, AtomicInteger>();
    private final AtomicReference<String> authorizationPipeliningType = new AtomicReference();
    private final AtomicReference<ConcurrentHashMap<String, String>> lastChallenge = new AtomicReference();
    private final SecureRandom nonceGenerator = new SecureRandom();

    public AuthorizationChallengeHandler(String string, String string2) {
        this.username = Objects.requireNonNull(string, "'username' cannot be null.");
        this.password = Objects.requireNonNull(string2, "'password' cannot be null.");
    }

    public final String handleBasic() {
        this.authorizationPipeliningType.set(BASIC);
        String string = this.username + ":" + this.password;
        return BASIC + Base64.getEncoder().encodeToString(string.getBytes(StandardCharsets.UTF_8));
    }

    public final String handleDigest(String string, String string2, List<Map<String, String>> list, Supplier<byte[]> supplier) {
        this.authorizationPipeliningType.set(DIGEST);
        Map<String, List<Map<String, String>>> map = AuthorizationChallengeHandler.partitionByChallengeType(list);
        for (String string3 : ALGORITHM_PREFERENCE_ORDER) {
            Function<byte[], byte[]> function;
            if (!map.containsKey(string3) || (function = AuthorizationChallengeHandler.getDigestFunction(string3)) == null) continue;
            ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>(map.get(string3).get(0));
            this.lastChallenge.set(concurrentHashMap);
            return this.createDigestAuthorizationHeader(string, string2, concurrentHashMap, string3, supplier, function);
        }
        return null;
    }

    public final String attemptToPipelineAuthorization(String string, String string2, Supplier<byte[]> supplier) {
        String string3 = this.authorizationPipeliningType.get();
        if (DIGEST.equals(string3)) {
            HashMap<String, String> hashMap = new HashMap<String, String>((Map)this.lastChallenge.get());
            String string4 = (String)hashMap.get(ALGORITHM);
            if (string4 == null) {
                string4 = MD5;
            }
            return this.createDigestAuthorizationHeader(string, string2, hashMap, string4, supplier, AuthorizationChallengeHandler.getDigestFunction(string4));
        }
        if (BASIC.equals(string3)) {
            return this.handleBasic();
        }
        return null;
    }

    public final void consumeAuthenticationInfoHeader(Map<String, String> map) {
        if (CoreUtils.isNullOrEmpty(map)) {
            return;
        }
        if (map.containsKey(NEXT_NONCE)) {
            this.lastChallenge.get().put(NONCE, map.get(NEXT_NONCE));
        }
    }

    public static Map<String, String> parseAuthenticationOrAuthorizationHeader(String string2) {
        if (CoreUtils.isNullOrEmpty(string2)) {
            return Collections.emptyMap();
        }
        if (string2.startsWith(BASIC) || string2.startsWith(DIGEST)) {
            string2 = string2.split(" ", 2)[1];
        }
        return Stream.of(string2.split(",")).map(String::trim).map(string -> string.split("=", 2)).collect(Collectors.toMap(stringArray -> stringArray[0].toLowerCase(Locale.ROOT), stringArray -> stringArray[1].replace("\"", "")));
    }

    private String createDigestAuthorizationHeader(String string, String string2, Map<String, String> map, String string3, Supplier<byte[]> supplier, Function<byte[], byte[]> function) {
        String string4 = map.get(REALM);
        String string5 = map.get(NONCE);
        String string6 = this.getQop(map.get(QOP));
        String string7 = map.get(OPAQUE);
        boolean bl2 = Boolean.parseBoolean(map.get(USERHASH));
        int n2 = 0;
        String string8 = null;
        if (AUTH.equals(string6) || AUTH_INT.equals(string6)) {
            string8 = this.generateNonce();
            n2 = this.getNc(map);
        } else if (string3.endsWith(SESS)) {
            string8 = this.generateNonce();
        }
        String string9 = string3.endsWith(SESS) ? AuthorizationChallengeHandler.calculateHa1Sess(function, this.username, string4, this.password, string5, string8) : AuthorizationChallengeHandler.calculateHa1NoSess(function, this.username, string4, this.password);
        String string10 = AUTH_INT.equals(string6) ? AuthorizationChallengeHandler.calculateHa2AuthIntQop(function, string, string2, supplier.get()) : AuthorizationChallengeHandler.calculateHa2AuthQopOrEmpty(function, string, string2);
        String string11 = AUTH.equals(string6) || AUTH_INT.equals(string6) ? AuthorizationChallengeHandler.calculateResponseKnownQop(function, string9, string5, n2, string8, string6, string10) : AuthorizationChallengeHandler.calculateResponseUnknownQop(function, string9, string5, string10);
        String string12 = bl2 ? AuthorizationChallengeHandler.calculateUserhash(function, this.username, string4) : this.username;
        return AuthorizationChallengeHandler.buildAuthorizationHeader(string12, string4, string2, string3, string5, n2, string8, string6, string11, string7, bl2);
    }

    private int getNc(Map<String, String> map) {
        return this.nonceTracker.compute(map.get(NONCE), (string, atomicInteger) -> {
            if (atomicInteger == null) {
                return new AtomicInteger(1);
            }
            atomicInteger.incrementAndGet();
            return atomicInteger;
        }).get();
    }

    private String getQop(String string) {
        if (CoreUtils.isNullOrEmpty(string)) {
            return null;
        }
        if (string.equalsIgnoreCase(AUTH)) {
            return AUTH;
        }
        if (string.equalsIgnoreCase(AUTH_INT)) {
            return AUTH_INT;
        }
        return null;
    }

    private static String calculateHa1NoSess(Function<byte[], byte[]> function, String string, String string2, String string3) {
        return CoreUtils.bytesToHexString(function.apply((string + ":" + string2 + ":" + string3).getBytes(StandardCharsets.UTF_8)));
    }

    private static String calculateHa1Sess(Function<byte[], byte[]> function, String string, String string2, String string3, String string4, String string5) {
        String string6 = AuthorizationChallengeHandler.calculateHa1NoSess(function, string, string2, string3);
        return CoreUtils.bytesToHexString(function.apply((string6 + ":" + string4 + ":" + string5).getBytes(StandardCharsets.UTF_8)));
    }

    private static String calculateHa2AuthQopOrEmpty(Function<byte[], byte[]> function, String string, String string2) {
        return CoreUtils.bytesToHexString(function.apply((string + ":" + string2).getBytes(StandardCharsets.UTF_8)));
    }

    private static String calculateHa2AuthIntQop(Function<byte[], byte[]> function, String string, String string2, byte[] byArray) {
        String string3 = CoreUtils.bytesToHexString(function.apply(byArray));
        return CoreUtils.bytesToHexString(function.apply((string + ":" + string2 + ":" + string3).getBytes(StandardCharsets.UTF_8)));
    }

    private static String calculateResponseUnknownQop(Function<byte[], byte[]> function, String string, String string2, String string3) {
        return CoreUtils.bytesToHexString(function.apply((string + ":" + string2 + ":" + string3).getBytes(StandardCharsets.UTF_8)));
    }

    private static String calculateResponseKnownQop(Function<byte[], byte[]> function, String string, String string2, int n2, String string3, String string4, String string5) {
        String string6 = String.format("%08X", n2);
        return CoreUtils.bytesToHexString(function.apply((string + ":" + string2 + ":" + string6 + ":" + string3 + ":" + string4 + ":" + string5).getBytes(StandardCharsets.UTF_8)));
    }

    private static String calculateUserhash(Function<byte[], byte[]> function, String string, String string2) {
        return CoreUtils.bytesToHexString(function.apply((string + ":" + string2).getBytes(StandardCharsets.UTF_8)));
    }

    private static Function<byte[], byte[]> getDigestFunction(String string) {
        if (string.endsWith(SESS)) {
            string = string.substring(0, string.length() - SESS.length());
        }
        try {
            if (SHA_512_256.equals(string)) {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
                return byArray -> Arrays.copyOf(messageDigest.digest((byte[])byArray), 32);
            }
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            return messageDigest::digest;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    private static Map<String, List<Map<String, String>>> partitionByChallengeType(List<Map<String, String>> list) {
        return list.stream().collect(Collectors.groupingBy(map -> {
            String string = (String)map.get(ALGORITHM);
            return string == null ? MD5 : string.toUpperCase(Locale.ROOT);
        }));
    }

    String generateNonce() {
        byte[] byArray = new byte[16];
        this.nonceGenerator.nextBytes(byArray);
        return CoreUtils.bytesToHexString(byArray);
    }

    private static String buildAuthorizationHeader(String string, String string2, String string3, String string4, String string5, int n2, String string6, String string7, String string8, String string9, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder(512);
        stringBuilder.append(DIGEST).append("username=\"").append(string).append("\", ").append("realm=\"").append(string2).append("\", ").append("nonce=\"").append(string5).append("\", ").append("uri=\"").append(string3).append("\", ").append("response=\"").append(string8).append("\"");
        if (!CoreUtils.isNullOrEmpty(string4)) {
            stringBuilder.append(", algorithm=").append(string4);
        }
        if (!CoreUtils.isNullOrEmpty(string6)) {
            stringBuilder.append(", cnonce=\"").append(string6).append("\"");
        }
        if (!CoreUtils.isNullOrEmpty(string9)) {
            stringBuilder.append(", opaque=\"").append(string9).append("\"");
        }
        if (!CoreUtils.isNullOrEmpty(string7)) {
            stringBuilder.append(", qop=").append(string7);
            stringBuilder.append(", nc=").append(String.format("%08X", n2));
        }
        if (bl2) {
            stringBuilder.append(", userhash=true");
        }
        return stringBuilder.toString();
    }
}

