/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.models;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoBoundingBox;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoObject;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoObjectType;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoPosition;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonWriter;

public final class GeoPoint
extends GeoObject {
    private final GeoPosition coordinates;

    public GeoPoint(double d2, double d3) {
        this(d2, d3, null);
    }

    public GeoPoint(double d2, double d3, Double d4) {
        this(new GeoPosition(d2, d3, d4));
    }

    public GeoPoint(GeoPosition geoPosition) {
        this(geoPosition, null, null);
    }

    public GeoPoint(GeoPosition geoPosition, GeoBoundingBox geoBoundingBox, Map<String, Object> map) {
        super(geoBoundingBox, map);
        this.coordinates = Objects.requireNonNull(geoPosition, "'position' cannot be null.");
    }

    public GeoPosition getCoordinates() {
        return this.coordinates;
    }

    @Override
    public GeoObjectType getType() {
        return GeoObjectType.POINT;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.coordinates, super.hashCode());
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof GeoPoint)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        GeoPoint geoPoint = (GeoPoint)object;
        return super.equals(object) && Objects.equals(this.coordinates, geoPoint.coordinates);
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject().writeStringField("type", GeoObjectType.POINT.toString()).writeJsonField("coordinates", this.coordinates).writeJsonField("bbox", this.getBoundingBox());
        return this.writeCustomProperties(jsonWriter).writeEndObject();
    }

    public static GeoPoint fromJson(JsonReader jsonReader2) throws IOException {
        return jsonReader2.readObject(jsonReader -> {
            GeoPosition geoPosition = null;
            GeoBoundingBox geoBoundingBox = null;
            LinkedHashMap<String, Object> linkedHashMap = null;
            while (jsonReader.nextToken() != JsonToken.END_OBJECT) {
                String string = jsonReader.getFieldName();
                jsonReader.nextToken();
                if ("type".equals(string)) {
                    String string2 = jsonReader.getString();
                    if (GeoObjectType.POINT.toString().equals(string2)) continue;
                    throw new IllegalStateException("'type' was expected to be non-null and equal to 'Point'. The found 'type' was '" + string2 + "'.");
                }
                if ("coordinates".equals(string)) {
                    geoPosition = GeoPosition.fromJson(jsonReader);
                    continue;
                }
                if ("bbox".equals(string)) {
                    geoBoundingBox = GeoBoundingBox.fromJson(jsonReader);
                    continue;
                }
                if (linkedHashMap == null) {
                    linkedHashMap = new LinkedHashMap<String, Object>();
                }
                linkedHashMap.put(string, jsonReader.readUntyped());
            }
            return new GeoPoint(geoPosition, geoBoundingBox, linkedHashMap);
        });
    }
}

