/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.models;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonSerializable;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonWriter;

public final class GeoBoundingBox
implements JsonSerializable<GeoBoundingBox> {
    private static final ClientLogger LOGGER = new ClientLogger(GeoBoundingBox.class);
    private final double west;
    private final double south;
    private final double east;
    private final double north;
    private final Double minAltitude;
    private final Double maxAltitude;

    public GeoBoundingBox(double d2, double d3, double d4, double d5) {
        this(d2, d3, d4, d5, null, null, null);
    }

    public GeoBoundingBox(double d2, double d3, double d4, double d5, double d6, double d7) {
        this(d2, d3, d4, d5, d6, d7, null);
    }

    private GeoBoundingBox(double d2, double d3, double d4, double d5, Double d6, Double d7, String string) {
        this.west = d2;
        this.south = d3;
        this.east = d4;
        this.north = d5;
        this.minAltitude = d6;
        this.maxAltitude = d7;
    }

    public double getWest() {
        return this.west;
    }

    public double getSouth() {
        return this.south;
    }

    public double getEast() {
        return this.east;
    }

    public double getNorth() {
        return this.north;
    }

    public Double getMinAltitude() {
        return this.minAltitude;
    }

    public Double getMaxAltitude() {
        return this.maxAltitude;
    }

    public int hashCode() {
        return Objects.hash(this.west, this.south, this.east, this.north, this.minAltitude, this.maxAltitude);
    }

    public boolean equals(Object object) {
        if (!(object instanceof GeoBoundingBox)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        GeoBoundingBox geoBoundingBox = (GeoBoundingBox)object;
        return Double.compare(this.west, geoBoundingBox.west) == 0 && Double.compare(this.south, geoBoundingBox.south) == 0 && Double.compare(this.east, geoBoundingBox.east) == 0 && Double.compare(this.north, geoBoundingBox.north) == 0 && Objects.equals(this.minAltitude, geoBoundingBox.minAltitude) && Objects.equals(this.maxAltitude, geoBoundingBox.maxAltitude);
    }

    double get(int n2) {
        if (this.minAltitude != null && this.maxAltitude != null) {
            switch (n2) {
                case 0: {
                    return this.west;
                }
                case 1: {
                    return this.south;
                }
                case 2: {
                    return this.minAltitude;
                }
                case 3: {
                    return this.east;
                }
                case 4: {
                    return this.north;
                }
                case 5: {
                    return this.maxAltitude;
                }
            }
            throw LOGGER.logExceptionAsWarning(new IndexOutOfBoundsException("Index out of range: " + n2));
        }
        switch (n2) {
            case 0: {
                return this.west;
            }
            case 1: {
                return this.south;
            }
            case 2: {
                return this.east;
            }
            case 3: {
                return this.north;
            }
        }
        throw LOGGER.logExceptionAsWarning(new IndexOutOfBoundsException("Index out of range: " + n2));
    }

    public String toString() {
        return this.minAltitude != null && this.maxAltitude != null ? String.format("[%s, %s, %s, %s, %s, %s]", this.west, this.south, this.minAltitude, this.east, this.north, this.maxAltitude) : String.format("[%s, %s, %s, %s]", this.west, this.south, this.east, this.north);
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartArray().writeDouble(this.west).writeDouble(this.south);
        if (this.minAltitude != null) {
            jsonWriter.writeDouble(this.minAltitude);
        }
        jsonWriter.writeDouble(this.east).writeDouble(this.north);
        if (this.maxAltitude != null) {
            jsonWriter.writeDouble(this.maxAltitude);
        }
        return jsonWriter.writeEndArray();
    }

    public static GeoBoundingBox fromJson(JsonReader jsonReader2) throws IOException {
        List<Number> list = jsonReader2.readArray(jsonReader -> {
            if (jsonReader.currentToken() == JsonToken.NUMBER) {
                return jsonReader.getDouble();
            }
            return null;
        });
        if (list == null) {
            return null;
        }
        int n2 = list.size();
        if (n2 != 4 && n2 != 6) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("Only 2 or 3 dimension bounding boxes are supported."));
        }
        double d2 = list.get(0).doubleValue();
        double d3 = list.get(1).doubleValue();
        double d4 = list.get(n2 == 6 ? 3 : 2).doubleValue();
        double d5 = list.get(n2 == 6 ? 4 : 3).doubleValue();
        Double d6 = n2 == 6 ? Double.valueOf(list.get(2).doubleValue()) : null;
        Double d7 = n2 == 6 ? Double.valueOf(list.get(5).doubleValue()) : null;
        return new GeoBoundingBox(d2, d3, d4, d5, d6, d7, null);
    }
}

