/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util;

import java.time.Duration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public final class HttpUtils {
    private static final ClientLogger LOGGER = new ClientLogger(HttpUtils.class);
    private static final Duration MINIMUM_TIMEOUT = Duration.ofMillis(1L);
    private static final Duration DEFAULT_CONNECT_TIMEOUT;
    private static final Duration DEFAULT_WRITE_TIMEOUT;
    private static final Duration DEFAULT_RESPONSE_TIMEOUT;
    private static final Duration DEFAULT_READ_TIMEOUT;
    public static final String AZURE_EAGERLY_READ_RESPONSE = "azure-eagerly-read-response";
    public static final String AZURE_IGNORE_RESPONSE_BODY = "azure-ignore-response-body";
    public static final String AZURE_RESPONSE_TIMEOUT = "azure-response-timeout";
    public static final String AZURE_EAGERLY_CONVERT_HEADERS = "azure-eagerly-convert-headers";

    public static Duration getDefaultConnectTimeout() {
        return DEFAULT_CONNECT_TIMEOUT;
    }

    public static Duration getDefaultWriteTimeout() {
        return DEFAULT_WRITE_TIMEOUT;
    }

    public static Duration getDefaultResponseTimeout() {
        return DEFAULT_RESPONSE_TIMEOUT;
    }

    public static Duration getDefaultReadTimeout() {
        return DEFAULT_READ_TIMEOUT;
    }

    public static Duration getTimeout(Duration duration, Duration duration2) {
        if (duration == null) {
            return duration2;
        }
        if (duration.isZero() || duration.isNegative()) {
            return Duration.ZERO;
        }
        if (duration.compareTo(MINIMUM_TIMEOUT) < 0) {
            return MINIMUM_TIMEOUT;
        }
        return duration;
    }

    private HttpUtils() {
    }

    static {
        Configuration configuration = Configuration.getGlobalConfiguration();
        DEFAULT_CONNECT_TIMEOUT = CoreUtils.getDefaultTimeoutFromEnvironment(configuration, "AZURE_REQUEST_CONNECT_TIMEOUT", Duration.ofSeconds(10L), LOGGER);
        DEFAULT_WRITE_TIMEOUT = CoreUtils.getDefaultTimeoutFromEnvironment(configuration, "AZURE_REQUEST_WRITE_TIMEOUT", Duration.ofSeconds(60L), LOGGER);
        DEFAULT_RESPONSE_TIMEOUT = CoreUtils.getDefaultTimeoutFromEnvironment(configuration, "AZURE_REQUEST_RESPONSE_TIMEOUT", Duration.ofSeconds(60L), LOGGER);
        DEFAULT_READ_TIMEOUT = CoreUtils.getDefaultTimeoutFromEnvironment(configuration, "AZURE_REQUEST_READ_TIMEOUT", Duration.ofSeconds(60L), LOGGER);
    }
}

