/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import macromedia.jdbc.sqlserver.externals.com.azure.core.annotation.JsonFlatten;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ExpandableStringEnum;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonAnyGetter;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonGenerator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.TreeNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.BeanDescription;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.BeanProperty;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonMappingException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ObjectMapper;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.PropertyMetadata;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.PropertyName;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializationConfig;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializerProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.module.SimpleModule;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.ArrayNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.ObjectNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.AnyGetterWriter;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.std.StdSerializer;

class FlatteningSerializer
extends StdSerializer<Object>
implements ResolvableSerializer {
    private static final long serialVersionUID = -6130180289951110573L;
    private static final Pattern CHECK_IF_FLATTEN_PROPERTY_PATTERN = Pattern.compile(".+[^\\\\]\\..+");
    private static final Pattern UNESCAPED_PERIOD_PATTERN = Pattern.compile("((?<!\\\\))\\.");
    private static final Pattern CHECK_IF_ESCAPED_MAP_PATTERN = Pattern.compile(".*[^\\\\]\\\\..+");
    private static final Pattern REPLACE_ESCAPED_MAP_PATTERN = Pattern.compile("\\\\.");
    private static final ClientLogger LOGGER = new ClientLogger(FlatteningSerializer.class);
    private final BeanDescription beanDescription;
    private final JsonSerializer<?> defaultSerializer;
    private final ObjectMapper mapper;
    private final boolean classHasJsonFlatten;
    private final Set<String> jsonPropertiesWithJsonFlatten;

    FlatteningSerializer(BeanDescription beanDescription, JsonSerializer<?> jsonSerializer, ObjectMapper objectMapper) {
        super(beanDescription.getBeanClass(), false);
        this.beanDescription = beanDescription;
        this.defaultSerializer = jsonSerializer;
        this.mapper = objectMapper;
        this.classHasJsonFlatten = beanDescription.getClassAnnotations().has(JsonFlatten.class);
        this.jsonPropertiesWithJsonFlatten = this.classHasJsonFlatten ? Collections.emptySet() : beanDescription.findProperties().stream().filter(BeanPropertyDefinition::hasField).filter(beanPropertyDefinition -> beanPropertyDefinition.getField().hasAnnotation(JsonFlatten.class)).map(BeanPropertyDefinition::getName).collect(Collectors.toSet());
    }

    public static SimpleModule getModule(final ObjectMapper objectMapper) {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.setSerializerModifier(new BeanSerializerModifier(){

            @Override
            public JsonSerializer<?> modifySerializer(SerializationConfig serializationConfig, BeanDescription beanDescription, JsonSerializer<?> jsonSerializer) {
                boolean bl2 = beanDescription.getClassAnnotations().has(JsonFlatten.class);
                boolean bl3 = beanDescription.findProperties().stream().filter(BeanPropertyDefinition::hasField).map(BeanPropertyDefinition::getField).anyMatch(annotatedField -> annotatedField.hasAnnotation(JsonFlatten.class));
                if (bl2 || bl3) {
                    return new FlatteningSerializer(beanDescription, jsonSerializer, objectMapper);
                }
                return jsonSerializer;
            }
        });
        return simpleModule;
    }

    private static List<Field> getAllDeclaredFields(Class<?> clazz) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        while (clazz != null && !clazz.equals(Object.class)) {
            for (Field field : clazz.getDeclaredFields()) {
                int n2 = field.getModifiers();
                if (Modifier.isFinal(n2) || Modifier.isStatic(n2)) continue;
                arrayList.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return arrayList;
    }

    private static void escapeMapKeys(Object object, ClientLogger clientLogger) {
        if (object == null) {
            return;
        }
        if (object.getClass().isPrimitive() || object.getClass().isEnum() || object instanceof OffsetDateTime || object instanceof Duration || object instanceof String || object instanceof ExpandableStringEnum) {
            return;
        }
        if (object instanceof Map) {
            for (Object object2 : new HashSet(((Map)object).keySet())) {
                if (!((String)object2).contains(".")) continue;
                String string = UNESCAPED_PERIOD_PATTERN.matcher((CharSequence)object2).replaceAll("\\\\.");
                Object v2 = ((Map)object).remove(object2);
                ((Map)object).put(string, v2);
            }
            for (Object object2 : ((Map)object).values()) {
                FlatteningSerializer.escapeMapKeys(object2, clientLogger);
            }
            return;
        }
        if (object instanceof List) {
            for (Object e2 : (List)object) {
                FlatteningSerializer.escapeMapKeys(e2, clientLogger);
            }
            return;
        }
        for (Field field : FlatteningSerializer.getAllDeclaredFields(object.getClass())) {
            field.setAccessible(true);
            try {
                FlatteningSerializer.escapeMapKeys(field.get(object), clientLogger);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw clientLogger.logExceptionAsError(new RuntimeException(illegalAccessException));
            }
        }
    }

    @Override
    public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        if (object == null) {
            jsonGenerator.writeNull();
            return;
        }
        if (this.classHasJsonFlatten) {
            this.classLevelFlattenSerialize(object, jsonGenerator);
        } else {
            ObjectNode objectNode = this.mapper.createObjectNode();
            if (typeSerializer != null) {
                objectNode.put(typeSerializer.getPropertyName(), typeSerializer.getTypeIdResolver().idFromValue(object));
            }
            this.propertyOnlyFlattenSerialize(object, jsonGenerator, serializerProvider, objectNode);
        }
    }

    @Override
    public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        this.serializeWithType(object, jsonGenerator, serializerProvider, (TypeSerializer)null);
    }

    @Override
    public void resolve(SerializerProvider serializerProvider) throws JsonMappingException {
        if (this.defaultSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)((Object)this.defaultSerializer)).resolve(serializerProvider);
        }
    }

    private void propertyOnlyFlattenSerialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, ObjectNode objectNode) throws IOException {
        Object object2;
        Object object3;
        Serializable serializable;
        for (BeanPropertyDefinition object42 : this.beanDescription.findProperties()) {
            serializable = objectNode;
            object3 = object42.getName();
            if (this.jsonPropertiesWithJsonFlatten.contains(object42.getName())) {
                object2 = UNESCAPED_PERIOD_PATTERN.split(object42.getName());
                object3 = object2[((String[])object2).length - 1];
                for (int i2 = 0; i2 < ((String[])object2).length - 1; ++i2) {
                    serializable = ((JsonNode)((Object)serializable)).has(object2[i2]) ? (ObjectNode)((ObjectNode)serializable).get(object2[i2]) : ((ObjectNode)serializable).putObject(object2[i2]);
                }
            }
            ((ObjectNode)serializable).putPOJO((String)object3, object42.getField().getValue(object));
        }
        jsonGenerator.writeStartObject();
        Iterator<Object> iterator = objectNode.fields();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            jsonGenerator.writeFieldName((String)entry.getKey());
            jsonGenerator.writeTree((TreeNode)entry.getValue());
        }
        AnnotatedMember annotatedMember = this.beanDescription.findAnyGetter();
        if (annotatedMember != null && annotatedMember.getAnnotation(JsonAnyGetter.class).enabled()) {
            serializable = new BeanProperty.Std(PropertyName.construct(annotatedMember.getName()), annotatedMember.getType(), null, annotatedMember, PropertyMetadata.STD_OPTIONAL);
            object3 = serializerProvider.findTypedValueSerializer(annotatedMember.getType(), true, (BeanProperty)((Object)serializable));
            object2 = new AnyGetterWriter((BeanProperty)((Object)serializable), annotatedMember, (JsonSerializer<?>)object3);
            try {
                ((AnyGetterWriter)object2).getAndSerialize(object, jsonGenerator, serializerProvider);
            }
            catch (IOException iOException) {
                throw LOGGER.logThrowableAsError(iOException);
            }
            catch (Exception exception) {
                throw LOGGER.logThrowableAsError(new IOException(exception));
            }
        }
        jsonGenerator.writeEndObject();
    }

    private void classLevelFlattenSerialize(Object object, JsonGenerator jsonGenerator) throws IOException {
        FlatteningSerializer.escapeMapKeys(object, LOGGER);
        ObjectNode objectNode = (ObjectNode)this.mapper.valueToTree(object);
        ObjectNode objectNode2 = objectNode.deepCopy();
        LinkedBlockingQueue<ObjectNode> linkedBlockingQueue = new LinkedBlockingQueue<ObjectNode>();
        LinkedBlockingQueue<ObjectNode> linkedBlockingQueue2 = new LinkedBlockingQueue<ObjectNode>();
        linkedBlockingQueue.add(objectNode);
        linkedBlockingQueue2.add(objectNode2);
        while (!linkedBlockingQueue.isEmpty()) {
            ObjectNode objectNode3 = (ObjectNode)linkedBlockingQueue.poll();
            ObjectNode objectNode4 = (ObjectNode)linkedBlockingQueue2.poll();
            Iterator<Map.Entry<String, JsonNode>> iterator = objectNode3.fields();
            while (iterator.hasNext()) {
                Object object2;
                Map.Entry<String, JsonNode> entry = iterator.next();
                ObjectNode objectNode5 = objectNode4;
                String string = entry.getKey();
                JsonNode jsonNode = objectNode4.get(string);
                if (CHECK_IF_FLATTEN_PROPERTY_PATTERN.matcher(string).matches()) {
                    object2 = UNESCAPED_PERIOD_PATTERN.split(string);
                    for (int i2 = 0; i2 < ((String[])object2).length; ++i2) {
                        object2[i2] = object2[i2].replace("\\.", ".");
                        if (i2 == ((String[])object2).length - 1) break;
                        String string2 = object2[i2];
                        if (objectNode5.has(string2)) {
                            objectNode5 = (ObjectNode)objectNode5.get(string2);
                            continue;
                        }
                        ObjectNode objectNode6 = new ObjectNode(JsonNodeFactory.instance);
                        objectNode5.set(string2, objectNode6);
                        objectNode5 = objectNode6;
                    }
                    objectNode5.set(object2[((String[])object2).length - 1], objectNode4.get(string));
                    objectNode4.remove(string);
                    jsonNode = objectNode5.get(object2[((String[])object2).length - 1]);
                } else if (CHECK_IF_ESCAPED_MAP_PATTERN.matcher(string).matches()) {
                    object2 = REPLACE_ESCAPED_MAP_PATTERN.matcher(string).replaceAll(".");
                    objectNode4.remove(string);
                    objectNode4.set((String)object2, jsonNode);
                }
                if (entry.getValue() instanceof ObjectNode) {
                    linkedBlockingQueue.add((ObjectNode)entry.getValue());
                    linkedBlockingQueue2.add((ObjectNode)jsonNode);
                    continue;
                }
                if (!(entry.getValue() instanceof ArrayNode) || entry.getValue().size() <= 0 || !(entry.getValue().get(0) instanceof ObjectNode)) continue;
                object2 = entry.getValue().elements();
                Iterator<JsonNode> iterator2 = jsonNode.elements();
                while (object2.hasNext()) {
                    linkedBlockingQueue.add((ObjectNode)object2.next());
                    linkedBlockingQueue2.add((ObjectNode)iterator2.next());
                }
            }
        }
        jsonGenerator.writeTree(objectNode2);
    }
}

