/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson;

import java.io.IOException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.BinaryDataContent;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.BinaryDataHelper;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.BinaryData;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonGenerator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializerProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.module.SimpleModule;

final class BinaryDataSerializer
extends JsonSerializer<BinaryData> {
    private static final ClientLogger LOGGER = new ClientLogger(BinaryDataSerializer.class);

    BinaryDataSerializer() {
    }

    public static SimpleModule getModule() {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(BinaryData.class, new BinaryDataSerializer());
        return simpleModule;
    }

    @Override
    public void serialize(BinaryData binaryData, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (binaryData == null) {
            return;
        }
        BinaryDataContent binaryDataContent = BinaryDataHelper.getContent(binaryData);
        switch (binaryDataContent.getContentType()) {
            case BINARY: {
                jsonGenerator.writeBinary(binaryDataContent.toBytes());
                break;
            }
            case OBJECT: {
                jsonGenerator.writeRawValue(binaryDataContent.toString());
                break;
            }
            case TEXT: {
                jsonGenerator.writeString(binaryDataContent.toString());
                break;
            }
            default: {
                throw LOGGER.logExceptionAsError(new IllegalStateException("Unsupported BinaryData content type: " + binaryDataContent.getClass().getName()));
            }
        }
    }
}

