/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import macromedia.jdbc.sqlserver.externals.com.azure.core.annotation.ResumeOperation;
import macromedia.jdbc.sqlserver.externals.com.azure.core.exception.UnexpectedLengthException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaderName;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipeline;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineBuilder;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.CookiePolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpPipelinePolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.RetryPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.UserAgentPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.RequestOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.LengthValidatingInputStream;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.BinaryDataContent;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.BinaryDataHelper;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.FluxByteBufferContent;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.InputStreamContent;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.BinaryData;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Context;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.JacksonAdapter;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.SerializerAdapter;
import macromedia.jdbc.sqlserver.externals.org.reactivestreams.Publisher;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Flux;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public final class RestProxyUtils {
    private static final ByteBuffer VALIDATION_BUFFER = ByteBuffer.allocate(0);
    public static final String BODY_TOO_LARGE = "Request body emitted %d bytes, more than the expected %d bytes.";
    public static final String BODY_TOO_SMALL = "Request body emitted %d bytes, less than the expected %d bytes.";
    public static final ClientLogger LOGGER = new ClientLogger(RestProxyUtils.class);

    private RestProxyUtils() {
    }

    public static Mono<HttpRequest> validateLengthAsync(HttpRequest httpRequest) {
        BinaryData binaryData = httpRequest.getBodyAsBinaryData();
        if (binaryData == null) {
            return Mono.just((Object)httpRequest);
        }
        return Mono.fromCallable(() -> {
            BinaryDataContent binaryDataContent = BinaryDataHelper.getContent(binaryData);
            long l2 = Long.parseLong(httpRequest.getHeaders().getValue(HttpHeaderName.CONTENT_LENGTH));
            if (binaryDataContent instanceof InputStreamContent) {
                LengthValidatingInputStream lengthValidatingInputStream = new LengthValidatingInputStream(binaryDataContent.toStream(), l2);
                httpRequest.setBody(BinaryData.fromStream(lengthValidatingInputStream, l2));
            } else if (binaryDataContent instanceof FluxByteBufferContent) {
                httpRequest.setBody(RestProxyUtils.validateFluxLength(binaryData.toFluxByteBuffer(), l2));
            } else {
                Long l3 = binaryData.getLength();
                if (l3 != null) {
                    if (l3 < l2) {
                        throw new UnexpectedLengthException(String.format(BODY_TOO_SMALL, l3, l2), l3, l2);
                    }
                    if (l3 > l2) {
                        throw new UnexpectedLengthException(String.format(BODY_TOO_LARGE, l3, l2), l3, l2);
                    }
                } else {
                    httpRequest.setBody(RestProxyUtils.validateFluxLength(binaryData.toFluxByteBuffer(), l2));
                }
            }
            return httpRequest;
        });
    }

    private static Flux<ByteBuffer> validateFluxLength(Flux<ByteBuffer> flux, long l2) {
        if (flux == null) {
            return Flux.empty();
        }
        return Flux.defer(() -> {
            long[] lArray = new long[1];
            return Flux.concat((Publisher[])new Publisher[]{flux, Flux.just((Object)VALIDATION_BUFFER)}).handle((byteBuffer, synchronousSink) -> {
                if (byteBuffer == null) {
                    return;
                }
                if (byteBuffer == VALIDATION_BUFFER) {
                    if (l2 != lArray[0]) {
                        synchronousSink.error((Throwable)new UnexpectedLengthException(String.format(BODY_TOO_SMALL, lArray[0], l2), lArray[0], l2));
                    } else {
                        synchronousSink.complete();
                    }
                    return;
                }
                lArray[0] = lArray[0] + (long)byteBuffer.remaining();
                if (lArray[0] > l2) {
                    synchronousSink.error((Throwable)new UnexpectedLengthException(String.format(BODY_TOO_LARGE, lArray[0], l2), lArray[0], l2));
                    return;
                }
                synchronousSink.next(byteBuffer);
            });
        });
    }

    public static BinaryData validateLengthSync(HttpRequest httpRequest) {
        BinaryData binaryData = httpRequest.getBodyAsBinaryData();
        if (binaryData == null) {
            return null;
        }
        long l2 = Long.parseLong(httpRequest.getHeaders().getValue(HttpHeaderName.CONTENT_LENGTH));
        Long l3 = binaryData.getLength();
        BinaryDataContent binaryDataContent = BinaryDataHelper.getContent(binaryData);
        if (binaryDataContent instanceof FluxByteBufferContent) {
            throw new IllegalStateException("Flux Byte Buffer is not supported in Synchronous Rest Proxy.");
        }
        if (binaryDataContent instanceof InputStreamContent) {
            InputStreamContent inputStreamContent = (InputStreamContent)binaryDataContent;
            InputStream inputStream = inputStreamContent.toStream();
            LengthValidatingInputStream lengthValidatingInputStream = new LengthValidatingInputStream(inputStream, l2);
            return BinaryData.fromStream(lengthValidatingInputStream, l2);
        }
        if (l3 == null) {
            byte[] byArray = binaryDataContent.toBytes();
            l3 = Integer.valueOf(byArray.length).longValue();
            RestProxyUtils.validateLength(l3, l2);
            return BinaryData.fromBytes(byArray);
        }
        RestProxyUtils.validateLength(l3, l2);
        return binaryData;
    }

    private static void validateLength(long l2, long l3) {
        if (l2 > l3) {
            throw new UnexpectedLengthException(String.format(BODY_TOO_LARGE, l2, l3), l2, l3);
        }
        if (l2 < l3) {
            throw new UnexpectedLengthException(String.format(BODY_TOO_SMALL, l2, l3), l2, l3);
        }
    }

    public static Context mergeRequestOptionsContext(Context context, RequestOptions requestOptions) {
        if (requestOptions == null) {
            return context;
        }
        Context context2 = requestOptions.getContext();
        if (context2 != null && context2 != Context.NONE) {
            context = CoreUtils.mergeContexts(context, context2);
        }
        return context;
    }

    public static void validateResumeOperationIsNotPresent(Method method) {
        if (method.isAnnotationPresent(ResumeOperation.class)) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("'ResumeOperation' isn't supported."));
        }
    }

    public static SerializerAdapter createDefaultSerializer() {
        return JacksonAdapter.createDefaultSerializerAdapter();
    }

    public static HttpPipeline createDefaultPipeline() {
        ArrayList<HttpPipelinePolicy> arrayList = new ArrayList<HttpPipelinePolicy>();
        arrayList.add(new UserAgentPolicy());
        arrayList.add(new RetryPolicy());
        arrayList.add(new CookiePolicy());
        return new HttpPipelineBuilder().policies(arrayList.toArray(new HttpPipelinePolicy[0])).build();
    }
}

