/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.function.Consumer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.exception.ClientAuthenticationException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.exception.DecodeException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.exception.HttpResponseException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.exception.ResourceExistsException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.exception.ResourceModifiedException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.exception.ResourceNotFoundException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.exception.TooManyRedirectsException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaderName;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaders;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipeline;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.Page;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.PagedResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.PagedResponseBase;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.RequestOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.Response;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.ResponseBase;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectiveInvoker;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.TypeUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.UnexpectedExceptionInformation;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.ErrorOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.RequestDataConfiguration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.ResponseConstructorsCache;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.ResponseExceptionConstructorCache;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.RestProxyUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.SwaggerInterfaceParser;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.SwaggerMethodParser;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.serializer.HttpResponseDecoder;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.serializer.MalformedValueException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.BinaryData;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Context;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.FluxUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.UrlBuilder;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.SerializerAdapter;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.tracing.Tracer;
import macromedia.jdbc.sqlserver.externals.reactor.core.Exceptions;

public abstract class RestProxyBase {
    static final String MUST_IMPLEMENT_PAGE_ERROR = "Unable to create PagedResponse<T>. Body must be of a type that implements: " + Page.class;
    static final ResponseConstructorsCache RESPONSE_CONSTRUCTORS_CACHE = new ResponseConstructorsCache();
    private static final ResponseExceptionConstructorCache RESPONSE_EXCEPTION_CONSTRUCTOR_CACHE = new ResponseExceptionConstructorCache();
    static final ClientLogger LOGGER = new ClientLogger(RestProxyBase.class);
    final HttpPipeline httpPipeline;
    final SerializerAdapter serializer;
    final SwaggerInterfaceParser interfaceParser;
    final HttpResponseDecoder decoder;
    protected final Tracer tracer;

    public RestProxyBase(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, SwaggerInterfaceParser swaggerInterfaceParser) {
        this.httpPipeline = httpPipeline;
        this.serializer = serializerAdapter;
        this.interfaceParser = swaggerInterfaceParser;
        this.decoder = new HttpResponseDecoder(this.serializer);
        this.tracer = httpPipeline.getTracer();
    }

    public final Object invoke(Object object, Method method, RequestOptions requestOptions, EnumSet<ErrorOptions> enumSet, Consumer<HttpRequest> consumer, SwaggerMethodParser swaggerMethodParser, boolean bl2, Object[] objectArray) {
        try {
            HttpRequest httpRequest = this.createHttpRequest(swaggerMethodParser, this.serializer, bl2, objectArray);
            Context context = swaggerMethodParser.setContext(objectArray);
            context = RestProxyUtils.mergeRequestOptionsContext(context, requestOptions);
            context = context.addData("caller-method", swaggerMethodParser.getFullyQualifiedMethodName());
            if (swaggerMethodParser.isResponseEagerlyRead()) {
                context = context.addData("azure-eagerly-read-response", true);
            }
            if (swaggerMethodParser.isResponseBodyIgnored()) {
                context = context.addData("azure-ignore-response-body", true);
            }
            if (swaggerMethodParser.isHeadersEagerlyConverted()) {
                context = context.addData("azure-eagerly-convert-headers", true);
            }
            return this.invoke(object, method, requestOptions, enumSet, consumer, swaggerMethodParser, httpRequest, context);
        }
        catch (IOException iOException) {
            if (bl2) {
                return FluxUtil.monoError(LOGGER, Exceptions.propagate((Throwable)iOException));
            }
            throw LOGGER.logExceptionAsError(Exceptions.propagate((Throwable)iOException));
        }
    }

    protected abstract Object invoke(Object var1, Method var2, RequestOptions var3, EnumSet<ErrorOptions> var4, Consumer<HttpRequest> var5, SwaggerMethodParser var6, HttpRequest var7, Context var8);

    public abstract void updateRequest(RequestDataConfiguration var1, SerializerAdapter var2) throws IOException;

    public Response createResponse(HttpResponseDecoder.HttpDecodedResponse httpDecodedResponse, Type type, Object object) {
        Class<?> clazz = TypeUtil.getRawClass(type);
        HttpResponse httpResponse = httpDecodedResponse.getSourceResponse();
        HttpRequest httpRequest = httpResponse.getRequest();
        int n2 = httpResponse.getStatusCode();
        HttpHeaders httpHeaders = httpResponse.getHeaders();
        Object object2 = httpDecodedResponse.getDecodedHeaders();
        if (clazz.equals(Response.class)) {
            return (Response)clazz.cast(new ResponseBase<Object, Object>(httpRequest, n2, httpHeaders, object, object2));
        }
        if (clazz.equals(PagedResponse.class)) {
            if (object != null && !TypeUtil.isTypeOrSubTypeOf(object.getClass(), Page.class)) {
                throw LOGGER.logExceptionAsError(new RuntimeException(MUST_IMPLEMENT_PAGE_ERROR));
            }
            if (object == null) {
                return (Response)clazz.cast(new PagedResponseBase(httpRequest, n2, httpHeaders, null, null, object2));
            }
            return (Response)clazz.cast(new PagedResponseBase(httpRequest, n2, httpHeaders, (Page)object, object2));
        }
        ReflectiveInvoker reflectiveInvoker = RESPONSE_CONSTRUCTORS_CACHE.get(clazz);
        return RESPONSE_CONSTRUCTORS_CACHE.invoke(reflectiveInvoker, httpDecodedResponse, object);
    }

    Context startTracingSpan(SwaggerMethodParser swaggerMethodParser, Context context) {
        if (this.isTracingEnabled(context)) {
            Object var3_3 = context.getData("trace-context").orElse(null);
            Context context2 = var3_3 instanceof Context ? (Context)var3_3 : context;
            return this.tracer.start(swaggerMethodParser.getSpanName(), context2);
        }
        return context;
    }

    protected boolean isTracingEnabled(Context context) {
        return this.tracer.isEnabled() && (Boolean)context.getData("disable-tracing").orElse(false) == false;
    }

    HttpRequest createHttpRequest(SwaggerMethodParser swaggerMethodParser, SerializerAdapter serializerAdapter, boolean bl2, Object[] objectArray) throws IOException {
        Object object;
        UrlBuilder urlBuilder;
        String string = swaggerMethodParser.setPath(objectArray, this.serializer);
        UrlBuilder urlBuilder2 = UrlBuilder.parse(string);
        if (urlBuilder2.getScheme() != null) {
            urlBuilder = urlBuilder2;
        } else {
            urlBuilder = new UrlBuilder();
            swaggerMethodParser.setSchemeAndHost(objectArray, urlBuilder, this.serializer);
            if (string != null && !string.isEmpty() && !"/".equals(string)) {
                object = urlBuilder.getPath();
                if (object == null || ((String)object).isEmpty() || "/".equals(object) || string.contains("://")) {
                    urlBuilder.setPath(string);
                } else if (string.startsWith("/")) {
                    urlBuilder.setPath((String)object + string);
                } else {
                    urlBuilder.setPath((String)object + "/" + string);
                }
            }
        }
        swaggerMethodParser.setEncodedQueryParameters(objectArray, urlBuilder, this.serializer);
        object = urlBuilder.toUrl();
        HttpRequest httpRequest = this.configRequest(new HttpRequest(swaggerMethodParser.getHttpMethod(), (URL)object), swaggerMethodParser, serializerAdapter, bl2, objectArray);
        HttpHeaders httpHeaders = httpRequest.getHeaders();
        swaggerMethodParser.setHeaders(objectArray, httpHeaders, this.serializer);
        return httpRequest;
    }

    private HttpRequest configRequest(HttpRequest httpRequest, SwaggerMethodParser swaggerMethodParser, SerializerAdapter serializerAdapter, boolean bl2, Object[] objectArray) throws IOException {
        Object object = swaggerMethodParser.setBody(objectArray, this.serializer);
        if (object == null) {
            httpRequest.setHeader(HttpHeaderName.CONTENT_LENGTH, "0");
        } else {
            String[] stringArray;
            String string = swaggerMethodParser.getBodyContentType();
            if (string == null || string.isEmpty()) {
                string = object instanceof byte[] || object instanceof String ? "application/octet-stream" : "application/json";
            }
            httpRequest.setHeader(HttpHeaderName.CONTENT_TYPE, string);
            if (object instanceof BinaryData) {
                BinaryData binaryData = (BinaryData)object;
                if (binaryData.getLength() != null) {
                    httpRequest.setHeader(HttpHeaderName.CONTENT_LENGTH, binaryData.getLength().toString());
                }
                httpRequest.setBody(binaryData);
                return httpRequest;
            }
            boolean bl3 = false;
            for (String string2 : stringArray = string.split(";")) {
                if (!string2.trim().equalsIgnoreCase("application/json")) continue;
                bl3 = true;
                break;
            }
            this.updateRequest(new RequestDataConfiguration(httpRequest, swaggerMethodParser, bl3, object), serializerAdapter);
        }
        return httpRequest;
    }

    public static HttpResponseException instantiateUnexpectedException(UnexpectedExceptionInformation unexpectedExceptionInformation, HttpResponse httpResponse, byte[] byArray, Object object) {
        Class<? extends HttpResponseException> clazz;
        StringBuilder stringBuilder = new StringBuilder("Status code ").append(httpResponse.getStatusCode()).append(", ");
        String string = httpResponse.getHeaderValue(HttpHeaderName.CONTENT_TYPE);
        if ("application/octet-stream".equalsIgnoreCase(string)) {
            clazz = httpResponse.getHeaderValue(HttpHeaderName.CONTENT_LENGTH);
            stringBuilder.append("(").append((String)((Object)clazz)).append("-byte body)");
        } else if (byArray == null || byArray.length == 0) {
            stringBuilder.append("(empty body)");
        } else {
            stringBuilder.append('\"').append(new String(byArray, StandardCharsets.UTF_8)).append('\"');
        }
        if (object instanceof IOException || object instanceof MalformedValueException || object instanceof IllegalStateException) {
            return new HttpResponseException(stringBuilder.toString(), httpResponse, (Throwable)object);
        }
        clazz = unexpectedExceptionInformation.getExceptionType();
        if (clazz == HttpResponseException.class) {
            return new HttpResponseException(stringBuilder.toString(), httpResponse, object);
        }
        if (clazz == ClientAuthenticationException.class) {
            return new ClientAuthenticationException(stringBuilder.toString(), httpResponse, object);
        }
        if (clazz == DecodeException.class) {
            return new DecodeException(stringBuilder.toString(), httpResponse, object);
        }
        if (clazz == ResourceExistsException.class) {
            return new ResourceExistsException(stringBuilder.toString(), httpResponse, object);
        }
        if (clazz == ResourceModifiedException.class) {
            return new ResourceModifiedException(stringBuilder.toString(), httpResponse, object);
        }
        if (clazz == ResourceNotFoundException.class) {
            return new ResourceNotFoundException(stringBuilder.toString(), httpResponse, object);
        }
        if (clazz == TooManyRedirectsException.class) {
            return new TooManyRedirectsException(stringBuilder.toString(), httpResponse, object);
        }
        try {
            ReflectiveInvoker reflectiveInvoker = RESPONSE_EXCEPTION_CONSTRUCTOR_CACHE.get(clazz, unexpectedExceptionInformation.getExceptionBodyType());
            return ResponseExceptionConstructorCache.invoke(reflectiveInvoker, stringBuilder.toString(), httpResponse, object);
        }
        catch (RuntimeException runtimeException) {
            stringBuilder.append(". An instance of ").append(clazz.getCanonicalName()).append(" couldn't be created.");
            HttpResponseException httpResponseException = new HttpResponseException(stringBuilder.toString(), httpResponse, object);
            httpResponseException.addSuppressed(runtimeException);
            return httpResponseException;
        }
    }
}

