/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaders;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.Response;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectionUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectiveInvoker;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.serializer.HttpResponseDecoder;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public final class ResponseConstructorsCache {
    private static final String THREE_PARAM_ERROR = "Failed to deserialize 3-parameter response.";
    private static final String FOUR_PARAM_ERROR = "Failed to deserialize 4-parameter response.";
    private static final String FIVE_PARAM_ERROR = "Failed to deserialize 5-parameter response.";
    private static final String INVALID_PARAM_COUNT = "Response constructor with expected parameters not found.";
    private static final Map<Class<?>, ReflectiveInvoker> CACHE = new ConcurrentHashMap();
    private static final ClientLogger LOGGER = new ClientLogger(ResponseConstructorsCache.class);

    public ReflectiveInvoker get(Class<? extends Response<?>> clazz) {
        return CACHE.computeIfAbsent(clazz, ResponseConstructorsCache::locateResponseConstructor);
    }

    private static ReflectiveInvoker locateResponseConstructor(Class<?> clazz) {
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        Arrays.sort(constructorArray, Comparator.comparing(Constructor::getParameterCount, (n2, n3) -> n3 - n2));
        for (Constructor<?> constructor : constructorArray) {
            int n4 = constructor.getParameterCount();
            if (n4 < 3 || n4 > 5) continue;
            try {
                return ReflectionUtils.getConstructorInvoker(clazz, constructor);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw LOGGER.logExceptionAsError((RuntimeException)exception);
                }
                throw LOGGER.logExceptionAsError(new RuntimeException(exception));
            }
        }
        throw LOGGER.logExceptionAsError(new RuntimeException("Cannot find suitable constructor for class " + clazz));
    }

    public Response<?> invoke(ReflectiveInvoker reflectiveInvoker, HttpResponseDecoder.HttpDecodedResponse httpDecodedResponse, Object object) {
        HttpResponse httpResponse = httpDecodedResponse.getSourceResponse();
        HttpRequest httpRequest = httpResponse.getRequest();
        int n2 = httpResponse.getStatusCode();
        HttpHeaders httpHeaders = httpResponse.getHeaders();
        int n3 = reflectiveInvoker.getParameterCount();
        switch (n3) {
            case 3: {
                return ResponseConstructorsCache.constructResponse(reflectiveInvoker, THREE_PARAM_ERROR, httpRequest, n2, httpHeaders);
            }
            case 4: {
                return ResponseConstructorsCache.constructResponse(reflectiveInvoker, FOUR_PARAM_ERROR, httpRequest, n2, httpHeaders, object);
            }
            case 5: {
                return ResponseConstructorsCache.constructResponse(reflectiveInvoker, FIVE_PARAM_ERROR, httpRequest, n2, httpHeaders, object, httpDecodedResponse.getDecodedHeaders());
            }
        }
        throw LOGGER.logExceptionAsError(new IllegalStateException(INVALID_PARAM_COUNT));
    }

    private static Response<?> constructResponse(ReflectiveInvoker reflectiveInvoker, String string, Object ... objectArray) {
        try {
            return (Response)reflectiveInvoker.invokeStatic(objectArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)exception);
            }
            throw LOGGER.logExceptionAsError(new IllegalStateException(string, exception));
        }
    }
}

