/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest;

import java.util.Arrays;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public final class PercentEscaper {
    private static final char[] HEX_CHARACTERS = "0123456789ABCDEF".toCharArray();
    private static final boolean[] SAFE_CHARACTERS = new boolean[256];
    private static final ClientLogger LOGGER;
    private final boolean usePlusForSpace;
    private final boolean[] safeCharacterPoints;

    public PercentEscaper(String string, boolean bl2) {
        this.usePlusForSpace = bl2;
        if (bl2 && string != null && string.contains(" ")) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("' ' as a safe character with 'usePlusForSpace = true' is an invalid configuration."));
        }
        this.safeCharacterPoints = Arrays.copyOf(SAFE_CHARACTERS, 256);
        if (!CoreUtils.isNullOrEmpty(string)) {
            string.codePoints().forEach(n2 -> {
                this.safeCharacterPoints[n2] = true;
            });
        }
    }

    public String escape(String string) {
        if (CoreUtils.isNullOrEmpty(string)) {
            return string;
        }
        StringBuilder stringBuilder = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        char[] cArray = new char[12];
        while (n3 < n4) {
            int n5 = PercentEscaper.getCodePoint(string, n3, n4);
            int n6 = n3++;
            if (n5 < 256 && this.safeCharacterPoints[n5]) continue;
            n3 += Character.isSupplementaryCodePoint(n5) ? 2 : 1;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder((int)Math.ceil((double)string.length() * 1.5));
            }
            stringBuilder.append(string, n2, n6);
            n2 = n3;
            if (this.usePlusForSpace && n5 == 32) {
                stringBuilder.append('+');
                continue;
            }
            if (n5 <= 127) {
                stringBuilder.append('%');
                stringBuilder.append(HEX_CHARACTERS[n5 >>> 4]);
                stringBuilder.append(HEX_CHARACTERS[n5 & 0xF]);
                continue;
            }
            if (n5 <= 2047) {
                cArray[0] = 37;
                cArray[3] = 37;
                cArray[5] = HEX_CHARACTERS[n5 & 0xF];
                cArray[4] = HEX_CHARACTERS[8 | (n5 >>>= 4) & 3];
                cArray[2] = HEX_CHARACTERS[(n5 >>>= 2) & 0xF];
                cArray[1] = HEX_CHARACTERS[(n5 >>>= 4) | 0xC];
                stringBuilder.append(cArray, 0, 6);
                continue;
            }
            if (n5 <= 65535) {
                cArray[0] = 37;
                cArray[1] = 69;
                cArray[3] = 37;
                cArray[6] = 37;
                cArray[8] = HEX_CHARACTERS[n5 & 0xF];
                cArray[7] = HEX_CHARACTERS[8 | (n5 >>>= 4) & 3];
                cArray[5] = HEX_CHARACTERS[(n5 >>>= 2) & 0xF];
                cArray[4] = HEX_CHARACTERS[8 | (n5 >>>= 4) & 3];
                cArray[2] = HEX_CHARACTERS[(n5 >>>= 2) & 0xF];
                stringBuilder.append(cArray, 0, 9);
                continue;
            }
            if (n5 > 0x10FFFF) continue;
            cArray[0] = 37;
            cArray[1] = 70;
            cArray[3] = 37;
            cArray[6] = 37;
            cArray[9] = 37;
            cArray[11] = HEX_CHARACTERS[n5 & 0xF];
            cArray[10] = HEX_CHARACTERS[8 | (n5 >>>= 4) & 3];
            cArray[8] = HEX_CHARACTERS[(n5 >>>= 2) & 0xF];
            cArray[7] = HEX_CHARACTERS[8 | (n5 >>>= 4) & 3];
            cArray[5] = HEX_CHARACTERS[(n5 >>>= 2) & 0xF];
            cArray[4] = HEX_CHARACTERS[8 | (n5 >>>= 4) & 3];
            cArray[2] = HEX_CHARACTERS[(n5 >>>= 2) & 7];
            stringBuilder.append(cArray);
        }
        if (stringBuilder == null) {
            return string;
        }
        if (n2 < n4) {
            stringBuilder.append(string, n2, n4);
        }
        return stringBuilder.toString();
    }

    private static int getCodePoint(String string, int n2, int n3) {
        char c2;
        if (!Character.isSurrogate(c2 = string.charAt(n2++))) {
            return c2;
        }
        if (Character.isHighSurrogate(c2)) {
            if (n2 == n3) {
                throw LOGGER.logExceptionAsError(new IllegalStateException("String contains trailing high surrogate without paired low surrogate."));
            }
            char c3 = string.charAt(n2);
            if (Character.isLowSurrogate(c3)) {
                return Character.toCodePoint(c2, c3);
            }
            throw LOGGER.logExceptionAsError(new IllegalStateException("String contains high surrogate without trailing low surrogate."));
        }
        throw LOGGER.logExceptionAsError(new IllegalStateException("String contains low surrogate without leading high surrogate."));
    }

    static {
        Arrays.fill(SAFE_CHARACTERS, 97, 123, true);
        Arrays.fill(SAFE_CHARACTERS, 65, 91, true);
        Arrays.fill(SAFE_CHARACTERS, 48, 58, true);
        LOGGER = new ClientLogger(PercentEscaper.class);
    }
}

