/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest;

import com.azure.xml.XmlSerializable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.function.Consumer;
import java.util.function.Function;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaderName;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpMethod;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipeline;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.RequestOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.Response;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.StreamResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectionSerializable;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.TypeUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.ErrorOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.RequestDataConfiguration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.RestProxyBase;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.RestProxyUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.SwaggerInterfaceParser;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.SwaggerMethodParser;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.serializer.HttpResponseDecoder;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Base64Url;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.BinaryData;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.FluxUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.SerializerAdapter;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.SerializerEncoding;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonSerializable;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Flux;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;
import macromedia.jdbc.sqlserver.externals.reactor.core.scheduler.Schedulers;
import macromedia.jdbc.sqlserver.externals.reactor.util.context.Context;
import macromedia.jdbc.sqlserver.externals.reactor.util.context.ContextView;

public class AsyncRestProxy
extends RestProxyBase {
    private static final String TEXT_EVENT_STREAM = "text/event-stream";

    public AsyncRestProxy(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, SwaggerInterfaceParser swaggerInterfaceParser) {
        super(httpPipeline, serializerAdapter, swaggerInterfaceParser);
    }

    Mono<HttpResponse> send(HttpRequest httpRequest, macromedia.jdbc.sqlserver.externals.com.azure.core.util.Context context) {
        return this.httpPipeline.send(httpRequest, context);
    }

    @Override
    public Object invoke(Object object, Method method, RequestOptions requestOptions, EnumSet<ErrorOptions> enumSet, Consumer<HttpRequest> consumer, SwaggerMethodParser swaggerMethodParser, HttpRequest httpRequest2, macromedia.jdbc.sqlserver.externals.com.azure.core.util.Context context) {
        context = this.startTracingSpan(swaggerMethodParser, context);
        if (requestOptions != null && consumer != null) {
            consumer.accept(httpRequest2);
        }
        macromedia.jdbc.sqlserver.externals.com.azure.core.util.Context context2 = context;
        Mono mono = RestProxyUtils.validateLengthAsync(httpRequest2).flatMap(httpRequest -> {
            Mono<HttpResponse> mono;
            block8: {
                AutoCloseable autoCloseable = this.tracer.makeSpanCurrent(context2);
                try {
                    mono = this.send((HttpRequest)httpRequest, context2);
                    if (autoCloseable == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (autoCloseable != null) {
                            try {
                                autoCloseable.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        return Mono.error((Throwable)throwable3);
                    }
                }
                autoCloseable.close();
            }
            return mono;
        });
        Mono<HttpResponseDecoder.HttpDecodedResponse> mono2 = this.decoder.decode((Mono<HttpResponse>)mono, swaggerMethodParser);
        return this.handleRestReturnType(mono2, swaggerMethodParser, swaggerMethodParser.getReturnType(), context, requestOptions, enumSet);
    }

    private Mono<HttpResponseDecoder.HttpDecodedResponse> ensureExpectedStatus(Mono<HttpResponseDecoder.HttpDecodedResponse> mono, SwaggerMethodParser swaggerMethodParser, RequestOptions requestOptions, EnumSet<ErrorOptions> enumSet) {
        return mono.flatMap(httpDecodedResponse -> {
            int n2 = httpDecodedResponse.getSourceResponse().getStatusCode();
            if (swaggerMethodParser.isExpectedResponseStatusCode(n2) || requestOptions != null && enumSet.contains((Object)ErrorOptions.NO_THROW)) {
                return Mono.just((Object)httpDecodedResponse);
            }
            return httpDecodedResponse.getSourceResponse().getBodyAsByteArray().map(byArray -> AsyncRestProxy.instantiateUnexpectedException(swaggerMethodParser.getUnexpectedException(n2), httpDecodedResponse.getSourceResponse(), byArray, httpDecodedResponse.getDecodedBody((byte[])byArray))).switchIfEmpty(Mono.fromSupplier(() -> AsyncRestProxy.instantiateUnexpectedException(swaggerMethodParser.getUnexpectedException(n2), httpDecodedResponse.getSourceResponse(), null, null))).flatMap(Mono::error);
        });
    }

    private Mono<?> handleRestResponseReturnType(HttpResponseDecoder.HttpDecodedResponse httpDecodedResponse, SwaggerMethodParser swaggerMethodParser, Type type) {
        if (swaggerMethodParser.isStreamResponse()) {
            return Mono.fromSupplier(() -> new StreamResponse(httpDecodedResponse.getSourceResponse()));
        }
        if (TypeUtil.isTypeOrSubTypeOf(type, Response.class)) {
            Type type2 = TypeUtil.getRestResponseBodyType(type);
            if (TypeUtil.isTypeOrSubTypeOf(type2, Void.class)) {
                return httpDecodedResponse.getSourceResponse().getBody().ignoreElements().then(Mono.fromCallable(() -> this.createResponse(httpDecodedResponse, type, null)));
            }
            return AsyncRestProxy.handleBodyReturnType(httpDecodedResponse.getSourceResponse(), AsyncRestProxy.decodeBytes(httpDecodedResponse), swaggerMethodParser, type2).map(object -> this.createResponse(httpDecodedResponse, type, object)).switchIfEmpty(Mono.fromCallable(() -> this.createResponse(httpDecodedResponse, type, null)));
        }
        return AsyncRestProxy.handleBodyReturnType(httpDecodedResponse.getSourceResponse(), AsyncRestProxy.decodeBytes(httpDecodedResponse), swaggerMethodParser, type);
    }

    private static Function<byte[], Mono<Object>> decodeBytes(HttpResponseDecoder.HttpDecodedResponse httpDecodedResponse) {
        return byArray -> Mono.fromCallable(() -> httpDecodedResponse.getDecodedBody((byte[])byArray)).publishOn(Schedulers.boundedElastic()).handle((object, synchronousSink) -> {
            if (object == null) {
                synchronousSink.complete();
            } else {
                synchronousSink.next(object);
                synchronousSink.complete();
            }
        });
    }

    static Mono<?> handleBodyReturnType(HttpResponse httpResponse, Function<byte[], Mono<Object>> function, SwaggerMethodParser swaggerMethodParser, Type type) {
        Mono<BinaryData> mono;
        int n2 = httpResponse.getStatusCode();
        HttpMethod httpMethod = swaggerMethodParser.getHttpMethod();
        Type type2 = swaggerMethodParser.getReturnValueWireType();
        if (httpMethod == HttpMethod.HEAD && (TypeUtil.isTypeOrSubTypeOf(type, Boolean.TYPE) || TypeUtil.isTypeOrSubTypeOf(type, Boolean.class))) {
            boolean bl2 = n2 / 100 == 2;
            mono = Mono.just((Object)bl2);
        } else if (TypeUtil.isTypeOrSubTypeOf(type, byte[].class)) {
            Mono<BinaryData> mono2 = httpResponse.getBodyAsByteArray();
            if (type2 == Base64Url.class) {
                mono2 = mono2.mapNotNull(byArray -> new Base64Url((byte[])byArray).decodedBytes());
            }
            mono = mono2;
        } else {
            String string;
            mono = FluxUtil.isFluxByteBuffer(type) ? Mono.just(httpResponse.getBody()) : (TypeUtil.isTypeOrSubTypeOf(type, BinaryData.class) ? ((string = httpResponse.getHeaders().getValue(HttpHeaderName.CONTENT_TYPE)) != null && string.startsWith(TEXT_EVENT_STREAM) ? BinaryData.fromFlux(httpResponse.getBody(), null, false) : BinaryData.fromFlux(httpResponse.getBody())) : (TypeUtil.isTypeOrSubTypeOf(type, InputStream.class) ? httpResponse.getBodyAsInputStream() : httpResponse.getBodyAsByteArray().flatMap(function)));
        }
        return mono;
    }

    private Object handleRestReturnType(Mono<HttpResponseDecoder.HttpDecodedResponse> mono, SwaggerMethodParser swaggerMethodParser, Type type, macromedia.jdbc.sqlserver.externals.com.azure.core.util.Context context, RequestOptions requestOptions, EnumSet<ErrorOptions> enumSet) {
        Object object;
        Mono<HttpResponseDecoder.HttpDecodedResponse> mono2 = this.endSpanWhenDone(this.ensureExpectedStatus(mono, swaggerMethodParser, requestOptions, enumSet), context);
        if (TypeUtil.isTypeOrSubTypeOf(type, Mono.class)) {
            Type type2 = TypeUtil.getTypeArgument(type);
            object = TypeUtil.isTypeOrSubTypeOf(type2, Void.class) ? mono2.doOnNext(HttpResponseDecoder.HttpDecodedResponse::close).then() : mono2.flatMap(httpDecodedResponse -> this.handleRestResponseReturnType((HttpResponseDecoder.HttpDecodedResponse)httpDecodedResponse, swaggerMethodParser, type2));
        } else if (FluxUtil.isFluxByteBuffer(type)) {
            object = mono2.flatMapMany(httpDecodedResponse -> httpDecodedResponse.getSourceResponse().getBody());
        } else if (TypeUtil.isTypeOrSubTypeOf(type, Void.TYPE) || TypeUtil.isTypeOrSubTypeOf(type, Void.class)) {
            mono2.doOnNext(HttpResponseDecoder.HttpDecodedResponse::close).block();
            object = null;
        } else {
            object = mono2.flatMap(httpDecodedResponse -> this.handleRestResponseReturnType((HttpResponseDecoder.HttpDecodedResponse)httpDecodedResponse, swaggerMethodParser, type)).block();
        }
        return object;
    }

    private Mono<HttpResponseDecoder.HttpDecodedResponse> endSpanWhenDone(Mono<HttpResponseDecoder.HttpDecodedResponse> mono, macromedia.jdbc.sqlserver.externals.com.azure.core.util.Context context) {
        if (this.isTracingEnabled(context)) {
            return mono.doOnEach(signal -> {
                if (signal.hasValue()) {
                    int n2 = ((HttpResponseDecoder.HttpDecodedResponse)signal.get()).getSourceResponse().getStatusCode();
                    this.tracer.end(n2 >= 400 ? String.valueOf(n2) : null, null, context);
                } else if (signal.isOnError()) {
                    this.tracer.end(null, signal.getThrowable(), context);
                }
            }).doOnCancel(() -> this.tracer.end("cancelled", null, context)).contextWrite((ContextView)Context.of((Object)"trace-context", (Object)context));
        }
        return mono;
    }

    @Override
    public void updateRequest(RequestDataConfiguration requestDataConfiguration, SerializerAdapter serializerAdapter) throws IOException {
        boolean bl2 = requestDataConfiguration.isJson();
        HttpRequest httpRequest = requestDataConfiguration.getHttpRequest();
        Object object = requestDataConfiguration.getBodyContent();
        SwaggerMethodParser swaggerMethodParser = requestDataConfiguration.getMethodParser();
        if (object == null) {
            return;
        }
        if (ReflectionSerializable.supportsJsonSerializable(object.getClass())) {
            httpRequest.setBody(ReflectionSerializable.serializeJsonSerializableToBytes((JsonSerializable)object));
            return;
        }
        if (ReflectionSerializable.supportsXmlSerializable(object.getClass())) {
            httpRequest.setBody(ReflectionSerializable.serializeXmlSerializableToBytes((XmlSerializable)object));
            return;
        }
        if (bl2) {
            httpRequest.setBody(serializerAdapter.serializeToBytes(object, SerializerEncoding.JSON));
        } else if (FluxUtil.isFluxByteBuffer(swaggerMethodParser.getBodyJavaType())) {
            httpRequest.setBody((Flux<ByteBuffer>)((Flux)object));
        } else if (object instanceof byte[]) {
            httpRequest.setBody((byte[])object);
        } else if (object instanceof String) {
            String string = (String)object;
            if (!string.isEmpty()) {
                httpRequest.setBody(string);
            }
        } else if (object instanceof ByteBuffer) {
            httpRequest.setBody(BinaryData.fromByteBuffer((ByteBuffer)object));
        } else {
            httpRequest.setBody(serializerAdapter.serializeToBytes(object, SerializerEncoding.fromHeaders(httpRequest.getHeaders())));
        }
    }
}

