/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaderName;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaders;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.IterableOfByteBuffersInputStream;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.BinaryData;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.FluxUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Flux;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public final class BufferedHttpResponse
extends HttpResponse {
    private static final ClientLogger LOGGER = new ClientLogger(BufferedHttpResponse.class);
    private final HttpResponse innerHttpResponse;
    private final Mono<List<ByteBuffer>> cachedBody;
    private final AtomicLong cachedBodySize = new AtomicLong();

    public BufferedHttpResponse(HttpResponse httpResponse) {
        super(httpResponse.getRequest());
        this.innerHttpResponse = httpResponse;
        this.cachedBody = httpResponse.getBody().map(byteBuffer -> {
            this.cachedBodySize.addAndGet(byteBuffer.remaining());
            return ByteBuffer.wrap(FluxUtil.byteBufferToArray(byteBuffer));
        }).collectList().cache();
    }

    @Override
    public int getStatusCode() {
        return this.innerHttpResponse.getStatusCode();
    }

    @Override
    @Deprecated
    public String getHeaderValue(String string) {
        return this.innerHttpResponse.getHeaderValue(string);
    }

    @Override
    public String getHeaderValue(HttpHeaderName httpHeaderName) {
        return this.innerHttpResponse.getHeaderValue(httpHeaderName);
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.innerHttpResponse.getHeaders();
    }

    @Override
    public Flux<ByteBuffer> getBody() {
        return this.cachedBody.flatMapMany(Flux::fromIterable).map(ByteBuffer::duplicate);
    }

    @Override
    public Mono<byte[]> getBodyAsByteArray() {
        return this.cachedBodySize.get() > Integer.MAX_VALUE ? FluxUtil.monoError(LOGGER, (RuntimeException)new IllegalStateException("Response with body size " + this.cachedBodySize.get() + " doesn't fit into a byte array.")) : FluxUtil.collectBytesInByteBufferStream(this.getBody(), (int)this.cachedBodySize.get());
    }

    @Override
    public Mono<String> getBodyAsString() {
        return this.cachedBodySize.get() > Integer.MAX_VALUE ? FluxUtil.monoError(LOGGER, (RuntimeException)new IllegalStateException("Response with body size " + this.cachedBodySize.get() + " doesn't fit into a String.")) : this.getBodyAsByteArray().map(byArray -> CoreUtils.bomAwareToString(byArray, this.innerHttpResponse.getHeaderValue(HttpHeaderName.CONTENT_TYPE)));
    }

    @Override
    public Mono<String> getBodyAsString(Charset charset) {
        return this.cachedBodySize.get() > Integer.MAX_VALUE ? FluxUtil.monoError(LOGGER, (RuntimeException)new IllegalStateException("Response with body size " + this.cachedBodySize.get() + " doesn't fit into a String.")) : this.getBodyAsByteArray().map(byArray -> new String((byte[])byArray, charset));
    }

    @Override
    public BinaryData getBodyAsBinaryData() {
        return (BinaryData)BinaryData.fromFlux(this.getBody(), this.cachedBodySize.get(), false).block();
    }

    @Override
    public Mono<InputStream> getBodyAsInputStream() {
        return this.getBody().collectList().map(IterableOfByteBuffersInputStream::new);
    }

    @Override
    public Mono<Void> writeBodyToAsync(AsynchronousByteChannel asynchronousByteChannel) {
        return FluxUtil.writeToAsynchronousByteChannel(this.getBody(), asynchronousByteChannel);
    }

    @Override
    public void writeBodyTo(WritableByteChannel writableByteChannel) throws IOException {
        FluxUtil.writeToWritableByteChannel(this.getBody(), writableByteChannel).block();
    }

    @Override
    public BufferedHttpResponse buffer() {
        return this;
    }
}

