/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class TypeUtil {
    private static final Map<Type, Type> SUPER_TYPE_MAP = new ConcurrentHashMap<Type, Type>();

    public static List<Class<?>> getAllClasses(Class<?> clazz) {
        ArrayList arrayList = new ArrayList();
        while (clazz != null) {
            arrayList.add(clazz);
            clazz = clazz.getSuperclass();
        }
        return arrayList;
    }

    public static Type[] getTypeArguments(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return new Type[0];
        }
        return ((ParameterizedType)type).getActualTypeArguments();
    }

    public static Type getTypeArgument(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        return ((ParameterizedType)type).getActualTypeArguments()[0];
    }

    public static Class<?> getRawClass(Type type) {
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return (Class)type;
    }

    public static Type getSuperType(Type type) {
        Type type3 = SUPER_TYPE_MAP.get(type);
        if (type3 != null) {
            return type3;
        }
        return SUPER_TYPE_MAP.computeIfAbsent(type, type2 -> {
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type type3 = ((Class)parameterizedType.getRawType()).getGenericSuperclass();
                if (type3 instanceof ParameterizedType) {
                    Type[] typeArray = TypeUtil.getTypeArguments(type3);
                    TypeVariable<?>[] typeVariableArray = ((GenericDeclaration)((Object)parameterizedType.getRawType())).getTypeParameters();
                    int n2 = 0;
                    block0: for (int i2 = 0; i2 != typeArray.length; ++i2) {
                        int n3 = 0;
                        while (i2 < typeVariableArray.length) {
                            if (typeVariableArray[n3].equals(typeArray[i2])) {
                                typeArray[i2] = parameterizedType.getActualTypeArguments()[n2++];
                                continue block0;
                            }
                            ++n3;
                        }
                    }
                    return TypeUtil.createParameterizedType(((ParameterizedType)type3).getRawType(), typeArray);
                }
                return type3;
            }
            return ((Class)type).getGenericSuperclass();
        });
    }

    public static boolean typeImplementsInterface(Type type, Class<?> clazz) {
        if (TypeUtil.getRawClass(type) == clazz) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtil.typeImplementsInterface(((ParameterizedType)type).getRawType(), clazz);
        }
        Class clazz3 = (Class)type;
        return Arrays.stream(clazz3.getInterfaces()).anyMatch(clazz2 -> clazz2 == clazz);
    }

    public static Type getSuperType(Type type, Class<?> clazz) {
        while (type != null && TypeUtil.getRawClass(type) != clazz) {
            type = TypeUtil.getSuperType(type);
        }
        return type;
    }

    public static boolean isTypeOrSubTypeOf(Type type, Type type2) {
        return TypeUtil.getRawClass(type2).isAssignableFrom(TypeUtil.getRawClass(type));
    }

    public static ParameterizedType createParameterizedType(final Type type, final Type ... typeArray) {
        return new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return typeArray;
            }

            @Override
            public Type getRawType() {
                return type;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        };
    }

    public static Type getRestResponseBodyType(Type type) {
        Type[] typeArray = TypeUtil.getTypeArguments(type);
        if (typeArray != null && typeArray.length > 0) {
            return typeArray[typeArray.length - 1];
        }
        return TypeUtil.getRestResponseBodyType(TypeUtil.getSuperType(type));
    }

    private TypeUtil() {
    }
}

