/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation;

import java.nio.ByteBuffer;
import java.util.Arrays;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public final class ByteBufferCollector {
    private static final int DEFAULT_INITIAL_SIZE = 1024;
    private static final String INVALID_INITIAL_SIZE = "'initialSize' cannot be less than 0.";
    private static final String REQUESTED_BUFFER_INVALID = "Required capacity is greater than Integer.MAX_VALUE.";
    private static final ClientLogger LOGGER = new ClientLogger(ByteBufferCollector.class);
    private byte[] buffer;
    private int position;

    public ByteBufferCollector() {
        this(1024);
    }

    public ByteBufferCollector(int n2) {
        if (n2 < 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(INVALID_INITIAL_SIZE));
        }
        this.buffer = new byte[n2];
        this.position = 0;
    }

    public void write(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return;
        }
        int n2 = byteBuffer.remaining();
        if (n2 == 0) {
            return;
        }
        this.ensureCapacity(n2);
        byteBuffer.get(this.buffer, this.position, n2);
        this.position += n2;
    }

    public byte[] toByteArray() {
        if (this.buffer.length == this.position) {
            return this.buffer;
        }
        return Arrays.copyOf(this.buffer, this.position);
    }

    private void ensureCapacity(int n2) {
        int n3 = this.buffer.length;
        int n4 = this.position + n2;
        if (((this.position ^ n4) & (n2 ^ n4)) < 0) {
            throw LOGGER.logExceptionAsError(new IllegalStateException(REQUESTED_BUFFER_INVALID));
        }
        if (n3 >= n4) {
            return;
        }
        int n5 = n3 << 1;
        if (n5 - n4 < 0) {
            n5 = n4;
        }
        if (n5 < 0) {
            n5 = 0x7FFFFFF7;
        }
        this.buffer = Arrays.copyOf(this.buffer, n5);
    }
}

