/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.ReadPendingException;
import java.nio.channels.WritePendingException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public class AsynchronousFileChannelAdapter
implements AsynchronousByteChannel {
    private static final ClientLogger LOGGER = new ClientLogger(AsynchronousFileChannelAdapter.class);
    private final AsynchronousFileChannel fileChannel;
    private static final AtomicLongFieldUpdater<AsynchronousFileChannelAdapter> POSITION_ATOMIC_UPDATER = AtomicLongFieldUpdater.newUpdater(AsynchronousFileChannelAdapter.class, "position");
    private volatile long position;
    private static final AtomicReferenceFieldUpdater<AsynchronousFileChannelAdapter, Operation> PENDING_OPERATION_ATOMIC_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AsynchronousFileChannelAdapter.class, Operation.class, "pendingOperation");
    private volatile Operation pendingOperation = null;

    public AsynchronousFileChannelAdapter(AsynchronousFileChannel asynchronousFileChannel, long l2) {
        this.fileChannel = Objects.requireNonNull(asynchronousFileChannel);
        this.position = l2;
    }

    @Override
    public <A> void read(ByteBuffer byteBuffer, A a2, CompletionHandler<Integer, ? super A> completionHandler) {
        this.beginOperation(Operation.READ);
        this.fileChannel.read(byteBuffer, POSITION_ATOMIC_UPDATER.get(this), a2, new DelegatingCompletionHandler(completionHandler, Operation.READ));
    }

    @Override
    public Future<Integer> read(ByteBuffer byteBuffer) {
        this.beginOperation(Operation.READ);
        CompletableFuture<Integer> completableFuture = new CompletableFuture<Integer>();
        this.fileChannel.read(byteBuffer, POSITION_ATOMIC_UPDATER.get(this), byteBuffer, new DelegatingCompletionHandler(completableFuture, Operation.READ));
        return completableFuture;
    }

    @Override
    public <A> void write(ByteBuffer byteBuffer, A a2, CompletionHandler<Integer, ? super A> completionHandler) {
        this.beginOperation(Operation.WRITE);
        this.fileChannel.write(byteBuffer, POSITION_ATOMIC_UPDATER.get(this), a2, new DelegatingCompletionHandler(completionHandler, Operation.WRITE));
    }

    @Override
    public Future<Integer> write(ByteBuffer byteBuffer) {
        this.beginOperation(Operation.WRITE);
        CompletableFuture<Integer> completableFuture = new CompletableFuture<Integer>();
        this.fileChannel.write(byteBuffer, POSITION_ATOMIC_UPDATER.get(this), byteBuffer, new DelegatingCompletionHandler(completableFuture, Operation.WRITE));
        return completableFuture;
    }

    @Override
    public boolean isOpen() {
        return this.fileChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.fileChannel.close();
    }

    private void beginOperation(Operation operation) {
        if (!PENDING_OPERATION_ATOMIC_UPDATER.compareAndSet(this, null, operation)) {
            switch (PENDING_OPERATION_ATOMIC_UPDATER.get(this)) {
                case READ: {
                    throw LOGGER.logExceptionAsError(new ReadPendingException());
                }
                case WRITE: {
                    throw LOGGER.logExceptionAsError(new WritePendingException());
                }
            }
            throw LOGGER.logExceptionAsError(new IllegalStateException("Unknown channel operation"));
        }
    }

    private void endOperation(Operation operation) {
        if (!PENDING_OPERATION_ATOMIC_UPDATER.compareAndSet(this, operation, null)) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("There's no pending " + (Object)((Object)operation)));
        }
    }

    private static enum Operation {
        READ,
        WRITE;

    }

    private final class DelegatingCompletionHandler<T>
    implements CompletionHandler<Integer, T> {
        private final CompletionHandler<Integer, ? super T> handler;
        private final CompletableFuture<Integer> future;
        private final Operation operation;

        private DelegatingCompletionHandler(CompletionHandler<Integer, ? super T> completionHandler, Operation operation) {
            this.handler = completionHandler;
            this.future = null;
            this.operation = operation;
        }

        private DelegatingCompletionHandler(CompletableFuture<Integer> completableFuture, Operation operation) {
            this.handler = null;
            this.future = completableFuture;
            this.operation = operation;
        }

        @Override
        public void completed(Integer n2, T t2) {
            if (n2 > 0) {
                POSITION_ATOMIC_UPDATER.addAndGet(AsynchronousFileChannelAdapter.this, n2.intValue());
            }
            AsynchronousFileChannelAdapter.this.endOperation(this.operation);
            if (this.handler != null) {
                this.handler.completed(n2, t2);
            } else if (this.future != null) {
                this.future.complete(n2);
            }
        }

        @Override
        public void failed(Throwable throwable, T t2) {
            AsynchronousFileChannelAdapter.this.endOperation(this.operation);
            if (this.handler != null) {
                this.handler.failed(throwable, t2);
            } else if (this.future != null) {
                this.future.completeExceptionally(throwable);
            }
        }
    }
}

