/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation;

import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.util.concurrent.ExecutionException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.org.reactivestreams.Subscriber;
import macromedia.jdbc.sqlserver.externals.org.reactivestreams.Subscription;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.MonoSink;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Operators;
import macromedia.jdbc.sqlserver.externals.reactor.util.context.Context;
import macromedia.jdbc.sqlserver.externals.reactor.util.context.ContextView;

public final class AsynchronousByteChannelWriteSubscriber
implements Subscriber<ByteBuffer> {
    private static final ClientLogger LOGGER = new ClientLogger(AsynchronousByteChannelWriteSubscriber.class);
    private final AsynchronousByteChannel channel;
    private final MonoSink<Void> emitter;
    private Subscription subscription;
    private boolean done = false;

    public AsynchronousByteChannelWriteSubscriber(AsynchronousByteChannel asynchronousByteChannel, MonoSink<Void> monoSink) {
        this.channel = asynchronousByteChannel;
        this.emitter = monoSink;
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        if (Operators.validate((Subscription)this.subscription, (Subscription)subscription)) {
            this.subscription = subscription;
            subscription.request(1L);
        }
    }

    @Override
    public void onNext(ByteBuffer byteBuffer) {
        if (this.done) {
            Operators.onNextDropped((Object)byteBuffer, (Context)Context.of((ContextView)this.emitter.contextView()));
            return;
        }
        if (!byteBuffer.hasRemaining()) {
            this.subscription.request(1L);
            return;
        }
        this.write(byteBuffer);
        if (!this.done) {
            this.subscription.request(1L);
        }
    }

    private void write(ByteBuffer byteBuffer) {
        try {
            while (byteBuffer.hasRemaining()) {
                this.channel.write(byteBuffer).get();
            }
        }
        catch (Exception exception) {
            if (exception instanceof ExecutionException) {
                this.onError(exception.getCause());
            }
            this.onError(exception);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        if (this.done) {
            Operators.onErrorDropped((Throwable)throwable, (Context)Context.of((ContextView)this.emitter.contextView()));
            return;
        }
        this.done = true;
        this.subscription.cancel();
        this.emitter.error(LOGGER.logThrowableAsError(throwable));
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.emitter.success();
    }
}

