/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy;

import java.net.MalformedURLException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineCallContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineNextPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineNextSyncPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpPipelinePolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpPipelineSyncPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.UrlBuilder;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class PortPolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(PortPolicy.class);
    private final int port;
    private final boolean overwrite;
    private final HttpPipelineSyncPolicy inner = new HttpPipelineSyncPolicy(){

        @Override
        protected void beforeSendingRequest(HttpPipelineCallContext httpPipelineCallContext) {
            UrlBuilder urlBuilder = UrlBuilder.parse(httpPipelineCallContext.getHttpRequest().getUrl());
            if (PortPolicy.this.overwrite || urlBuilder.getPort() == null) {
                LOGGER.atVerbose().addKeyValue("port", PortPolicy.this.port).log("Changing host");
                try {
                    httpPipelineCallContext.getHttpRequest().setUrl(urlBuilder.setPort(PortPolicy.this.port).toUrl());
                }
                catch (MalformedURLException malformedURLException) {
                    throw LOGGER.logExceptionAsError(new RuntimeException("Failed to set the HTTP request port to " + PortPolicy.this.port + ".", malformedURLException));
                }
            }
        }
    };

    public PortPolicy(int n2, boolean bl2) {
        this.port = n2;
        this.overwrite = bl2;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextPolicy httpPipelineNextPolicy) {
        return this.inner.process(httpPipelineCallContext, httpPipelineNextPolicy);
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextSyncPolicy httpPipelineNextSyncPolicy) {
        return this.inner.processSync(httpPipelineCallContext, httpPipelineNextSyncPolicy);
    }
}

