/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy;

import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.KeyCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaderName;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaders;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineCallContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineNextPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineNextSyncPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpPipelinePolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.FluxUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class KeyCredentialPolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(KeyCredentialPolicy.class);
    private final HttpHeaderName name;
    private final KeyCredential credential;
    private final String prefix;

    public KeyCredentialPolicy(String string, KeyCredential keyCredential) {
        this(string, keyCredential, null);
    }

    public KeyCredentialPolicy(String string, KeyCredential keyCredential, String string2) {
        this(KeyCredentialPolicy.validateName(string), Objects.requireNonNull(keyCredential, "'credential' cannot be null."), string2);
    }

    private static HttpHeaderName validateName(String string) {
        Objects.requireNonNull(string, "'name' cannot be null.");
        if (string.isEmpty()) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'name' cannot be empty."));
        }
        return HttpHeaderName.fromString(string);
    }

    KeyCredentialPolicy(HttpHeaderName httpHeaderName, KeyCredential keyCredential, String string) {
        this.name = httpHeaderName;
        this.credential = keyCredential;
        this.prefix = string != null ? string.trim() : null;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextPolicy httpPipelineNextPolicy) {
        if (!"https".equals(httpPipelineCallContext.getHttpRequest().getUrl().getProtocol())) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new IllegalStateException("Key credentials require HTTPS to prevent leaking the key."));
        }
        this.setCredential(httpPipelineCallContext.getHttpRequest().getHeaders());
        return httpPipelineNextPolicy.process();
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextSyncPolicy httpPipelineNextSyncPolicy) {
        if (!"https".equals(httpPipelineCallContext.getHttpRequest().getUrl().getProtocol())) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("Key credentials require HTTPS to prevent leaking the key."));
        }
        this.setCredential(httpPipelineCallContext.getHttpRequest().getHeaders());
        return httpPipelineNextSyncPolicy.processSync();
    }

    void setCredential(HttpHeaders httpHeaders) {
        String string = this.credential.getKey();
        httpHeaders.set(this.name, this.prefix == null ? string : this.prefix + " " + string);
    }
}

