/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaderName;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaders;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineCallContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineNextPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineNextSyncPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpLogDetailLevel;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpLogOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpPipelinePolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpRequestLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpRequestLoggingContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpResponseLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpResponseLoggingContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.AccessibleByteArrayOutputStream;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ImplUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.UrlSanitizer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.ObjectMapperShim;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.BinaryDataContent;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.BinaryDataHelper;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.ByteArrayContent;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.ByteBufferContent;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.HttpHeadersAccessHelper;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.InputStreamContent;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.SerializableContent;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.StringContent;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.BinaryData;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Context;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.FluxUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LoggingEventBuilder;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonNode;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Flux;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class HttpLoggingPolicy
implements HttpPipelinePolicy {
    private static final ObjectMapperShim PRETTY_PRINTER = ObjectMapperShim.createPrettyPrintMapper();
    private static final int MAX_BODY_LOG_SIZE = 16384;
    private static final int LOGGER_CACHE_MAX_SIZE = 1000;
    private static final String CONTENT_LENGTH_KEY = HttpHeaderName.CONTENT_LENGTH.getCaseInsensitiveName();
    private static final Map<String, ClientLogger> CALLER_METHOD_LOGGER_CACHE = new ConcurrentHashMap<String, ClientLogger>();
    private static final ClientLogger LOGGER = new ClientLogger(HttpLoggingPolicy.class);
    private final HttpLogDetailLevel httpLogDetailLevel;
    private final Set<String> allowedHeaderNames;
    private final UrlSanitizer urlSanitizer;
    private final boolean prettyPrintBody;
    private final boolean disableRedactedHeaderLogging;
    private final HttpRequestLogger requestLogger;
    private final HttpResponseLogger responseLogger;
    public static final String RETRY_COUNT_CONTEXT = "requestRetryCount";
    private static final String REQUEST_LOG_MESSAGE = "HTTP request";
    private static final String RESPONSE_LOG_MESSAGE = "HTTP response";

    public HttpLoggingPolicy(HttpLogOptions httpLogOptions) {
        if (httpLogOptions == null) {
            this.httpLogDetailLevel = HttpLogDetailLevel.ENVIRONMENT_HTTP_LOG_DETAIL_LEVEL;
            this.allowedHeaderNames = HttpLogOptions.DEFAULT_HEADERS_ALLOWLIST.stream().map(string -> string.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
            this.urlSanitizer = new UrlSanitizer(null);
            this.prettyPrintBody = false;
            this.disableRedactedHeaderLogging = false;
            this.requestLogger = new DefaultHttpRequestLogger();
            this.responseLogger = new DefaultHttpResponseLogger();
        } else {
            this.httpLogDetailLevel = httpLogOptions.getLogLevel();
            this.allowedHeaderNames = httpLogOptions.getAllowedHeaderNames().stream().map(string -> string.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
            this.urlSanitizer = new UrlSanitizer(httpLogOptions.getAllowedQueryParamNames());
            this.prettyPrintBody = httpLogOptions.isPrettyPrintBody();
            this.disableRedactedHeaderLogging = httpLogOptions.isRedactedHeaderLoggingDisabled();
            this.requestLogger = httpLogOptions.getRequestLogger() == null ? new DefaultHttpRequestLogger() : httpLogOptions.getRequestLogger();
            this.responseLogger = httpLogOptions.getResponseLogger() == null ? new DefaultHttpResponseLogger() : httpLogOptions.getResponseLogger();
        }
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextPolicy httpPipelineNextPolicy) {
        if (this.httpLogDetailLevel == HttpLogDetailLevel.NONE) {
            return httpPipelineNextPolicy.process();
        }
        ClientLogger clientLogger = HttpLoggingPolicy.getOrCreateMethodLogger(httpPipelineCallContext.getContext());
        long l2 = System.nanoTime();
        return this.requestLogger.logRequest(clientLogger, this.getRequestLoggingOptions(httpPipelineCallContext)).then(httpPipelineNextPolicy.process()).flatMap(httpResponse -> this.responseLogger.logResponse(clientLogger, this.getResponseLoggingOptions((HttpResponse)httpResponse, l2, httpPipelineCallContext))).doOnError(throwable -> this.createBasicLoggingContext(clientLogger, LogLevel.WARNING, httpPipelineCallContext.getHttpRequest()).log("HTTP FAILED", throwable));
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextSyncPolicy httpPipelineNextSyncPolicy) {
        if (this.httpLogDetailLevel == HttpLogDetailLevel.NONE) {
            return httpPipelineNextSyncPolicy.processSync();
        }
        ClientLogger clientLogger = HttpLoggingPolicy.getOrCreateMethodLogger(httpPipelineCallContext.getContext());
        long l2 = System.nanoTime();
        this.requestLogger.logRequestSync(clientLogger, this.getRequestLoggingOptions(httpPipelineCallContext));
        try {
            HttpResponse httpResponse = httpPipelineNextSyncPolicy.processSync();
            if (httpResponse != null) {
                httpResponse = this.responseLogger.logResponseSync(clientLogger, this.getResponseLoggingOptions(httpResponse, l2, httpPipelineCallContext));
            }
            return httpResponse;
        }
        catch (RuntimeException runtimeException) {
            this.createBasicLoggingContext(clientLogger, LogLevel.WARNING, httpPipelineCallContext.getHttpRequest()).log("HTTP FAILED", runtimeException);
            throw runtimeException;
        }
    }

    private LoggingEventBuilder createBasicLoggingContext(ClientLogger clientLogger, LogLevel logLevel, HttpRequest httpRequest) {
        LoggingEventBuilder loggingEventBuilder = clientLogger.atLevel(logLevel);
        if (LOGGER.canLogAtLevel(logLevel) && httpRequest != null) {
            String string;
            if (this.allowedHeaderNames.contains(HttpHeaderName.X_MS_CLIENT_REQUEST_ID.getCaseInsensitiveName()) && (string = httpRequest.getHeaders().getValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID)) != null) {
                loggingEventBuilder.addKeyValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID.getCaseInsensitiveName(), string);
            }
            if (this.allowedHeaderNames.contains(HttpHeaderName.TRACEPARENT.getCaseInsensitiveName()) && (string = httpRequest.getHeaders().getValue(HttpHeaderName.TRACEPARENT)) != null) {
                loggingEventBuilder.addKeyValue(HttpHeaderName.TRACEPARENT.getCaseInsensitiveName(), string);
            }
        }
        return loggingEventBuilder;
    }

    private HttpRequestLoggingContext getRequestLoggingOptions(HttpPipelineCallContext httpPipelineCallContext) {
        return new HttpRequestLoggingContext(httpPipelineCallContext.getHttpRequest(), httpPipelineCallContext.getContext(), HttpLoggingPolicy.getRequestRetryCount(httpPipelineCallContext.getContext()));
    }

    private HttpResponseLoggingContext getResponseLoggingOptions(HttpResponse httpResponse, long l2, HttpPipelineCallContext httpPipelineCallContext) {
        return new HttpResponseLoggingContext(httpResponse, Duration.ofNanos(System.nanoTime() - l2), httpPipelineCallContext.getContext(), HttpLoggingPolicy.getRequestRetryCount(httpPipelineCallContext.getContext()));
    }

    private void logBody(HttpRequest httpRequest, int n2, LoggingEventBuilder loggingEventBuilder, ClientLogger clientLogger, String string) {
        BinaryData binaryData = httpRequest.getBodyAsBinaryData();
        BinaryDataContent binaryDataContent = BinaryDataHelper.getContent(binaryData);
        if (binaryDataContent instanceof StringContent || binaryDataContent instanceof ByteBufferContent || binaryDataContent instanceof SerializableContent || binaryDataContent instanceof ByteArrayContent) {
            this.logBody(loggingEventBuilder, clientLogger, string, binaryDataContent.toString());
        } else if (binaryDataContent instanceof InputStreamContent) {
            byte[] byArray = binaryDataContent.toBytes();
            httpRequest.setBody(byArray);
            this.logBody(loggingEventBuilder, clientLogger, string, new String(byArray, StandardCharsets.UTF_8));
        } else {
            AccessibleByteArrayOutputStream accessibleByteArrayOutputStream2 = new AccessibleByteArrayOutputStream(n2);
            httpRequest.setBody((Flux<ByteBuffer>)Flux.using(() -> accessibleByteArrayOutputStream2, accessibleByteArrayOutputStream -> binaryDataContent.toFluxByteBuffer().doOnNext(byteBuffer -> {
                try {
                    ImplUtils.writeByteBufferToStream(byteBuffer.duplicate(), accessibleByteArrayOutputStream);
                }
                catch (IOException iOException) {
                    throw LOGGER.logExceptionAsError(new UncheckedIOException(iOException));
                }
            }), accessibleByteArrayOutputStream -> this.logBody(loggingEventBuilder, clientLogger, string, accessibleByteArrayOutputStream.toString(StandardCharsets.UTF_8))));
        }
    }

    private void logBody(LoggingEventBuilder loggingEventBuilder, ClientLogger clientLogger, String string, String string2) {
        loggingEventBuilder.addKeyValue("body", HttpLoggingPolicy.prettyPrintIfNeeded(clientLogger, this.prettyPrintBody, string, string2)).log(REQUEST_LOG_MESSAGE);
    }

    private static void addHeadersToLogMessage(Set<String> set, HttpHeaders httpHeaders, LoggingEventBuilder loggingEventBuilder, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        HttpHeadersAccessHelper.getRawHeaderMap(httpHeaders).forEach((string, httpHeader) -> {
            if (CONTENT_LENGTH_KEY.equals(string)) {
                return;
            }
            if (set.contains(string)) {
                loggingEventBuilder.addKeyValue(httpHeader.getName(), httpHeader.getValue());
            } else if (!bl2) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(httpHeader.getName());
            }
        });
        if (stringBuilder.length() > 0) {
            loggingEventBuilder.addKeyValue("redactedHeaders", stringBuilder.toString());
        }
    }

    private static String prettyPrintIfNeeded(ClientLogger clientLogger, boolean bl2, String string, String string2) {
        String string3 = string2;
        if (bl2 && string != null && (string.startsWith("application/json") || string.startsWith("text/json"))) {
            try {
                JsonNode jsonNode = PRETTY_PRINTER.readTree(string2);
                string3 = PRETTY_PRINTER.writeValueAsString(jsonNode);
            }
            catch (Exception exception) {
                clientLogger.log(LogLevel.WARNING, () -> "Failed to pretty print JSON", exception);
            }
        }
        return string3;
    }

    private Long getAndLogContentLength(HttpHeaders httpHeaders, LoggingEventBuilder loggingEventBuilder, ClientLogger clientLogger) {
        String string = httpHeaders.getValue(HttpHeaderName.CONTENT_LENGTH);
        if (CoreUtils.isNullOrEmpty(string)) {
            return null;
        }
        try {
            Long l2 = Long.parseLong(string);
            loggingEventBuilder.addKeyValue(CONTENT_LENGTH_KEY, l2);
            return l2;
        }
        catch (NumberFormatException numberFormatException) {
            clientLogger.atInfo().addKeyValue(CONTENT_LENGTH_KEY, string).log("Could not parse the HTTP header content-length", numberFormatException);
            return null;
        }
    }

    private static boolean shouldBodyBeLogged(String string, Long l2) {
        return l2 != null && !"application/octet-stream".equalsIgnoreCase(string) && l2 != 0L && l2 < 16384L;
    }

    private static Integer getRequestRetryCount(Context context) {
        Object object = context.getData(RETRY_COUNT_CONTEXT).orElse(null);
        if (object == null) {
            return null;
        }
        try {
            return Integer.valueOf(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.atInfo().addKeyValue("tryCount", object).log("Could not parse the request retry count.");
            return null;
        }
    }

    private static ClientLogger getOrCreateMethodLogger(Context context) {
        ClientLogger clientLogger = context.getData("caller-method-logger").orElse(null);
        if (clientLogger != null) {
            return clientLogger;
        }
        String string = (String)context.getData("caller-method").orElse("");
        if (CALLER_METHOD_LOGGER_CACHE.size() > 1000) {
            CALLER_METHOD_LOGGER_CACHE.clear();
        }
        return CALLER_METHOD_LOGGER_CACHE.computeIfAbsent(string, ClientLogger::new);
    }

    private static LoggingEventBuilder getLogBuilder(LogLevel logLevel, ClientLogger clientLogger) {
        switch (logLevel) {
            case ERROR: {
                return clientLogger.atError();
            }
            case WARNING: {
                return clientLogger.atWarning();
            }
            case INFORMATIONAL: {
                return clientLogger.atInfo();
            }
        }
        return clientLogger.atVerbose();
    }

    private final class DefaultHttpRequestLogger
    implements HttpRequestLogger {
        private DefaultHttpRequestLogger() {
        }

        @Override
        public Mono<Void> logRequest(ClientLogger clientLogger, HttpRequestLoggingContext httpRequestLoggingContext) {
            this.logRequestSync(clientLogger, httpRequestLoggingContext);
            return Mono.empty();
        }

        @Override
        public void logRequestSync(ClientLogger clientLogger, HttpRequestLoggingContext httpRequestLoggingContext) {
            this.log(this.getLogLevel(httpRequestLoggingContext), clientLogger, httpRequestLoggingContext);
        }

        private void log(LogLevel logLevel, ClientLogger clientLogger, HttpRequestLoggingContext httpRequestLoggingContext) {
            if (!clientLogger.canLogAtLevel(logLevel) || HttpLoggingPolicy.this.httpLogDetailLevel == HttpLogDetailLevel.NONE) {
                return;
            }
            HttpRequest httpRequest = httpRequestLoggingContext.getHttpRequest();
            LoggingEventBuilder loggingEventBuilder = HttpLoggingPolicy.getLogBuilder(logLevel, clientLogger).addKeyValue("method", (Object)httpRequest.getHttpMethod()).addKeyValue("url", HttpLoggingPolicy.this.urlSanitizer.getRedactedUrl(httpRequest.getUrl()));
            Integer n2 = httpRequestLoggingContext.getTryCount();
            if (n2 != null) {
                loggingEventBuilder.addKeyValue("tryCount", n2);
            }
            if (HttpLoggingPolicy.this.httpLogDetailLevel.shouldLogHeaders() && clientLogger.canLogAtLevel(LogLevel.INFORMATIONAL)) {
                HttpLoggingPolicy.addHeadersToLogMessage(HttpLoggingPolicy.this.allowedHeaderNames, httpRequest.getHeaders(), loggingEventBuilder, HttpLoggingPolicy.this.disableRedactedHeaderLogging);
            }
            Long l2 = HttpLoggingPolicy.this.getAndLogContentLength(httpRequest.getHeaders(), loggingEventBuilder, clientLogger);
            if (httpRequest.getBody() == null) {
                loggingEventBuilder.log(HttpLoggingPolicy.REQUEST_LOG_MESSAGE);
                return;
            }
            String string = httpRequest.getHeaders().getValue(HttpHeaderName.CONTENT_TYPE);
            if (HttpLoggingPolicy.this.httpLogDetailLevel.shouldLogBody() && HttpLoggingPolicy.shouldBodyBeLogged(string, l2)) {
                int n3 = l2.intValue();
                HttpLoggingPolicy.this.logBody(httpRequest, n3, loggingEventBuilder, clientLogger, string);
                return;
            }
            loggingEventBuilder.log(HttpLoggingPolicy.REQUEST_LOG_MESSAGE);
        }
    }

    private final class DefaultHttpResponseLogger
    implements HttpResponseLogger {
        private DefaultHttpResponseLogger() {
        }

        @Override
        public Mono<HttpResponse> logResponse(ClientLogger clientLogger, HttpResponseLoggingContext httpResponseLoggingContext) {
            String string;
            LogLevel logLevel = this.getLogLevel(httpResponseLoggingContext);
            HttpResponse httpResponse2 = httpResponseLoggingContext.getHttpResponse();
            if (!clientLogger.canLogAtLevel(logLevel) || HttpLoggingPolicy.this.httpLogDetailLevel == HttpLogDetailLevel.NONE) {
                return Mono.just((Object)httpResponse2);
            }
            LoggingEventBuilder loggingEventBuilder = HttpLoggingPolicy.getLogBuilder(logLevel, clientLogger);
            this.addBasicResponseProperties(clientLogger, httpResponseLoggingContext, httpResponse2, loggingEventBuilder);
            Long l2 = HttpLoggingPolicy.this.getAndLogContentLength(httpResponse2.getHeaders(), loggingEventBuilder, clientLogger);
            Mono mono = Mono.just((Object)httpResponse2);
            if (HttpLoggingPolicy.this.httpLogDetailLevel.shouldLogBody() && HttpLoggingPolicy.shouldBodyBeLogged(string = httpResponse2.getHeaderValue(HttpHeaderName.CONTENT_TYPE), l2)) {
                HttpResponse httpResponse3 = httpResponse2.buffer();
                mono = FluxUtil.collectBytesInByteBufferStream(httpResponse3.getBody()).map(byArray -> {
                    loggingEventBuilder.addKeyValue("body", HttpLoggingPolicy.prettyPrintIfNeeded(clientLogger, HttpLoggingPolicy.this.prettyPrintBody, string, new String((byte[])byArray, StandardCharsets.UTF_8)));
                    return httpResponse3;
                });
            }
            return mono.doOnNext(httpResponse -> loggingEventBuilder.log(HttpLoggingPolicy.RESPONSE_LOG_MESSAGE));
        }

        private void logHeaders(ClientLogger clientLogger, HttpResponse httpResponse, LoggingEventBuilder loggingEventBuilder) {
            if (HttpLoggingPolicy.this.httpLogDetailLevel.shouldLogHeaders() && clientLogger.canLogAtLevel(LogLevel.INFORMATIONAL)) {
                HttpLoggingPolicy.addHeadersToLogMessage(HttpLoggingPolicy.this.allowedHeaderNames, httpResponse.getHeaders(), loggingEventBuilder, HttpLoggingPolicy.this.disableRedactedHeaderLogging);
            }
        }

        private void addBasicResponseProperties(ClientLogger clientLogger, HttpResponseLoggingContext httpResponseLoggingContext, HttpResponse httpResponse, LoggingEventBuilder loggingEventBuilder) {
            loggingEventBuilder.addKeyValue("statusCode", httpResponse.getStatusCode()).addKeyValue("url", HttpLoggingPolicy.this.urlSanitizer.getRedactedUrl(httpResponse.getRequest().getUrl())).addKeyValue("durationMs", httpResponseLoggingContext.getResponseDuration().toMillis());
            HttpLoggingPolicy.this.getAndLogContentLength(httpResponse.getHeaders(), loggingEventBuilder, clientLogger);
            this.logHeaders(clientLogger, httpResponse, loggingEventBuilder);
        }

        @Override
        public HttpResponse logResponseSync(ClientLogger clientLogger, HttpResponseLoggingContext httpResponseLoggingContext) {
            String string;
            LogLevel logLevel = this.getLogLevel(httpResponseLoggingContext);
            HttpResponse httpResponse = httpResponseLoggingContext.getHttpResponse();
            if (!clientLogger.canLogAtLevel(logLevel)) {
                return httpResponse;
            }
            LoggingEventBuilder loggingEventBuilder = HttpLoggingPolicy.getLogBuilder(logLevel, clientLogger);
            this.addBasicResponseProperties(clientLogger, httpResponseLoggingContext, httpResponse, loggingEventBuilder);
            Long l2 = HttpLoggingPolicy.this.getAndLogContentLength(httpResponse.getHeaders(), loggingEventBuilder, clientLogger);
            if (HttpLoggingPolicy.this.httpLogDetailLevel.shouldLogBody() && HttpLoggingPolicy.shouldBodyBeLogged(string = httpResponse.getHeaderValue(HttpHeaderName.CONTENT_TYPE), l2)) {
                httpResponse = httpResponse.buffer();
                loggingEventBuilder.addKeyValue("body", HttpLoggingPolicy.prettyPrintIfNeeded(clientLogger, HttpLoggingPolicy.this.prettyPrintBody, string, httpResponse.getBodyAsBinaryData().toString()));
            }
            loggingEventBuilder.log(HttpLoggingPolicy.RESPONSE_LOG_MESSAGE);
            return httpResponse;
        }
    }
}

